DROP TABLE IF EXISTS `adm_chat`;

CREATE TABLE `adm_chat` (
  `id` int(18) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `time` varchar(19) NOT NULL,
  `komy` int(18) NOT NULL,
  `adm` int(1) DEFAULT '0',
  `vip` int(1) DEFAULT '0',
  `usid` int(18) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `anketa`;

CREATE TABLE `anketa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `id_us` int(11) DEFAULT NULL,
  `inf` varchar(100) DEFAULT NULL,
  `familu` varchar(20) DEFAULT NULL,
  `strana` varchar(20) DEFAULT NULL,
  `gorod` varchar(35) DEFAULT NULL,
  `icq` varchar(20) DEFAULT NULL,
  `data` varchar(50) NOT NULL DEFAULT '0',
  `music` varchar(500) DEFAULT NULL,
  `int` varchar(500) DEFAULT NULL,
  `vk` varchar(40) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `spaces` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `arena`;

CREATE TABLE `arena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `hp_user` int(11) NOT NULL,
  `sop_id` int(11) NOT NULL,
  `hp_sop` int(11) NOT NULL,
  `boy` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `artefact`;

CREATE TABLE `artefact` (
  `artefact_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `stats_yron` int(11) NOT NULL,
  `max_stats_tochn` int(11) NOT NULL,
  `min_stats_tochn` int(11) NOT NULL,
  `stats_safety` int(11) NOT NULL DEFAULT '0',
  `hp` int(11) NOT NULL,
  `bronya` int(11) NOT NULL,
  `screen` varchar(20) NOT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL DEFAULT '0',
  `klass` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`artefact_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO artefact VALUES("1","Выверт","15","10","5","2","10","1","vivert.gif","-1","400","2","1");
INSERT INTO artefact VALUES("2","Грави","30","20","10","6","20","2","gravy.gif","-1","700","4","1");
INSERT INTO artefact VALUES("3","Золотая рыбка","55","20","10","6","30","10","goldfish.gif","-1","1100","5","1");
INSERT INTO artefact VALUES("4","Капля","250","60","20","13","40","30","dot.gif","300","3000","7","1");
INSERT INTO artefact VALUES("5","Огненный шар","250","95","50","15","60","10","fireball.gif","400","4000","7","2");
INSERT INTO artefact VALUES("6","Кристалл","100","125","70","30","50","60","crystall.gif","700","-1","8","2");
INSERT INTO artefact VALUES("7","Слизь","200","350","75","40","65","60","slime.gif","1500","15000","9","2");
INSERT INTO artefact VALUES("8","Слизняк","440","400","100","45","80","65","slimer.gif","3800","38000","10","2");
INSERT INTO artefact VALUES("9","Слюда","500","450","80","70","75","70","sluda.gif","5500","-1","10","2");
INSERT INTO artefact VALUES("10","Бенгальский огон","550","500","150","110","90","75","bengalfire.gif","10000","100000","10","2");



DROP TABLE IF EXISTS `auction`;

CREATE TABLE `auction` (
  `id_lot` bigint(20) NOT NULL AUTO_INCREMENT,
  `thing_id` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `price` int(11) NOT NULL DEFAULT '0',
  `price_now` int(11) NOT NULL DEFAULT '0',
  `price_user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_lot`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO auction VALUES("1","28","1","2015-10-28 06:00:12","2000","1500","0");



DROP TABLE IF EXISTS `bar`;

CREATE TABLE `bar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `namest` varchar(255) NOT NULL,
  `opis` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `cena` int(11) NOT NULL,
  `massa` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO bar VALUES("1","Хлеб","hleb","Восстановление здоровья \n<b>+20</b>\nНасыщение<b> +6</b>","hleb.png","200","0.3");
INSERT INTO bar VALUES("2","Колбаса «Диетическая»","kolbasa","Восстановление здоровья <b>+20</b> \nНасыщение <b>+10</b>","kolbasa.png","300","0.5");
INSERT INTO bar VALUES("3","Консерва «Завтрак туриста»","konserv","Восстановление здоровья <b>+20</b> \nНасыщение <b>+10</b>\n","konserv.png","1000","0.4");



DROP TABLE IF EXISTS `bbcode`;

CREATE TABLE `bbcode` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(1024) NOT NULL,
  `code` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO bbcode VALUES("41","<i>","[i]");
INSERT INTO bbcode VALUES("42","</i>","[/i]");



DROP TABLE IF EXISTS `bitva`;

CREATE TABLE `bitva` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clan_id` int(11) NOT NULL,
  `clan_pr_id` int(11) NOT NULL,
  `start` int(11) NOT NULL,
  `time_start` int(11) NOT NULL,
  `time_proruv` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_ban`;

CREATE TABLE `clan_ban` (
  `id` int(18) NOT NULL,
  `usid` int(18) NOT NULL,
  `time` int(18) NOT NULL,
  `clan` varchar(200) NOT NULL,
  `prich` varchar(400) NOT NULL,
  `usban` int(18) NOT NULL,
  `type` enum('clan_chat') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_chat`;

CREATE TABLE `clan_chat` (
  `chat_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `rang` int(11) NOT NULL,
  `clan_id` int(11) NOT NULL,
  `say` varchar(256) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`chat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_log`;

CREATE TABLE `clan_log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `user` varchar(20) NOT NULL,
  `user_id` int(11) NOT NULL,
  `tip` int(11) NOT NULL,
  `clan_id` int(11) NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_opit`;

CREATE TABLE `clan_opit` (
  `lvl` int(11) NOT NULL,
  `opit` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO clan_opit VALUES("1","0");
INSERT INTO clan_opit VALUES("2","10000");
INSERT INTO clan_opit VALUES("3","25000");
INSERT INTO clan_opit VALUES("4","54421");
INSERT INTO clan_opit VALUES("5","81274");
INSERT INTO clan_opit VALUES("8","321754");
INSERT INTO clan_opit VALUES("7","207887");
INSERT INTO clan_opit VALUES("9","492576");
INSERT INTO clan_opit VALUES("6","131876");
INSERT INTO clan_opit VALUES("10","610000");
INSERT INTO clan_opit VALUES("11","800000");
INSERT INTO clan_opit VALUES("12","1200000");
INSERT INTO clan_opit VALUES("13","1500000");
INSERT INTO clan_opit VALUES("14","1800000");



DROP TABLE IF EXISTS `clans`;

CREATE TABLE `clans` (
  `clan_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) DEFAULT NULL,
  `gruppa` varchar(16) NOT NULL,
  `slava` int(11) NOT NULL DEFAULT '0',
  `nadpis` varchar(500) DEFAULT NULL,
  `clan_opit` bigint(11) NOT NULL DEFAULT '0',
  `mentor` int(11) NOT NULL DEFAULT '0',
  `ad` varchar(251) DEFAULT NULL,
  `ad_nick` varchar(16) DEFAULT NULL,
  `people` int(11) NOT NULL DEFAULT '1',
  `max_people` int(11) NOT NULL DEFAULT '5',
  `ava` varchar(100) NOT NULL,
  `habar` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `gauss` int(11) NOT NULL,
  `gauss_yron` int(11) NOT NULL,
  `minut` int(11) NOT NULL,
  `bitva` int(11) NOT NULL,
  `bitva_time` int(11) NOT NULL,
  `proruv_time` int(11) NOT NULL,
  PRIMARY KEY (`clan_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO clans VALUES("1","Administration","naemniki","0","","60540","0","","","1","5","1.jpg","0","5000","0","0","0","0","0","0");



DROP TABLE IF EXISTS `clothes`;

CREATE TABLE `clothes` (
  `clothes_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `max_stats_bronya` int(11) NOT NULL,
  `min_stats_bronya` int(11) NOT NULL,
  `max_stats_hp` int(11) NOT NULL,
  `min_stats_hp` int(11) NOT NULL,
  `max_stats_rad` int(11) NOT NULL DEFAULT '10',
  `min_stats_rad` int(11) NOT NULL DEFAULT '10',
  `screen` varchar(20) NOT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL DEFAULT '0',
  `klass` int(11) NOT NULL DEFAULT '1',
  `max_stats_razriv` int(11) NOT NULL DEFAULT '0',
  `min_stats_razriv` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`clothes_id`)
) ENGINE=MyISAM AUTO_INCREMENT=237 DEFAULT CHARSET=utf8;

INSERT INTO clothes VALUES("1","Кольчуга Риа","250","100","450","225","10","1","13.png","-1","200","1","1","150","50");
INSERT INTO clothes VALUES("3","Выправка Роланда","2000","1500","4000","3500","30","20","3.png","1500","25000","15","6","2000","1500");
INSERT INTO clothes VALUES("4","Кираса Аккана","3200","2500","4500","4000","40","30","2.png","3200","50500","16","3","2500","2000");
INSERT INTO clothes VALUES("5","Мир нефритового жнеца","2500","2000","5700","5000","40","30","4.png","4500","75500","17","3","3000","2500");
INSERT INTO clothes VALUES("6","Мундир адского зуба","3500","2500","7000","6500","50","60","44.gif","6200","-1","18","8","3500","3000");
INSERT INTO clothes VALUES("7","Кираса Пустошей","4700","3500","7350","6800","65","60","7.png","7500","100000","19","3","4000","3500");
INSERT INTO clothes VALUES("9","Панцирь Арахира","7999","7500","8999","7500","72","89","5.png","11500","-1","21","4","5999","4500");
INSERT INTO clothes VALUES("10","Панцирь мародера","8499","8000","9499","8000","78","72","65.gif","12500","-1","22","8","6499","5000");
INSERT INTO clothes VALUES("11","Сущность Зунимассы","9999","8500","9999","8500","85","78","6.png","17000","-1","23","4","7999","5500");
INSERT INTO clothes VALUES("12","Перевязь Истины","10499","9000","9499","8000","95","85","8.png","17000","-1","24","4","8499","6500");
INSERT INTO clothes VALUES("13","Проклятие тени","11999","9500","10999","9500","95","99","12.png","27000","-1","25","4","9999","7786");
INSERT INTO clothes VALUES("14","Железное сердце","300","150","350","100","5","1","1b.gif","-1","300","1","1","400","200");
INSERT INTO clothes VALUES("15","Владычество Огильда","800","750","750","600","15","5","1c.gif","-1","2500","3","2","800","600");
INSERT INTO clothes VALUES("16","Хаори Ши Мидзу","1700","1300","2900","2400","30","10","1n.gif","-1","7000","6","6","1700","1400");
INSERT INTO clothes VALUES("17","Бесконечный простор","2300","2000","3400","2700","35","10","48.gif","-1","10100","9","2","1900","1700");
INSERT INTO clothes VALUES("19","Сердце демона","12400","8600","12000","8500","450","300","geena.gif","35000","-1","27","4","12000","8500");
INSERT INTO clothes VALUES("23","Кираса Акилы","920","500","940","500","10","3","1.png","-1","500","2","1","900","500");
INSERT INTO clothes VALUES("24","Грубая кольчуга","150","100","450","300","5","1","1r.gif","-1","500","2","1","400","200");
INSERT INTO clothes VALUES("27","Мощь Тира","6999","6500","7999","6500","150","99","1.gif","9000","170000","20","3","4999","3500");
INSERT INTO clothes VALUES("229","Одеяния ридраэлмов","15000","11000","15000","11500","450","300","92.gif","40000","-1","30","8","7000","6500");
INSERT INTO clothes VALUES("26","Вечное правление","1500","1000","2500","2000","20","10","1d.gif","-1","15000","12","2","1500","1000");
INSERT INTO clothes VALUES("232","Облачение ридраэлмов","16999","12000","17100","13500","650","450","1u.gif","75000","-1","30","4","8432","7352");
INSERT INTO clothes VALUES("231","Мастерский латный доспех","18999","14000","19100","15500","950","750","1v.gif","100000","-1","33","4","10000","8500");
INSERT INTO clothes VALUES("233","Бесподобная балорова","18999","14000","19100","15500","950","750","1a.gif","150000","-1","37","4","12000","9500");
INSERT INTO clothes VALUES("234","Накидка Блекторна","28999","24000","29100","25500","1450","1150","1t.gif","250000","-1","40","4","15000","13000");



DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `id_com` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_top` bigint(20) DEFAULT NULL,
  `avtor` bigint(20) DEFAULT NULL,
  `text` varchar(1024) DEFAULT NULL,
  `time_cre` datetime DEFAULT NULL,
  `news` int(11) NOT NULL,
  PRIMARY KEY (`id_com`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `detectors`;

CREATE TABLE `detectors` (
  `det_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(500) DEFAULT NULL,
  `screen` varchar(50) DEFAULT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL,
  `sh_nahod` int(11) NOT NULL,
  `anom` int(11) NOT NULL,
  `sh_dost` int(11) NOT NULL,
  `progress` int(11) NOT NULL,
  PRIMARY KEY (`det_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO detectors VALUES("1","Отклик","otklik.gif","250","50000","10","25","75","25","2");



DROP TABLE IF EXISTS `dost`;

CREATE TABLE `dost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dost_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `my_id` int(11) NOT NULL,
  `text` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO events VALUES("1","4","<span class=\"bonus\">Вы напали на сталкера</span> zaetcz</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 8 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("2","2","<span class=\"blue\">На вас напал сталкер </span> Tmatemnaya</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 8 хабара</span></p>");
INSERT INTO events VALUES("3","18","<span class=\"bonus\">Вы напали на сталкера</span> 11111111122</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 37 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("4","15","<span class=\"blue\">На вас напал сталкер </span> Ghost1994</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 37 хабара</span></p>");
INSERT INTO events VALUES("5","19","<span class=\"bonus\">Вы напали на сталкера</span> Zexolus</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 208 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("6","3","<span class=\"blue\">На вас напал сталкер </span> Alzair</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 208 хабара</span></p>");
INSERT INTO events VALUES("7","17","<span class=\"bonus\">Вы напали на сталкера</span> Alleks</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 77 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("8","20","<span class=\"blue\">На вас напал сталкер </span> Виктория</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 77 хабара</span></p>");
INSERT INTO events VALUES("9","19","<span class=\"bonus\">Вы напали на сталкера</span> zaetcz</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 176 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("10","2","<span class=\"blue\">На вас напал сталкер </span> Alzair</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 176 хабара</span></p>");
INSERT INTO events VALUES("11","21","<span class=\"bonus\">Вы напали на сталкера</span> Tmatemnaya</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 56 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("12","4","<span class=\"blue\">На вас напал сталкер </span> Vikysya2015</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 56 хабара</span></p>");
INSERT INTO events VALUES("13","20","<span class=\"bonus\">Вы напали на сталкера</span> Alzair</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 46 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("14","19","<span class=\"blue\">На вас напал сталкер </span> Alleks</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 46 хабара</span></p>");
INSERT INTO events VALUES("15","21","<span class=\"bonus\">Вы напали на сталкера</span> zaetcz</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 27 хабара</span></p>");
INSERT INTO events VALUES("16","2","<span class=\"blue\">На вас напал сталкер </span> Vikysya2015</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 27 хабара</span></p>");
INSERT INTO events VALUES("17","20","<span class=\"bonus\">Вы напали на сталкера</span> Vikysya2015</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 63 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("18","21","<span class=\"blue\">На вас напал сталкер </span> Alleks</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 63 хабара</span></p>");
INSERT INTO events VALUES("19","21","<span class=\"bonus\">Вы напали на сталкера</span> Виктория</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 44 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("20","17","<span class=\"blue\">На вас напал сталкер </span> Vikysya2015</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 44 хабара</span></p>");
INSERT INTO events VALUES("21","3","<span class=\"bonus\">Вы напали на сталкера</span> Alzair</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 246 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("22","2","<span class=\"blue\">На вас напал сталкер </span> Шквал</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 246 хабара</span></p>");
INSERT INTO events VALUES("23","7","<span class=\"bonus\">Вы напали на сталкера</span> Harley Davidson</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 13 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("24","5","<span class=\"blue\">На вас напал сталкер </span> Пророк</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 13 хабара</span></p>");
INSERT INTO events VALUES("25","7","<span class=\"bonus\">Вы напали на сталкера</span> Harley Davidson</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 13 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("26","5","<span class=\"blue\">На вас напал сталкер </span> Пророк</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 13 хабара</span></p>");
INSERT INTO events VALUES("27","7","<span class=\"bonus\">Вы напали на сталкера</span> Dragon Sad_Wind</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 90 хабара и получили 1 славы.</span></p>");
INSERT INTO events VALUES("28","4","<span class=\"blue\">На вас напал сталкер </span> Пророк</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 90 хабара</span></p>");
INSERT INTO events VALUES("29","7","<span class=\"bonus\">Вы напали на сталкера</span> Alzair</br><span class=\"gold\">Вы победили!</span></br><span class=\"white\">Вы отобрали: 669 хабара и получили 2 славы.</span></p>");
INSERT INTO events VALUES("30","2","<span class=\"blue\">На вас напал сталкер </span> Пророк</br><span class=\"red\">Вас ограбили</span></br><span class=\"white\">Потери: 669 хабара</span></p>");



DROP TABLE IF EXISTS `friend`;

CREATE TABLE `friend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `frend_id` int(11) NOT NULL,
  `tip` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `general_chat`;

CREATE TABLE `general_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` varchar(24) NOT NULL,
  `text` varchar(300) NOT NULL,
  `date` varchar(19) NOT NULL,
  `userid` int(11) NOT NULL,
  `gruppa` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_rating`;

CREATE TABLE `guest_rating` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_post` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ignor`;

CREATE TABLE `ignor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) DEFAULT NULL,
  `kogo` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `in_clan`;

CREATE TABLE `in_clan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `user_id_in` varchar(16) NOT NULL,
  `clan_name` varchar(16) NOT NULL,
  `clan_id` int(11) NOT NULL,
  `id_in` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `intopics`;

CREATE TABLE `intopics` (
  `user_id` bigint(20) DEFAULT NULL,
  `topic` bigint(20) DEFAULT NULL,
  `time_up` datetime DEFAULT NULL,
  `page` int(11) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO intopics VALUES("1","1","2015-10-27 04:48:35","1");
INSERT INTO intopics VALUES("3","1","2015-10-27 07:51:16","1");
INSERT INTO intopics VALUES("6","1","2015-10-27 08:54:41","1");
INSERT INTO intopics VALUES("7","1","2015-10-27 13:36:25","1");
INSERT INTO intopics VALUES("2","1","2015-10-27 18:01:44","1");
INSERT INTO intopics VALUES("8","1","2015-10-27 17:58:05","1");
INSERT INTO intopics VALUES("2","2","2015-10-28 03:47:24","1");



DROP TABLE IF EXISTS `invite`;

CREATE TABLE `invite` (
  `id_inv` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(32) DEFAULT NULL,
  `id_invite` int(11) DEFAULT NULL,
  `iz` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id_inv`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO invite VALUES("5","185.26.180.224","2","http://impwar.tk/login.php?inv=2");
INSERT INTO invite VALUES("4","178.137.250.254","2","http://evigames.tk/");
INSERT INTO invite VALUES("6","83.220.239.65","0","http://www.impwar.tk/login.php");
INSERT INTO invite VALUES("9","141.0.12.243","0","http://impwar.tk/login.php");
INSERT INTO invite VALUES("10","176.59.86.170","0","");
INSERT INTO invite VALUES("12","141.0.13.130","2","http://impwar.tk/login.php?inv=2");
INSERT INTO invite VALUES("15","82.145.220.132","0","http://impwar.tk/index.php");
INSERT INTO invite VALUES("16","31.13.144.49","0","http://impwar.tk/login.php");
INSERT INTO invite VALUES("17","185.26.180.158","0","http://impwar.tk/index.php");
INSERT INTO invite VALUES("18","185.26.180.26","0","http://www.impwar.tk/login.php");
INSERT INTO invite VALUES("19","46.0.96.1","0","http://impwar.tk/login.php");
INSERT INTO invite VALUES("20","189.5.54.131","0","http://impwar.tk/");
INSERT INTO invite VALUES("21","31.13.144.39","0","http://impwar.tk/");
INSERT INTO invite VALUES("22","176.98.13.160","0","http://impwar.tk/login.php");
INSERT INTO invite VALUES("24","82.145.223.9","0","http://impwar.tk/index.php");
INSERT INTO invite VALUES("26","66.249.75.23","0","");
INSERT INTO invite VALUES("27","66.249.75.39","0","");
INSERT INTO invite VALUES("28","46.0.64.24","0","http://impwar.tk/login.php");
INSERT INTO invite VALUES("30","195.78.101.66","0","http://impwar.tk/bonus.php");



DROP TABLE IF EXISTS `kalancha`;

CREATE TABLE `kalancha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usr` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `kapital` int(20) NOT NULL,
  `proig` int(20) NOT NULL,
  `viig` int(20) NOT NULL,
  `alm` int(20) NOT NULL,
  `time` int(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=289 DEFAULT CHARSET=latin1;

INSERT INTO kalancha VALUES("1","1","985","2640","3185","0","0");
INSERT INTO kalancha VALUES("164","","0","220","150","0","0");
INSERT INTO kalancha VALUES("202","","0","200","200","0","0");
INSERT INTO kalancha VALUES("158","","0","0","0","0","0");
INSERT INTO kalancha VALUES("117","","0","0","0","0","0");
INSERT INTO kalancha VALUES("171","","100","180","100","0","0");
INSERT INTO kalancha VALUES("70","","0","134","35","0","0");
INSERT INTO kalancha VALUES("10","","0","70","0","0","0");
INSERT INTO kalancha VALUES("143","","0","55","0","0","0");
INSERT INTO kalancha VALUES("83","","0","240","50","0","0");
INSERT INTO kalancha VALUES("108","","0","210","50","0","0");
INSERT INTO kalancha VALUES("12","","0","695","1400","0","0");
INSERT INTO kalancha VALUES("110","","0","60","0","0","0");
INSERT INTO kalancha VALUES("126","","0","150","0","0","0");
INSERT INTO kalancha VALUES("172","","0","0","0","0","0");
INSERT INTO kalancha VALUES("139","","0","360","0","0","0");
INSERT INTO kalancha VALUES("163","","231","215","231","0","0");
INSERT INTO kalancha VALUES("176","","0","250","50","0","0");
INSERT INTO kalancha VALUES("213","","0","0","0","0","0");
INSERT INTO kalancha VALUES("42","","0","40","0","0","0");
INSERT INTO kalancha VALUES("13","","150","400","150","0","0");
INSERT INTO kalancha VALUES("40","","0","60","0","0","0");
INSERT INTO kalancha VALUES("183","","50","690","550","0","0");
INSERT INTO kalancha VALUES("137","","0","0","0","0","0");
INSERT INTO kalancha VALUES("32","","100","180","100","0","0");
INSERT INTO kalancha VALUES("209","","0","0","0","0","0");
INSERT INTO kalancha VALUES("73","","0","360","350","0","0");
INSERT INTO kalancha VALUES("180","","0","450","525","0","0");
INSERT INTO kalancha VALUES("101","","0","210","200","0","0");
INSERT INTO kalancha VALUES("64","","0","39","100","0","0");
INSERT INTO kalancha VALUES("125","","0","100","50","0","0");
INSERT INTO kalancha VALUES("210","","0","20","50","0","0");
INSERT INTO kalancha VALUES("166","","0","0","0","0","0");
INSERT INTO kalancha VALUES("3","","0","100","0","0","0");
INSERT INTO kalancha VALUES("165","","0","0","0","0","0");
INSERT INTO kalancha VALUES("190","","10","4","10","0","0");
INSERT INTO kalancha VALUES("118","","0","150","250","0","0");
INSERT INTO kalancha VALUES("29","","50","60","50","0","0");
INSERT INTO kalancha VALUES("47","","375","1500","375","0","0");
INSERT INTO kalancha VALUES("75","","0","600","315","0","0");
INSERT INTO kalancha VALUES("218","","0","0","0","0","0");
INSERT INTO kalancha VALUES("113","","0","0","0","0","0");
INSERT INTO kalancha VALUES("214","","0","0","0","0","0");
INSERT INTO kalancha VALUES("211","","90","220","90","0","0");
INSERT INTO kalancha VALUES("217","","0","2090","2020","0","0");
INSERT INTO kalancha VALUES("219","","100","40","100","0","0");
INSERT INTO kalancha VALUES("89","","0","290","160","0","0");
INSERT INTO kalancha VALUES("243","","0","34","0","0","0");
INSERT INTO kalancha VALUES("191","","158","260","158","0","0");
INSERT INTO kalancha VALUES("220","","0","0","0","0","0");
INSERT INTO kalancha VALUES("96","","100","178","100","0","0");
INSERT INTO kalancha VALUES("229","","0","0","0","0","0");
INSERT INTO kalancha VALUES("114","","0","0","0","0","0");
INSERT INTO kalancha VALUES("123","","0","0","0","0","0");
INSERT INTO kalancha VALUES("155","","0","0","0","0","0");
INSERT INTO kalancha VALUES("233","","0","0","0","0","0");
INSERT INTO kalancha VALUES("78","","0","5","0","0","0");
INSERT INTO kalancha VALUES("156","","13","19","13","0","0");
INSERT INTO kalancha VALUES("128","","0","0","0","0","0");
INSERT INTO kalancha VALUES("236","","50","20","50","0","0");
INSERT INTO kalancha VALUES("231","","25","20","25","0","0");
INSERT INTO kalancha VALUES("239","","0","0","0","0","0");
INSERT INTO kalancha VALUES("235","","0","0","0","0","0");
INSERT INTO kalancha VALUES("133","","50","150","50","0","0");
INSERT INTO kalancha VALUES("242","","0","100","0","0","0");
INSERT INTO kalancha VALUES("244","","0","0","0","0","0");
INSERT INTO kalancha VALUES("81","","0","0","0","0","0");
INSERT INTO kalancha VALUES("130","","0","0","0","0","0");
INSERT INTO kalancha VALUES("31","","0","0","0","0","0");
INSERT INTO kalancha VALUES("178","","50","270","150","0","0");
INSERT INTO kalancha VALUES("230","","0","0","0","0","0");
INSERT INTO kalancha VALUES("150","","150","250","150","0","0");
INSERT INTO kalancha VALUES("251","","0","0","0","0","0");
INSERT INTO kalancha VALUES("38","","150","380","150","0","0");
INSERT INTO kalancha VALUES("254","","0","0","0","0","0");
INSERT INTO kalancha VALUES("19","","0","705","410","0","0");
INSERT INTO kalancha VALUES("63","","0","0","0","0","0");
INSERT INTO kalancha VALUES("261","","50","20","50","0","0");
INSERT INTO kalancha VALUES("189","","0","0","0","0","0");
INSERT INTO kalancha VALUES("250","","225","130","225","0","0");
INSERT INTO kalancha VALUES("186","","500","200","500","0","0");
INSERT INTO kalancha VALUES("255","","150","140","150","0","0");
INSERT INTO kalancha VALUES("74","","0","0","0","0","0");
INSERT INTO kalancha VALUES("57","","0","0","0","0","0");
INSERT INTO kalancha VALUES("112","","0","35","0","0","0");
INSERT INTO kalancha VALUES("240","","0","20","50","0","0");
INSERT INTO kalancha VALUES("140","","0","280","100","0","0");
INSERT INTO kalancha VALUES("249","","50","40","50","0","0");
INSERT INTO kalancha VALUES("275","","0","50","0","0","0");
INSERT INTO kalancha VALUES("278","","0","20","0","0","0");
INSERT INTO kalancha VALUES("273","","0","20","0","0","0");
INSERT INTO kalancha VALUES("281","","0","0","0","0","0");
INSERT INTO kalancha VALUES("283","","120","60","120","0","0");
INSERT INTO kalancha VALUES("274","","0","0","0","0","0");
INSERT INTO kalancha VALUES("288","","135","140","135","0","0");
INSERT INTO kalancha VALUES("2","","0","100","250","0","0");
INSERT INTO kalancha VALUES("124","","0","0","0","0","0");
INSERT INTO kalancha VALUES("4","","0","500","310","0","0");
INSERT INTO kalancha VALUES("18","","0","24","0","0","0");
INSERT INTO kalancha VALUES("17","","0","200","250","0","0");
INSERT INTO kalancha VALUES("21","","0","100","0","0","0");
INSERT INTO kalancha VALUES("20","","0","0","0","0","0");
INSERT INTO kalancha VALUES("5","","0","20","0","0","0");
INSERT INTO kalancha VALUES("7","","0","50000","32800","0","0");



DROP TABLE IF EXISTS `komplekt`;

CREATE TABLE `komplekt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `lvl` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO komplekt VALUES("1","Комплект Ученика","5");
INSERT INTO komplekt VALUES("2","Комплект Охотника","11");
INSERT INTO komplekt VALUES("3","Комплект Ополченца","16");
INSERT INTO komplekt VALUES("4","Комплект Берсерка","23");
INSERT INTO komplekt VALUES("5","Комплект Воина","29");
INSERT INTO komplekt VALUES("6","Комплект Искателя","35");
INSERT INTO komplekt VALUES("7","Комплект Рыцаря","41");
INSERT INTO komplekt VALUES("8","Комплект Атланта","47");
INSERT INTO komplekt VALUES("9","Комплект Палладина","53");
INSERT INTO komplekt VALUES("10","Комплект Ассасина","59");
INSERT INTO komplekt VALUES("11","Комплект Титана","65");
INSERT INTO komplekt VALUES("12","Комплект Ветерана","71");



DROP TABLE IF EXISTS `location`;

CREATE TABLE `location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location_name` varchar(20) DEFAULT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `count_now` int(11) NOT NULL DEFAULT '0',
  `lvl_to` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL,
  `bp_gruppa` varchar(16) DEFAULT NULL,
  `bp_count` int(11) DEFAULT NULL,
  `bp_count_now` int(11) DEFAULT NULL,
  `bp_count_grouppa` varchar(16) DEFAULT NULL,
  `bronya` int(11) NOT NULL,
  `habar_ot` int(11) NOT NULL,
  `habar_do` int(11) NOT NULL,
  `radiation` int(11) NOT NULL DEFAULT '10',
  PRIMARY KEY (`location_id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

INSERT INTO location VALUES("1","kordon1","500","312","19","10","naemniki","500","312","dolg","500","350","400","5");
INSERT INTO location VALUES("2","kordon2","500","0","19","10","svoboda","500","0","svoboda","500","450","500","3");
INSERT INTO location VALUES("3","kordon3","500","0","19","10","dolg","500","0","dolg","500","450","500","6");
INSERT INTO location VALUES("4","kordon4","500","0","19","10","dolg","500","0","dolg","500","450","500","4");
INSERT INTO location VALUES("5","svalka1","1000","0","24","15","naemniki","1000","0","naemniki","800","550","650","25");
INSERT INTO location VALUES("6","svalka2","1000","0","24","15","chistoenebo","1000","0","chistoenebo","800","540","650","25");
INSERT INTO location VALUES("7","svalka3","1000","0","24","15","dolg","1000","0","dolg","800","550","650","25");
INSERT INTO location VALUES("8","svalka4","1000","0","24","15","chistoenebo","1000","0","chistoenebo","800","550","650","25");
INSERT INTO location VALUES("9","agroprom1","5000","0","27","20","naemniki","5000","0","naemniki","1000","700","850","63");
INSERT INTO location VALUES("10","agroprom2","5000","4128","27","20","chistoenebo","5000","0","chistoenebo","1000","700","850","63");
INSERT INTO location VALUES("11","agroprom3","5000","628","27","20","renegat","5000","0","renegat","1000","700","850","63");
INSERT INTO location VALUES("12","agroprom4","5000","789","27","20","chistoenebo","5000","789","svoboda","1000","700","850","63");
INSERT INTO location VALUES("13","agroprom5","5000","2546","27","20","chistoenebo","5000","0","chistoenebo","1000","700","850","63");
INSERT INTO location VALUES("14","agroprom6","5000","4125","27","20","dolg","5000","0","dolg","1000","700","850","63");
INSERT INTO location VALUES("15","yantar1","10000","0","30","25","naemniki","10000","0","naemniki","1500","1000","1270","90");
INSERT INTO location VALUES("16","yantar2","10000","2827","30","25","chistoenebo","10000","0","chistoenebo","1500","1000","1280","90");
INSERT INTO location VALUES("17","yantar3","10000","0","30","25","chistoenebo","10000","0","chistoenebo","1500","1000","1290","90");
INSERT INTO location VALUES("18","yantar4","10000","2862","30","25","chistoenebo","10000","0","chistoenebo","1500","1000","1300","90");
INSERT INTO location VALUES("19","yantar5","10000","0","30","25","chistoenebo","10000","0","naemniki","1500","1000","1310","90");
INSERT INTO location VALUES("20","yantar6","10000","0","30","25","chistoenebo","10000","0","naemniki","1500","1000","1320","90");
INSERT INTO location VALUES("21","voensklad1","15000","7521","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2350","90");
INSERT INTO location VALUES("22","voensklad2","15000","4297","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2360","90");
INSERT INTO location VALUES("23","voensklad3","15000","0","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2370","90");
INSERT INTO location VALUES("24","voensklad4","15000","9715","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2380","90");
INSERT INTO location VALUES("25","voensklad5","15000","0","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2390","90");
INSERT INTO location VALUES("26","voensklad6","15000","0","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2400","90");
INSERT INTO location VALUES("27","voensklad7","15000","0","34","28","chistoenebo","15000","0","chistoenebo","2000","2000","2500","115");
INSERT INTO location VALUES("28","pripyat1","20000","0","50","31","dolg","20000","0","naemniki","2500","3000","5440","113");
INSERT INTO location VALUES("29","pripyat2","20000","0","50","31","svoboda","20000","0","naemniki","2500","3000","5450","113");
INSERT INTO location VALUES("30","pripyat3","20000","0","50","31","dolg","20000","0","dolg","2500","3000","5460","113");
INSERT INTO location VALUES("31","pripyat4","20000","0","50","31","dolg","20000","0","naemniki","2500","3470","6470","113");
INSERT INTO location VALUES("32","pripyat5","20000","0","50","31","dolg","20000","0","naemniki","2500","3480","6480","113");
INSERT INTO location VALUES("33","pripyat6","20000","0","50","31","dolg","20000","0","naemniki","2500","3490","6490","113");
INSERT INTO location VALUES("34","pripyat7","20000","0","50","31","dolg","20000","0","naemniki","2500","3500","7000","113");
INSERT INTO location VALUES("35","pripyat8","20000","0","50","31","dolg","20000","0","naemniki","2500","3510","7510","113");
INSERT INTO location VALUES("36","pripyat9","20000","0","50","31","dolg","20000","0","naemniki","2500","3520","7520","113");
INSERT INTO location VALUES("37","pripyat10","20000","0","50","31","dolg","20000","0","dolg","2500","4000","8000","113");
INSERT INTO location VALUES("38","chaes1","10000","0","50","40","svoboda","10000","0","naemniki","3500","12000","16000","140");
INSERT INTO location VALUES("39","chaes2","10000","0","50","40","svoboda","10000","0","naemniki","3500","13000","17800","143");
INSERT INTO location VALUES("40","chaes3","10000","0","50","40","svoboda","10000","0","naemniki","3500","15000","20000","137");
INSERT INTO location VALUES("41","chaes4","10000","0","50","40","svoboda","10000","0","naemniki","3500","20000","25000","156");
INSERT INTO location VALUES("42","study","10000","3009","4","0","x","10000","0","x","0","5","10","0");
INSERT INTO location VALUES("43","base","300","0","14","0","naemniki","300","0","naemniki","300","200","300","0");
INSERT INTO location VALUES("44","secret","7000","2192","50","1","svoboda","3500","534","naemniki","1000","550","550","10");



DROP TABLE IF EXISTS `log`;

CREATE TABLE `log` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `time` datetime NOT NULL,
  `user_id` int(11) NOT NULL,
  `sboitie` int(11) NOT NULL,
  `thing` int(11) NOT NULL DEFAULT '0',
  `yron` int(11) NOT NULL DEFAULT '0',
  `location` varchar(32) NOT NULL DEFAULT 'all',
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1419 DEFAULT CHARSET=utf8;

INSERT INTO log VALUES("1","2015-10-27 03:39:59","1","7","0","74","all");
INSERT INTO log VALUES("2","2015-10-27 03:40:05","1","7","0","73","all");
INSERT INTO log VALUES("3","2015-10-27 03:40:11","1","6","0","3","all");
INSERT INTO log VALUES("4","2015-10-27 03:40:11","1","12","3","148","all");
INSERT INTO log VALUES("5","2015-10-27 03:40:12","3","10","1","9","all");
INSERT INTO log VALUES("6","2015-10-27 03:40:14","3","10","1","9","all");
INSERT INTO log VALUES("7","2015-10-27 03:40:16","3","10","1","9","all");
INSERT INTO log VALUES("8","2015-10-27 03:40:18","3","10","0","5918","all");
INSERT INTO log VALUES("9","2015-10-27 03:40:18","3","11","0","0","all");
INSERT INTO log VALUES("10","2015-10-27 03:40:28","1","6","0","5","all");
INSERT INTO log VALUES("11","2015-10-27 03:40:28","1","12","3","781","all");
INSERT INTO log VALUES("12","2015-10-27 03:40:28","1","13","3","0","all");
INSERT INTO log VALUES("13","2015-10-27 03:48:36","1","6","0","6","all");
INSERT INTO log VALUES("14","2015-10-27 03:48:36","1","12","3","792","all");
INSERT INTO log VALUES("15","2015-10-27 03:48:36","1","13","3","0","all");
INSERT INTO log VALUES("16","2015-10-27 03:51:50","1","7","0","259","all");
INSERT INTO log VALUES("17","2015-10-27 03:51:57","1","7","0","260","all");
INSERT INTO log VALUES("18","2015-10-27 03:51:57","1","4","258","0","base");
INSERT INTO log VALUES("19","2015-10-27 03:52:38","1","7","0","76","all");
INSERT INTO log VALUES("20","2015-10-27 03:52:44","1","7","0","77","all");
INSERT INTO log VALUES("21","2015-10-27 03:53:17","1","7","0","77","all");
INSERT INTO log VALUES("22","2015-10-27 03:53:17","1","6","0","7","all");
INSERT INTO log VALUES("23","2015-10-27 04:01:26","1","7","0","74","all");
INSERT INTO log VALUES("24","2015-10-27 04:01:32","1","7","0","76","all");
INSERT INTO log VALUES("25","2015-10-27 04:24:02","2","7","0","77","all");
INSERT INTO log VALUES("26","2015-10-27 04:24:08","2","7","0","78","all");
INSERT INTO log VALUES("27","2015-10-27 04:24:14","2","7","0","75","all");
INSERT INTO log VALUES("28","2015-10-27 04:24:14","2","6","0","2","all");
INSERT INTO log VALUES("29","2015-10-27 04:24:20","2","7","0","73","all");
INSERT INTO log VALUES("30","2015-10-27 04:24:27","2","7","0","78","all");
INSERT INTO log VALUES("31","2015-10-27 04:24:34","2","7","0","75","all");
INSERT INTO log VALUES("32","2015-10-27 04:24:34","2","6","0","3","all");
INSERT INTO log VALUES("33","2015-10-27 04:24:42","2","7","0","75","all");
INSERT INTO log VALUES("34","2015-10-27 04:25:46","2","7","0","74","all");
INSERT INTO log VALUES("35","2015-10-27 04:25:54","2","7","0","75","all");
INSERT INTO log VALUES("36","2015-10-27 04:26:04","2","7","0","78","all");
INSERT INTO log VALUES("37","2015-10-27 04:32:11","2","6","0","4","all");
INSERT INTO log VALUES("38","2015-10-27 04:32:11","2","12","3","154","all");
INSERT INTO log VALUES("39","2015-10-27 04:32:11","3","10","2","9","all");
INSERT INTO log VALUES("40","2015-10-27 04:32:13","2","6","0","6","all");
INSERT INTO log VALUES("41","2015-10-27 04:32:13","2","12","3","815","all");
INSERT INTO log VALUES("42","2015-10-27 04:32:13","2","13","3","0","all");
INSERT INTO log VALUES("43","2015-10-27 04:33:32","2","7","0","74","all");
INSERT INTO log VALUES("44","2015-10-27 04:33:43","2","7","0","77","all");
INSERT INTO log VALUES("45","2015-10-27 04:33:51","2","7","0","77","all");
INSERT INTO log VALUES("46","2015-10-27 04:33:58","2","7","0","79","all");
INSERT INTO log VALUES("47","2015-10-27 04:34:05","2","7","0","74","all");
INSERT INTO log VALUES("48","2015-10-27 04:34:11","2","7","0","75","all");
INSERT INTO log VALUES("49","2015-10-27 04:34:18","2","7","0","78","all");
INSERT INTO log VALUES("50","2015-10-27 04:34:24","2","7","0","78","all");
INSERT INTO log VALUES("51","2015-10-27 04:34:32","2","7","0","74","all");
INSERT INTO log VALUES("52","2015-10-27 04:34:38","2","7","0","76","all");
INSERT INTO log VALUES("53","2015-10-27 04:34:46","2","7","0","78","all");
INSERT INTO log VALUES("54","2015-10-27 04:34:56","2","7","0","77","all");
INSERT INTO log VALUES("55","2015-10-27 04:35:05","2","7","0","77","all");
INSERT INTO log VALUES("56","2015-10-27 04:35:19","2","7","0","74","all");
INSERT INTO log VALUES("57","2015-10-27 04:35:25","2","7","0","75","all");
INSERT INTO log VALUES("58","2015-10-27 04:35:31","2","7","0","77","all");
INSERT INTO log VALUES("59","2015-10-27 04:35:37","2","7","0","75","all");
INSERT INTO log VALUES("60","2015-10-27 04:35:37","2","6","0","7","all");
INSERT INTO log VALUES("61","2015-10-27 04:35:41","1","7","0","78","all");
INSERT INTO log VALUES("62","2015-10-27 04:35:45","2","7","0","77","all");
INSERT INTO log VALUES("63","2015-10-27 04:35:47","1","7","0","74","all");
INSERT INTO log VALUES("64","2015-10-27 04:35:53","2","7","0","76","all");
INSERT INTO log VALUES("65","2015-10-27 04:35:53","1","7","0","74","all");
INSERT INTO log VALUES("66","2015-10-27 04:36:00","2","7","0","77","all");
INSERT INTO log VALUES("67","2015-10-27 04:36:08","2","7","0","77","all");
INSERT INTO log VALUES("68","2015-10-27 04:36:16","2","7","0","76","all");
INSERT INTO log VALUES("69","2015-10-27 04:36:25","2","7","0","77","all");
INSERT INTO log VALUES("70","2015-10-27 04:36:37","2","7","0","73","all");
INSERT INTO log VALUES("71","2015-10-27 04:36:44","2","7","0","75","all");
INSERT INTO log VALUES("72","2015-10-27 04:36:51","2","7","0","76","all");
INSERT INTO log VALUES("73","2015-10-27 04:36:59","2","7","0","74","all");
INSERT INTO log VALUES("74","2015-10-27 04:37:02","1","6","0","8","all");
INSERT INTO log VALUES("75","2015-10-27 04:37:02","1","12","3","795","all");
INSERT INTO log VALUES("76","2015-10-27 04:37:02","1","13","3","0","all");
INSERT INTO log VALUES("77","2015-10-27 04:38:21","2","6","0","8","all");
INSERT INTO log VALUES("78","2015-10-27 04:38:21","2","12","3","767","all");
INSERT INTO log VALUES("79","2015-10-27 04:38:21","2","13","3","0","all");
INSERT INTO log VALUES("80","2015-10-27 04:43:35","2","6","0","9","all");
INSERT INTO log VALUES("81","2015-10-27 04:43:35","2","12","3","787","all");
INSERT INTO log VALUES("82","2015-10-27 04:43:35","2","13","3","0","all");
INSERT INTO log VALUES("83","2015-10-27 04:47:23","1","6","0","9","all");
INSERT INTO log VALUES("84","2015-10-27 04:47:23","1","12","3","824","all");
INSERT INTO log VALUES("85","2015-10-27 04:47:23","1","13","3","0","all");
INSERT INTO log VALUES("86","2015-10-27 04:50:07","2","6","0","10","all");
INSERT INTO log VALUES("87","2015-10-27 04:50:07","2","12","3","782","all");
INSERT INTO log VALUES("88","2015-10-27 04:50:07","2","13","3","0","all");
INSERT INTO log VALUES("89","2015-10-27 05:00:45","1","6","0","10","all");
INSERT INTO log VALUES("90","2015-10-27 05:00:45","1","12","3","847","all");
INSERT INTO log VALUES("91","2015-10-27 05:00:45","1","13","3","0","all");
INSERT INTO log VALUES("92","2015-10-27 05:21:15","2","12","3","153","all");
INSERT INTO log VALUES("93","2015-10-27 05:21:15","3","10","2","9","all");
INSERT INTO log VALUES("94","2015-10-27 05:21:19","2","12","3","792","all");
INSERT INTO log VALUES("95","2015-10-27 05:21:19","2","13","3","0","all");
INSERT INTO log VALUES("96","2015-10-27 06:39:09","3","10","3","9","all");
INSERT INTO log VALUES("97","2015-10-27 06:39:13","3","6","0","2","all");
INSERT INTO log VALUES("98","2015-10-27 06:39:13","3","12","3","154","all");
INSERT INTO log VALUES("99","2015-10-27 06:39:17","3","10","3","10","all");
INSERT INTO log VALUES("100","2015-10-27 06:39:17","3","10","3","10","all");
INSERT INTO log VALUES("101","2015-10-27 06:39:24","3","6","0","3","all");
INSERT INTO log VALUES("102","2015-10-27 06:39:24","3","12","3","151","all");
INSERT INTO log VALUES("103","2015-10-27 06:39:30","3","12","3","150","all");
INSERT INTO log VALUES("104","2015-10-27 06:39:41","3","6","0","4","all");
INSERT INTO log VALUES("105","2015-10-27 06:39:41","3","12","3","152","all");
INSERT INTO log VALUES("106","2015-10-27 06:39:41","3","13","3","0","all");
INSERT INTO log VALUES("107","2015-10-27 06:44:13","3","7","0","254","all");
INSERT INTO log VALUES("108","2015-10-27 06:44:13","3","6","0","5","all");
INSERT INTO log VALUES("109","2015-10-27 06:44:26","3","7","0","254","all");
INSERT INTO log VALUES("110","2015-10-27 06:44:26","3","4","242","0","base");
INSERT INTO log VALUES("111","2015-10-27 07:02:00","3","10","3","9","all");
INSERT INTO log VALUES("112","2015-10-27 07:02:04","3","12","3","154","all");
INSERT INTO log VALUES("113","2015-10-27 07:02:11","3","12","3","146","all");
INSERT INTO log VALUES("114","2015-10-27 07:02:15","3","10","3","10","all");
INSERT INTO log VALUES("115","2015-10-27 07:02:15","3","10","3","10","all");
INSERT INTO log VALUES("116","2015-10-27 07:02:15","3","10","3","10","all");
INSERT INTO log VALUES("117","2015-10-27 07:02:15","3","10","3","9","all");
INSERT INTO log VALUES("118","2015-10-27 07:02:19","3","6","0","6","all");
INSERT INTO log VALUES("119","2015-10-27 07:02:19","3","12","3","153","all");
INSERT INTO log VALUES("120","2015-10-27 07:02:24","3","10","3","9","all");
INSERT INTO log VALUES("121","2015-10-27 07:02:24","3","10","3","9","all");
INSERT INTO log VALUES("122","2015-10-27 07:02:32","3","12","3","149","all");
INSERT INTO log VALUES("123","2015-10-27 07:02:32","3","13","3","0","all");
INSERT INTO log VALUES("124","2015-10-27 07:04:28","3","7","0","73","all");
INSERT INTO log VALUES("125","2015-10-27 07:04:34","3","7","0","73","all");
INSERT INTO log VALUES("126","2015-10-27 07:04:42","3","7","0","73","all");
INSERT INTO log VALUES("127","2015-10-27 07:17:46","4","6","0","2","all");
INSERT INTO log VALUES("128","2015-10-27 07:17:46","4","12","3","155","all");
INSERT INTO log VALUES("129","2015-10-27 07:17:46","3","10","4","10","all");
INSERT INTO log VALUES("130","2015-10-27 07:17:49","3","10","4","10","all");
INSERT INTO log VALUES("131","2015-10-27 07:17:51","3","10","4","9","all");
INSERT INTO log VALUES("132","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("133","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("134","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("135","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("136","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("137","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("138","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("139","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("140","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("141","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("142","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("143","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("144","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("145","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("146","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("147","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("148","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("149","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("150","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("151","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("152","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("153","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("154","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("155","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("156","2015-10-27 07:17:51","3","10","3","10","all");
INSERT INTO log VALUES("157","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("158","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("159","2015-10-27 07:17:51","3","10","3","9","all");
INSERT INTO log VALUES("160","2015-10-27 07:17:52","4","6","0","3","all");
INSERT INTO log VALUES("161","2015-10-27 07:17:52","4","12","3","145","all");
INSERT INTO log VALUES("162","2015-10-27 07:17:53","3","10","4","10","all");
INSERT INTO log VALUES("163","2015-10-27 07:17:55","3","10","4","10","all");
INSERT INTO log VALUES("164","2015-10-27 07:17:56","3","12","3","148","all");
INSERT INTO log VALUES("165","2015-10-27 07:17:57","3","10","4","10","all");
INSERT INTO log VALUES("166","2015-10-27 07:17:59","4","12","3","154","all");
INSERT INTO log VALUES("167","2015-10-27 07:17:59","3","10","4","9","all");
INSERT INTO log VALUES("168","2015-10-27 07:18:01","3","10","3","9","all");
INSERT INTO log VALUES("169","2015-10-27 07:18:01","3","10","3","10","all");
INSERT INTO log VALUES("170","2015-10-27 07:18:01","3","10","3","10","all");
INSERT INTO log VALUES("171","2015-10-27 07:18:02","3","10","4","9","all");
INSERT INTO log VALUES("172","2015-10-27 07:18:04","3","10","3","10","all");
INSERT INTO log VALUES("173","2015-10-27 07:18:05","4","6","0","4","all");
INSERT INTO log VALUES("174","2015-10-27 07:18:05","4","12","3","152","all");
INSERT INTO log VALUES("175","2015-10-27 07:18:05","4","13","3","0","all");
INSERT INTO log VALUES("176","2015-10-27 07:18:07","3","12","3","154","all");
INSERT INTO log VALUES("177","2015-10-27 07:18:10","3","10","3","9","all");
INSERT INTO log VALUES("178","2015-10-27 07:18:10","3","10","3","9","all");
INSERT INTO log VALUES("179","2015-10-27 07:18:13","3","12","3","150","all");
INSERT INTO log VALUES("180","2015-10-27 07:18:16","3","10","3","9","all");
INSERT INTO log VALUES("181","2015-10-27 07:18:16","3","10","3","9","all");
INSERT INTO log VALUES("182","2015-10-27 07:18:21","3","6","0","7","all");
INSERT INTO log VALUES("183","2015-10-27 07:18:21","3","12","3","156","all");
INSERT INTO log VALUES("184","2015-10-27 07:18:21","3","13","3","0","all");
INSERT INTO log VALUES("185","2015-10-27 07:25:17","4","6","0","5","all");
INSERT INTO log VALUES("186","2015-10-27 07:25:17","4","12","3","156","all");
INSERT INTO log VALUES("187","2015-10-27 07:25:17","3","10","4","9","all");
INSERT INTO log VALUES("188","2015-10-27 07:25:20","3","10","4","10","all");
INSERT INTO log VALUES("189","2015-10-27 07:25:22","3","10","4","9","all");
INSERT INTO log VALUES("190","2015-10-27 07:25:23","4","12","3","153","all");
INSERT INTO log VALUES("191","2015-10-27 07:25:25","3","10","4","9","all");
INSERT INTO log VALUES("192","2015-10-27 07:25:28","3","10","4","10","all");
INSERT INTO log VALUES("193","2015-10-27 07:25:29","4","12","3","157","all");
INSERT INTO log VALUES("194","2015-10-27 07:25:31","3","10","4","9","all");
INSERT INTO log VALUES("195","2015-10-27 07:25:33","3","10","4","10","all");
INSERT INTO log VALUES("196","2015-10-27 07:25:35","4","12","3","148","all");
INSERT INTO log VALUES("197","2015-10-27 07:25:35","4","13","3","0","all");
INSERT INTO log VALUES("198","2015-10-27 07:25:55","3","10","3","20","all");
INSERT INTO log VALUES("199","2015-10-27 07:25:59","3","6","0","8","all");
INSERT INTO log VALUES("200","2015-10-27 07:25:59","3","12","3","713","all");
INSERT INTO log VALUES("201","2015-10-27 07:25:59","3","13","3","0","all");
INSERT INTO log VALUES("202","2015-10-27 07:26:22","4","7","0","78","all");
INSERT INTO log VALUES("203","2015-10-27 07:26:22","4","6","0","6","all");
INSERT INTO log VALUES("204","2015-10-27 07:26:28","4","7","0","77","all");
INSERT INTO log VALUES("205","2015-10-27 07:26:35","4","7","0","73","all");
INSERT INTO log VALUES("206","2015-10-27 07:26:41","4","7","0","73","all");
INSERT INTO log VALUES("207","2015-10-27 07:26:49","4","7","0","75","all");
INSERT INTO log VALUES("208","2015-10-27 07:27:18","3","7","0","75","all");
INSERT INTO log VALUES("209","2015-10-27 07:27:26","3","7","0","76","all");
INSERT INTO log VALUES("210","2015-10-27 07:27:46","3","7","0","77","all");
INSERT INTO log VALUES("211","2015-10-27 07:28:05","3","7","0","76","all");
INSERT INTO log VALUES("212","2015-10-27 07:28:12","3","7","0","76","all");
INSERT INTO log VALUES("213","2015-10-27 07:28:19","3","7","0","78","all");
INSERT INTO log VALUES("214","2015-10-27 07:28:30","3","7","0","75","all");
INSERT INTO log VALUES("215","2015-10-27 07:28:37","3","7","0","75","all");
INSERT INTO log VALUES("216","2015-10-27 07:28:45","3","7","0","75","all");
INSERT INTO log VALUES("217","2015-10-27 07:29:03","3","7","0","77","all");
INSERT INTO log VALUES("218","2015-10-27 07:29:23","3","7","0","77","all");
INSERT INTO log VALUES("219","2015-10-27 07:29:29","3","7","0","77","all");
INSERT INTO log VALUES("220","2015-10-27 07:29:37","3","7","0","76","all");
INSERT INTO log VALUES("221","2015-10-27 07:29:46","3","7","0","78","all");
INSERT INTO log VALUES("222","2015-10-27 07:30:02","3","7","0","73","all");
INSERT INTO log VALUES("223","2015-10-27 07:30:44","3","7","0","79","all");
INSERT INTO log VALUES("224","2015-10-27 07:30:50","3","7","0","75","all");
INSERT INTO log VALUES("225","2015-10-27 07:30:56","3","7","0","78","all");
INSERT INTO log VALUES("226","2015-10-27 07:31:03","3","7","0","77","all");
INSERT INTO log VALUES("227","2015-10-27 07:31:51","3","10","3","18","all");
INSERT INTO log VALUES("228","2015-10-27 07:31:54","3","6","0","9","all");
INSERT INTO log VALUES("229","2015-10-27 07:31:54","3","12","3","719","all");
INSERT INTO log VALUES("230","2015-10-27 07:31:54","3","13","3","0","all");
INSERT INTO log VALUES("231","2015-10-27 07:33:59","3","7","0","77","all");
INSERT INTO log VALUES("232","2015-10-27 07:34:05","3","7","0","74","all");
INSERT INTO log VALUES("233","2015-10-27 07:34:05","3","4","550","0","secret");
INSERT INTO log VALUES("234","2015-10-27 07:34:17","3","7","0","74","all");
INSERT INTO log VALUES("235","2015-10-27 07:34:30","3","7","0","74","all");
INSERT INTO log VALUES("236","2015-10-27 07:34:37","3","7","0","77","all");
INSERT INTO log VALUES("237","2015-10-27 07:34:43","3","7","0","73","all");
INSERT INTO log VALUES("238","2015-10-27 07:34:51","3","7","0","73","all");
INSERT INTO log VALUES("239","2015-10-27 07:35:23","4","12","3","146","all");
INSERT INTO log VALUES("240","2015-10-27 07:35:23","3","10","4","9","all");
INSERT INTO log VALUES("241","2015-10-27 07:35:38","4","6","0","7","all");
INSERT INTO log VALUES("242","2015-10-27 07:35:38","4","12","3","591","all");
INSERT INTO log VALUES("243","2015-10-27 07:35:38","4","13","3","0","all");
INSERT INTO log VALUES("244","2015-10-27 07:38:28","3","10","3","20","all");
INSERT INTO log VALUES("245","2015-10-27 07:38:31","3","6","0","10","all");
INSERT INTO log VALUES("246","2015-10-27 07:38:31","3","12","3","725","all");
INSERT INTO log VALUES("247","2015-10-27 07:38:31","3","13","3","0","all");
INSERT INTO log VALUES("248","2015-10-27 07:43:15","3","12","5","181","all");
INSERT INTO log VALUES("249","2015-10-27 07:43:17","5","10","3","192","all");
INSERT INTO log VALUES("250","2015-10-27 07:43:17","5","10","3","192","all");
INSERT INTO log VALUES("251","2015-10-27 07:43:27","5","10","3","210","all");
INSERT INTO log VALUES("252","2015-10-27 07:43:27","5","10","3","196","all");
INSERT INTO log VALUES("253","2015-10-27 07:43:27","5","10","3","199","all");
INSERT INTO log VALUES("254","2015-10-27 07:43:27","5","11","3","0","all");
INSERT INTO log VALUES("255","2015-10-27 07:48:43","4","12","3","156","all");
INSERT INTO log VALUES("256","2015-10-27 07:48:43","3","10","4","10","all");
INSERT INTO log VALUES("257","2015-10-27 07:48:46","4","6","0","8","all");
INSERT INTO log VALUES("258","2015-10-27 07:48:46","4","12","3","589","all");
INSERT INTO log VALUES("259","2015-10-27 07:48:46","4","13","3","0","all");
INSERT INTO log VALUES("260","2015-10-27 07:51:25","4","7","0","76","all");
INSERT INTO log VALUES("261","2015-10-27 07:51:33","4","7","0","77","all");
INSERT INTO log VALUES("262","2015-10-27 07:51:40","4","7","0","77","all");
INSERT INTO log VALUES("263","2015-10-27 07:51:47","4","7","0","78","all");
INSERT INTO log VALUES("264","2015-10-27 07:55:32","3","10","3","18","all");
INSERT INTO log VALUES("265","2015-10-27 07:55:35","3","12","3","710","all");
INSERT INTO log VALUES("266","2015-10-27 07:55:35","3","13","3","0","all");
INSERT INTO log VALUES("267","2015-10-27 07:55:59","3","7","0","74","all");
INSERT INTO log VALUES("268","2015-10-27 07:56:02","5","6","0","2","all");
INSERT INTO log VALUES("269","2015-10-27 07:56:02","5","12","3","157","all");
INSERT INTO log VALUES("270","2015-10-27 07:56:02","3","10","5","10","all");
INSERT INTO log VALUES("271","2015-10-27 07:56:05","3","10","5","10","all");
INSERT INTO log VALUES("272","2015-10-27 07:56:06","3","7","0","74","all");
INSERT INTO log VALUES("273","2015-10-27 07:56:08","5","6","0","3","all");
INSERT INTO log VALUES("274","2015-10-27 07:56:08","5","12","3","150","all");
INSERT INTO log VALUES("275","2015-10-27 07:56:08","3","10","5","10","all");
INSERT INTO log VALUES("276","2015-10-27 07:56:11","3","10","5","10","all");
INSERT INTO log VALUES("277","2015-10-27 07:56:14","3","10","5","9","all");
INSERT INTO log VALUES("278","2015-10-27 07:56:16","5","12","3","146","all");
INSERT INTO log VALUES("279","2015-10-27 07:56:16","3","10","5","10","all");
INSERT INTO log VALUES("280","2015-10-27 07:56:19","3","7","0","77","all");
INSERT INTO log VALUES("281","2015-10-27 07:56:20","3","10","5","9","all");
INSERT INTO log VALUES("282","2015-10-27 07:56:33","5","6","0","4","all");
INSERT INTO log VALUES("283","2015-10-27 07:56:33","5","12","3","147","all");
INSERT INTO log VALUES("284","2015-10-27 07:56:33","5","13","3","0","all");
INSERT INTO log VALUES("285","2015-10-27 07:58:23","5","7","0","77","all");
INSERT INTO log VALUES("286","2015-10-27 07:58:32","5","7","0","76","all");
INSERT INTO log VALUES("287","2015-10-27 07:58:32","5","6","0","5","all");
INSERT INTO log VALUES("288","2015-10-27 07:58:38","5","7","0","74","all");
INSERT INTO log VALUES("289","2015-10-27 07:58:55","5","7","0","76","all");
INSERT INTO log VALUES("290","2015-10-27 07:59:03","5","7","0","74","all");
INSERT INTO log VALUES("291","2015-10-27 07:59:12","5","7","0","76","all");
INSERT INTO log VALUES("292","2015-10-27 08:01:42","4","12","3","612","all");
INSERT INTO log VALUES("293","2015-10-27 08:01:42","4","13","3","0","all");
INSERT INTO log VALUES("294","2015-10-27 08:58:12","6","6","0","2","all");
INSERT INTO log VALUES("295","2015-10-27 08:58:12","6","12","3","154","all");
INSERT INTO log VALUES("296","2015-10-27 08:58:12","3","10","6","9","all");
INSERT INTO log VALUES("297","2015-10-27 08:58:16","3","10","6","10","all");
INSERT INTO log VALUES("298","2015-10-27 08:58:19","6","6","0","3","all");
INSERT INTO log VALUES("299","2015-10-27 08:58:19","6","12","3","145","all");
INSERT INTO log VALUES("300","2015-10-27 08:58:19","3","10","6","9","all");
INSERT INTO log VALUES("301","2015-10-27 08:58:26","6","12","3","149","all");
INSERT INTO log VALUES("302","2015-10-27 08:58:26","3","10","6","9","all");
INSERT INTO log VALUES("303","2015-10-27 08:58:26","3","10","6","10","all");
INSERT INTO log VALUES("304","2015-10-27 08:58:32","6","6","0","4","all");
INSERT INTO log VALUES("305","2015-10-27 08:58:32","6","12","3","154","all");
INSERT INTO log VALUES("306","2015-10-27 08:58:32","6","13","3","0","all");
INSERT INTO log VALUES("307","2015-10-27 09:18:12","7","6","0","2","all");
INSERT INTO log VALUES("308","2015-10-27 09:18:12","7","12","3","149","all");
INSERT INTO log VALUES("309","2015-10-27 09:18:13","3","10","7","9","all");
INSERT INTO log VALUES("310","2015-10-27 09:18:20","7","6","0","3","all");
INSERT INTO log VALUES("311","2015-10-27 09:18:20","7","12","3","146","all");
INSERT INTO log VALUES("312","2015-10-27 09:18:20","3","10","7","10","all");
INSERT INTO log VALUES("313","2015-10-27 09:18:20","3","10","7","10","all");
INSERT INTO log VALUES("314","2015-10-27 09:18:25","3","10","7","9","all");
INSERT INTO log VALUES("315","2015-10-27 09:18:29","7","12","3","150","all");
INSERT INTO log VALUES("316","2015-10-27 09:18:29","3","10","7","10","all");
INSERT INTO log VALUES("317","2015-10-27 09:18:32","3","10","7","10","all");
INSERT INTO log VALUES("318","2015-10-27 09:18:35","7","6","0","4","all");
INSERT INTO log VALUES("319","2015-10-27 09:18:35","7","12","3","148","all");
INSERT INTO log VALUES("320","2015-10-27 09:18:35","7","13","3","0","all");
INSERT INTO log VALUES("321","2015-10-27 09:47:42","4","6","0","9","all");
INSERT INTO log VALUES("322","2015-10-27 09:47:42","4","12","3","579","all");
INSERT INTO log VALUES("323","2015-10-27 09:47:42","4","13","3","0","all");
INSERT INTO log VALUES("324","2015-10-27 12:20:30","7","6","0","5","all");
INSERT INTO log VALUES("325","2015-10-27 12:20:30","7","12","3","154","all");
INSERT INTO log VALUES("326","2015-10-27 12:20:30","3","10","7","10","all");
INSERT INTO log VALUES("327","2015-10-27 12:20:33","3","10","7","10","all");
INSERT INTO log VALUES("328","2015-10-27 12:20:36","7","12","3","155","all");
INSERT INTO log VALUES("329","2015-10-27 12:20:36","3","10","7","9","all");
INSERT INTO log VALUES("330","2015-10-27 12:20:39","3","10","7","10","all");
INSERT INTO log VALUES("331","2015-10-27 12:20:41","3","10","7","10","all");
INSERT INTO log VALUES("332","2015-10-27 12:20:44","7","12","3","149","all");
INSERT INTO log VALUES("333","2015-10-27 12:20:44","3","10","7","9","all");
INSERT INTO log VALUES("334","2015-10-27 12:20:50","7","12","3","153","all");
INSERT INTO log VALUES("335","2015-10-27 12:20:50","7","13","3","0","all");
INSERT INTO log VALUES("336","2015-10-27 13:03:53","7","6","0","6","all");
INSERT INTO log VALUES("337","2015-10-27 13:03:53","7","12","3","151","all");
INSERT INTO log VALUES("338","2015-10-27 13:03:53","3","10","7","10","all");
INSERT INTO log VALUES("339","2015-10-27 13:04:00","7","12","3","151","all");
INSERT INTO log VALUES("340","2015-10-27 13:04:01","3","10","7","10","all");
INSERT INTO log VALUES("341","2015-10-27 13:04:01","3","10","7","10","all");
INSERT INTO log VALUES("342","2015-10-27 13:04:06","7","12","3","157","all");
INSERT INTO log VALUES("343","2015-10-27 13:04:07","3","10","7","9","all");
INSERT INTO log VALUES("344","2015-10-27 13:04:07","3","10","7","9","all");
INSERT INTO log VALUES("345","2015-10-27 13:04:11","3","10","7","9","all");
INSERT INTO log VALUES("346","2015-10-27 13:04:17","7","12","3","155","all");
INSERT INTO log VALUES("347","2015-10-27 13:04:17","7","13","3","0","all");
INSERT INTO log VALUES("348","2015-10-27 13:05:32","2","6","0","11","all");
INSERT INTO log VALUES("349","2015-10-27 13:05:32","2","12","3","792","all");
INSERT INTO log VALUES("350","2015-10-27 13:05:32","2","13","3","0","all");
INSERT INTO log VALUES("351","2015-10-27 13:18:17","7","12","3","146","all");
INSERT INTO log VALUES("352","2015-10-27 13:18:17","3","10","7","9","all");
INSERT INTO log VALUES("353","2015-10-27 13:18:23","7","12","3","149","all");
INSERT INTO log VALUES("354","2015-10-27 13:18:24","3","10","7","9","all");
INSERT INTO log VALUES("355","2015-10-27 13:18:24","3","10","7","10","all");
INSERT INTO log VALUES("356","2015-10-27 13:18:29","7","6","0","7","all");
INSERT INTO log VALUES("357","2015-10-27 13:18:29","7","12","3","154","all");
INSERT INTO log VALUES("358","2015-10-27 13:18:29","3","10","7","9","all");
INSERT INTO log VALUES("359","2015-10-27 13:18:34","3","10","7","10","all");
INSERT INTO log VALUES("360","2015-10-27 13:18:36","7","12","3","151","all");
INSERT INTO log VALUES("361","2015-10-27 13:18:36","7","13","3","0","all");
INSERT INTO log VALUES("362","2015-10-27 13:25:09","7","6","0","8","all");
INSERT INTO log VALUES("363","2015-10-27 13:25:09","7","12","3","298","all");
INSERT INTO log VALUES("364","2015-10-27 13:25:09","3","10","7","9","all");
INSERT INTO log VALUES("365","2015-10-27 13:25:18","7","12","3","289","all");
INSERT INTO log VALUES("366","2015-10-27 13:25:18","7","13","3","0","all");
INSERT INTO log VALUES("367","2015-10-27 13:34:14","7","12","3","300","all");
INSERT INTO log VALUES("368","2015-10-27 13:34:15","3","10","7","10","all");
INSERT INTO log VALUES("369","2015-10-27 13:34:22","7","12","3","290","all");
INSERT INTO log VALUES("370","2015-10-27 13:34:22","7","13","3","0","all");
INSERT INTO log VALUES("371","2015-10-27 17:29:19","7","6","0","9","all");
INSERT INTO log VALUES("372","2015-10-27 17:29:19","7","12","3","294","all");
INSERT INTO log VALUES("373","2015-10-27 17:29:19","3","10","7","10","all");
INSERT INTO log VALUES("374","2015-10-27 17:29:25","7","12","3","292","all");
INSERT INTO log VALUES("375","2015-10-27 17:29:25","7","13","3","0","all");
INSERT INTO log VALUES("376","2015-10-27 17:55:44","8","7","0","78","all");
INSERT INTO log VALUES("377","2015-10-27 17:55:51","8","7","0","251","all");
INSERT INTO log VALUES("378","2015-10-27 17:55:51","8","6","0","2","all");
INSERT INTO log VALUES("379","2015-10-27 17:55:58","8","7","0","261","all");
INSERT INTO log VALUES("380","2015-10-27 17:55:58","8","6","0","3","all");
INSERT INTO log VALUES("381","2015-10-27 17:55:58","8","4","266","0","base");
INSERT INTO log VALUES("382","2015-10-27 17:58:33","8","7","0","75","all");
INSERT INTO log VALUES("383","2015-10-27 17:58:40","8","7","0","76","all");
INSERT INTO log VALUES("384","2015-10-27 17:58:46","8","7","0","76","all");
INSERT INTO log VALUES("385","2015-10-27 17:58:52","8","7","0","78","all");
INSERT INTO log VALUES("386","2015-10-27 17:58:59","8","7","0","75","all");
INSERT INTO log VALUES("387","2015-10-27 17:59:07","8","7","0","73","all");
INSERT INTO log VALUES("388","2015-10-27 17:59:07","8","6","0","4","all");
INSERT INTO log VALUES("389","2015-10-27 17:59:17","8","7","0","77","all");
INSERT INTO log VALUES("390","2015-10-27 17:59:23","8","7","0","75","all");
INSERT INTO log VALUES("391","2015-10-27 17:59:30","8","7","0","79","all");
INSERT INTO log VALUES("392","2015-10-27 17:59:41","8","7","0","77","all");
INSERT INTO log VALUES("393","2015-10-27 17:59:41","8","6","0","5","all");
INSERT INTO log VALUES("394","2015-10-27 17:59:48","8","7","0","74","all");
INSERT INTO log VALUES("395","2015-10-27 17:59:55","8","7","0","73","all");
INSERT INTO log VALUES("396","2015-10-27 18:00:01","8","7","0","75","all");
INSERT INTO log VALUES("397","2015-10-27 18:00:09","8","7","0","75","all");
INSERT INTO log VALUES("398","2015-10-27 18:00:16","8","7","0","78","all");
INSERT INTO log VALUES("399","2015-10-27 18:00:22","8","7","0","74","all");
INSERT INTO log VALUES("400","2015-10-27 18:00:42","8","7","0","78","all");
INSERT INTO log VALUES("401","2015-10-27 18:00:48","8","7","0","73","all");
INSERT INTO log VALUES("402","2015-10-27 18:00:54","8","7","0","76","all");
INSERT INTO log VALUES("403","2015-10-27 18:01:00","8","7","0","75","all");
INSERT INTO log VALUES("404","2015-10-27 18:01:06","8","7","0","77","all");
INSERT INTO log VALUES("405","2015-10-27 18:01:13","8","7","0","73","all");
INSERT INTO log VALUES("406","2015-10-27 18:01:19","8","7","0","74","all");
INSERT INTO log VALUES("407","2015-10-27 18:01:32","8","7","0","73","all");
INSERT INTO log VALUES("408","2015-10-27 18:02:12","8","7","0","74","all");
INSERT INTO log VALUES("409","2015-10-27 18:02:19","8","7","0","76","all");
INSERT INTO log VALUES("410","2015-10-27 18:02:19","8","6","0","6","all");
INSERT INTO log VALUES("411","2015-10-27 18:02:25","8","7","0","75","all");
INSERT INTO log VALUES("412","2015-10-27 18:02:32","8","7","0","75","all");
INSERT INTO log VALUES("413","2015-10-27 18:02:43","8","7","0","78","all");
INSERT INTO log VALUES("414","2015-10-27 18:02:55","8","7","0","75","all");
INSERT INTO log VALUES("415","2015-10-27 18:03:03","8","7","0","76","all");
INSERT INTO log VALUES("416","2015-10-27 18:03:11","8","7","0","75","all");
INSERT INTO log VALUES("417","2015-10-27 18:03:18","8","7","0","73","all");
INSERT INTO log VALUES("418","2015-10-27 18:03:25","8","7","0","77","all");
INSERT INTO log VALUES("419","2015-10-27 18:03:35","8","7","0","76","all");
INSERT INTO log VALUES("420","2015-10-27 18:03:41","8","7","0","72","all");
INSERT INTO log VALUES("421","2015-10-27 18:03:47","8","7","0","78","all");
INSERT INTO log VALUES("422","2015-10-27 18:03:54","8","7","0","74","all");
INSERT INTO log VALUES("423","2015-10-27 18:04:01","8","7","0","77","all");
INSERT INTO log VALUES("424","2015-10-27 18:04:07","8","7","0","73","all");
INSERT INTO log VALUES("425","2015-10-27 18:04:15","8","7","0","78","all");
INSERT INTO log VALUES("426","2015-10-27 18:05:04","8","7","0","75","all");
INSERT INTO log VALUES("427","2015-10-27 18:05:28","8","7","0","75","all");
INSERT INTO log VALUES("428","2015-10-27 18:05:36","8","7","0","78","all");
INSERT INTO log VALUES("429","2015-10-27 18:05:43","8","7","0","77","all");
INSERT INTO log VALUES("430","2015-10-27 18:05:50","8","7","0","76","all");
INSERT INTO log VALUES("431","2015-10-27 18:06:55","8","6","0","7","all");
INSERT INTO log VALUES("432","2015-10-27 18:06:55","8","12","3","146","all");
INSERT INTO log VALUES("433","2015-10-27 18:06:55","3","10","8","10","all");
INSERT INTO log VALUES("434","2015-10-27 18:07:02","8","12","3","153","all");
INSERT INTO log VALUES("435","2015-10-27 18:07:02","3","10","8","10","all");
INSERT INTO log VALUES("436","2015-10-27 18:07:02","3","10","8","10","all");
INSERT INTO log VALUES("437","2015-10-27 18:07:09","8","12","3","150","all");
INSERT INTO log VALUES("438","2015-10-27 18:07:10","3","10","8","10","all");
INSERT INTO log VALUES("439","2015-10-27 18:07:10","3","10","8","10","all");
INSERT INTO log VALUES("440","2015-10-27 18:07:16","8","12","3","150","all");
INSERT INTO log VALUES("441","2015-10-27 18:07:16","8","13","3","0","all");
INSERT INTO log VALUES("442","2015-10-27 18:27:26","2","12","3","788","all");
INSERT INTO log VALUES("443","2015-10-27 18:27:26","2","13","3","0","all");
INSERT INTO log VALUES("444","2015-10-27 18:38:03","8","6","0","8","all");
INSERT INTO log VALUES("445","2015-10-27 18:38:03","8","12","3","267","all");
INSERT INTO log VALUES("446","2015-10-27 18:38:03","3","10","8","8","all");
INSERT INTO log VALUES("447","2015-10-27 18:38:11","8","12","3","259","all");
INSERT INTO log VALUES("448","2015-10-27 18:38:11","8","13","3","0","all");
INSERT INTO log VALUES("449","2015-10-27 22:09:47","7","7","0","496","all");
INSERT INTO log VALUES("450","2015-10-27 22:09:47","7","4","257","0","base");
INSERT INTO log VALUES("451","2015-10-27 22:10:39","7","6","0","10","all");
INSERT INTO log VALUES("452","2015-10-27 22:10:39","7","12","3","309","all");
INSERT INTO log VALUES("453","2015-10-27 22:10:40","3","10","7","10","all");
INSERT INTO log VALUES("454","2015-10-27 22:10:42","3","10","7","9","all");
INSERT INTO log VALUES("455","2015-10-27 22:10:45","7","12","3","295","all");
INSERT INTO log VALUES("456","2015-10-27 22:10:45","7","13","3","0","all");
INSERT INTO log VALUES("457","2015-10-27 22:12:49","7","7","0","155","all");
INSERT INTO log VALUES("458","2015-10-27 22:12:55","7","7","0","152","all");
INSERT INTO log VALUES("459","2015-10-27 22:13:03","7","7","0","145","all");
INSERT INTO log VALUES("460","2015-10-27 22:13:09","7","7","0","153","all");
INSERT INTO log VALUES("461","2015-10-27 22:13:16","7","7","0","147","all");
INSERT INTO log VALUES("462","2015-10-27 22:13:29","7","7","0","153","all");
INSERT INTO log VALUES("463","2015-10-27 22:13:37","7","7","0","151","all");
INSERT INTO log VALUES("464","2015-10-27 22:13:46","7","7","0","156","all");
INSERT INTO log VALUES("465","2015-10-27 22:13:52","7","7","0","149","all");
INSERT INTO log VALUES("466","2015-10-27 22:13:59","7","7","0","155","all");
INSERT INTO log VALUES("467","2015-10-27 22:14:05","7","7","0","150","all");
INSERT INTO log VALUES("468","2015-10-27 22:14:11","7","7","0","148","all");
INSERT INTO log VALUES("469","2015-10-27 22:14:19","7","7","0","147","all");
INSERT INTO log VALUES("470","2015-10-27 22:14:26","7","7","0","155","all");
INSERT INTO log VALUES("471","2015-10-27 22:14:26","7","4","550","0","secret");
INSERT INTO log VALUES("472","2015-10-27 22:14:34","7","7","0","146","all");
INSERT INTO log VALUES("473","2015-10-27 22:14:42","7","7","0","146","all");
INSERT INTO log VALUES("474","2015-10-27 22:14:49","7","7","0","146","all");
INSERT INTO log VALUES("475","2015-10-27 22:14:55","7","7","0","145","all");
INSERT INTO log VALUES("476","2015-10-27 22:15:01","7","7","0","154","all");
INSERT INTO log VALUES("477","2015-10-27 22:15:08","7","7","0","154","all");
INSERT INTO log VALUES("478","2015-10-27 22:15:17","7","7","0","152","all");
INSERT INTO log VALUES("479","2015-10-27 22:15:27","7","7","0","151","all");
INSERT INTO log VALUES("480","2015-10-27 22:15:34","7","7","0","147","all");
INSERT INTO log VALUES("481","2015-10-27 22:15:41","7","7","0","146","all");
INSERT INTO log VALUES("482","2015-10-27 22:16:58","7","7","0","303","all");
INSERT INTO log VALUES("483","2015-10-27 22:16:58","7","6","0","11","all");
INSERT INTO log VALUES("484","2015-10-27 22:17:06","7","7","0","303","all");
INSERT INTO log VALUES("485","2015-10-27 22:17:06","7","4","487","0","kordon2");
INSERT INTO log VALUES("486","2015-10-27 22:22:47","7","8","0","0","all");
INSERT INTO log VALUES("487","2015-10-27 22:22:47","5","10","7","98","all");
INSERT INTO log VALUES("488","2015-10-27 22:22:51","7","12","5","73","all");
INSERT INTO log VALUES("489","2015-10-27 22:22:52","5","10","7","104","all");
INSERT INTO log VALUES("490","2015-10-27 22:22:52","5","10","7","100","all");
INSERT INTO log VALUES("491","2015-10-27 22:22:57","7","12","5","457","all");
INSERT INTO log VALUES("492","2015-10-27 22:22:57","5","10","7","98","all");
INSERT INTO log VALUES("493","2015-10-27 22:22:57","5","10","7","101","all");
INSERT INTO log VALUES("494","2015-10-27 22:23:03","7","12","5","75","all");
INSERT INTO log VALUES("495","2015-10-27 22:23:03","5","10","7","100","all");
INSERT INTO log VALUES("496","2015-10-27 22:23:03","5","10","7","103","all");
INSERT INTO log VALUES("497","2015-10-27 22:23:03","5","11","7","0","all");
INSERT INTO log VALUES("498","2015-10-28 00:05:00","7","12","5","74","all");
INSERT INTO log VALUES("499","2015-10-28 00:05:00","5","10","7","38","all");
INSERT INTO log VALUES("500","2015-10-28 00:05:05","7","12","5","455","all");
INSERT INTO log VALUES("501","2015-10-28 00:05:05","5","10","7","37","all");
INSERT INTO log VALUES("502","2015-10-28 00:05:05","5","10","7","38","all");
INSERT INTO log VALUES("503","2015-10-28 00:05:07","7","5","0","0","all");
INSERT INTO log VALUES("504","2015-10-28 00:05:08","5","10","7","37","all");
INSERT INTO log VALUES("505","2015-10-28 00:05:10","7","12","5","77","all");
INSERT INTO log VALUES("506","2015-10-28 00:05:11","5","10","7","38","all");
INSERT INTO log VALUES("507","2015-10-28 00:05:15","5","10","7","36","all");
INSERT INTO log VALUES("508","2015-10-28 00:05:17","7","12","5","73","all");
INSERT INTO log VALUES("509","2015-10-28 00:05:18","5","10","7","38","all");
INSERT INTO log VALUES("510","2015-10-28 00:05:23","5","10","7","35","all");
INSERT INTO log VALUES("511","2015-10-28 00:05:23","5","10","7","38","all");
INSERT INTO log VALUES("512","2015-10-28 00:05:27","5","10","7","37","all");
INSERT INTO log VALUES("513","2015-10-28 00:05:31","5","10","7","38","all");
INSERT INTO log VALUES("514","2015-10-28 00:05:33","7","12","5","74","all");
INSERT INTO log VALUES("515","2015-10-28 00:05:34","5","10","7","38","all");
INSERT INTO log VALUES("516","2015-10-28 00:05:38","5","10","7","38","all");
INSERT INTO log VALUES("517","2015-10-28 00:05:44","7","12","5","441","all");
INSERT INTO log VALUES("518","2015-10-28 00:05:44","5","10","7","38","all");
INSERT INTO log VALUES("519","2015-10-28 00:05:44","5","10","7","35","all");
INSERT INTO log VALUES("520","2015-10-28 00:05:52","5","10","7","36","all");
INSERT INTO log VALUES("521","2015-10-28 00:05:52","5","10","7","34","all");
INSERT INTO log VALUES("522","2015-10-28 00:05:52","5","10","7","36","all");
INSERT INTO log VALUES("523","2015-10-28 00:05:55","5","10","7","35","all");
INSERT INTO log VALUES("524","2015-10-28 00:05:59","5","10","7","38","all");
INSERT INTO log VALUES("525","2015-10-28 00:06:02","5","10","7","38","all");
INSERT INTO log VALUES("526","2015-10-28 00:06:06","7","12","5","78","all");
INSERT INTO log VALUES("527","2015-10-28 00:06:06","5","10","7","36","all");
INSERT INTO log VALUES("528","2015-10-28 00:06:09","5","10","7","39","all");
INSERT INTO log VALUES("529","2015-10-28 00:06:11","5","10","7","36","all");
INSERT INTO log VALUES("530","2015-10-28 00:06:16","5","10","7","38","all");
INSERT INTO log VALUES("531","2015-10-28 00:06:16","5","10","7","39","all");
INSERT INTO log VALUES("532","2015-10-28 00:06:18","7","12","5","74","all");
INSERT INTO log VALUES("533","2015-10-28 00:06:19","5","10","7","37","all");
INSERT INTO log VALUES("534","2015-10-28 00:06:23","7","12","5","442","all");
INSERT INTO log VALUES("535","2015-10-28 00:06:23","5","10","7","35","all");
INSERT INTO log VALUES("536","2015-10-28 00:06:26","7","12","5","74","all");
INSERT INTO log VALUES("537","2015-10-28 00:06:27","5","10","7","39","all");
INSERT INTO log VALUES("538","2015-10-28 00:06:30","5","10","7","37","all");
INSERT INTO log VALUES("539","2015-10-28 00:06:33","7","12","5","72","all");
INSERT INTO log VALUES("540","2015-10-28 00:06:33","5","10","7","35","all");
INSERT INTO log VALUES("541","2015-10-28 00:06:38","5","10","7","38","all");
INSERT INTO log VALUES("542","2015-10-28 00:06:38","5","10","7","36","all");
INSERT INTO log VALUES("543","2015-10-28 00:06:41","7","12","5","76","all");
INSERT INTO log VALUES("544","2015-10-28 00:06:41","5","10","7","39","all");
INSERT INTO log VALUES("545","2015-10-28 00:06:46","5","10","7","36","all");
INSERT INTO log VALUES("546","2015-10-28 00:06:46","5","10","7","37","all");
INSERT INTO log VALUES("547","2015-10-28 00:06:48","5","10","7","37","all");
INSERT INTO log VALUES("548","2015-10-28 00:06:51","5","10","7","38","all");
INSERT INTO log VALUES("549","2015-10-28 00:06:53","7","12","5","78","all");
INSERT INTO log VALUES("550","2015-10-28 00:06:54","5","10","7","38","all");
INSERT INTO log VALUES("551","2015-10-28 00:06:57","5","10","7","38","all");
INSERT INTO log VALUES("552","2015-10-28 00:07:00","7","12","5","76","all");
INSERT INTO log VALUES("553","2015-10-28 00:07:00","5","10","7","38","all");
INSERT INTO log VALUES("554","2015-10-28 00:07:03","7","12","5","466","all");
INSERT INTO log VALUES("555","2015-10-28 00:07:03","7","13","5","0","all");
INSERT INTO log VALUES("556","2015-10-28 00:18:08","7","12","5","446","all");
INSERT INTO log VALUES("557","2015-10-28 00:18:08","5","10","7","36","all");
INSERT INTO log VALUES("558","2015-10-28 00:18:13","7","12","5","73","all");
INSERT INTO log VALUES("559","2015-10-28 00:18:13","5","10","7","36","all");
INSERT INTO log VALUES("560","2015-10-28 00:18:13","5","10","7","35","all");
INSERT INTO log VALUES("561","2015-10-28 00:18:19","7","12","5","74","all");
INSERT INTO log VALUES("562","2015-10-28 00:18:20","5","10","7","37","all");
INSERT INTO log VALUES("563","2015-10-28 00:18:20","5","10","7","39","all");
INSERT INTO log VALUES("564","2015-10-28 00:18:25","5","10","7","38","all");
INSERT INTO log VALUES("565","2015-10-28 00:18:25","5","10","7","35","all");
INSERT INTO log VALUES("566","2015-10-28 00:18:27","7","12","5","73","all");
INSERT INTO log VALUES("567","2015-10-28 00:18:27","5","10","7","37","all");
INSERT INTO log VALUES("568","2015-10-28 00:18:32","5","10","7","34","all");
INSERT INTO log VALUES("569","2015-10-28 00:18:32","5","10","7","38","all");
INSERT INTO log VALUES("570","2015-10-28 00:18:33","7","12","5","73","all");
INSERT INTO log VALUES("571","2015-10-28 00:18:34","5","10","7","36","all");
INSERT INTO log VALUES("572","2015-10-28 00:18:37","5","10","7","38","all");
INSERT INTO log VALUES("573","2015-10-28 00:18:49","7","12","5","73","all");
INSERT INTO log VALUES("574","2015-10-28 00:18:49","5","10","7","35","all");
INSERT INTO log VALUES("575","2015-10-28 00:18:49","5","10","7","37","all");
INSERT INTO log VALUES("576","2015-10-28 00:18:49","5","10","7","35","all");
INSERT INTO log VALUES("577","2015-10-28 00:18:49","5","10","7","35","all");
INSERT INTO log VALUES("578","2015-10-28 00:18:54","7","12","5","446","all");
INSERT INTO log VALUES("579","2015-10-28 00:18:54","5","10","7","38","all");
INSERT INTO log VALUES("580","2015-10-28 00:18:54","5","10","7","34","all");
INSERT INTO log VALUES("581","2015-10-28 00:18:59","7","12","5","72","all");
INSERT INTO log VALUES("582","2015-10-28 00:18:59","5","10","7","38","all");
INSERT INTO log VALUES("583","2015-10-28 00:18:59","5","10","7","38","all");
INSERT INTO log VALUES("584","2015-10-28 00:19:04","5","10","7","38","all");
INSERT INTO log VALUES("585","2015-10-28 00:19:05","5","10","7","36","all");
INSERT INTO log VALUES("586","2015-10-28 00:19:07","5","10","7","37","all");
INSERT INTO log VALUES("587","2015-10-28 00:19:10","7","12","5","75","all");
INSERT INTO log VALUES("588","2015-10-28 00:19:10","5","10","7","37","all");
INSERT INTO log VALUES("589","2015-10-28 00:19:15","5","10","7","34","all");
INSERT INTO log VALUES("590","2015-10-28 00:19:15","5","10","7","39","all");
INSERT INTO log VALUES("591","2015-10-28 00:19:18","7","12","5","73","all");
INSERT INTO log VALUES("592","2015-10-28 00:19:18","5","10","7","35","all");
INSERT INTO log VALUES("593","2015-10-28 00:19:21","5","10","7","37","all");
INSERT INTO log VALUES("594","2015-10-28 00:19:23","5","10","7","38","all");
INSERT INTO log VALUES("595","2015-10-28 00:19:25","5","10","7","37","all");
INSERT INTO log VALUES("596","2015-10-28 00:19:27","7","12","5","78","all");
INSERT INTO log VALUES("597","2015-10-28 00:19:27","5","10","7","38","all");
INSERT INTO log VALUES("598","2015-10-28 00:19:30","5","10","7","36","all");
INSERT INTO log VALUES("599","2015-10-28 00:19:32","5","10","7","35","all");
INSERT INTO log VALUES("600","2015-10-28 00:19:34","7","12","5","438","all");
INSERT INTO log VALUES("601","2015-10-28 00:19:34","5","10","7","38","all");
INSERT INTO log VALUES("602","2015-10-28 00:19:40","7","12","5","72","all");
INSERT INTO log VALUES("603","2015-10-28 00:19:40","5","10","7","37","all");
INSERT INTO log VALUES("604","2015-10-28 00:19:40","5","10","7","35","all");
INSERT INTO log VALUES("605","2015-10-28 00:19:43","5","10","7","36","all");
INSERT INTO log VALUES("606","2015-10-28 00:19:45","7","5","0","0","all");
INSERT INTO log VALUES("607","2015-10-28 00:19:46","5","10","7","36","all");
INSERT INTO log VALUES("608","2015-10-28 00:19:48","7","6","0","12","all");
INSERT INTO log VALUES("609","2015-10-28 00:19:48","7","12","5","75","all");
INSERT INTO log VALUES("610","2015-10-28 00:19:49","5","10","7","37","all");
INSERT INTO log VALUES("611","2015-10-28 00:19:55","7","12","5","77","all");
INSERT INTO log VALUES("612","2015-10-28 00:19:55","5","10","7","35","all");
INSERT INTO log VALUES("613","2015-10-28 00:19:55","5","10","7","38","all");
INSERT INTO log VALUES("614","2015-10-28 00:19:59","5","10","7","38","all");
INSERT INTO log VALUES("615","2015-10-28 00:20:04","7","12","5","72","all");
INSERT INTO log VALUES("616","2015-10-28 00:20:05","5","10","7","35","all");
INSERT INTO log VALUES("617","2015-10-28 00:20:05","5","10","7","38","all");
INSERT INTO log VALUES("618","2015-10-28 00:20:10","7","12","5","75","all");
INSERT INTO log VALUES("619","2015-10-28 00:20:11","5","10","7","36","all");
INSERT INTO log VALUES("620","2015-10-28 00:20:11","5","10","7","37","all");
INSERT INTO log VALUES("621","2015-10-28 00:20:15","7","12","5","438","all");
INSERT INTO log VALUES("622","2015-10-28 00:20:15","7","13","5","0","all");
INSERT INTO log VALUES("623","2015-10-28 00:23:51","7","12","3","1802","all");
INSERT INTO log VALUES("624","2015-10-28 00:23:51","7","13","3","0","all");
INSERT INTO log VALUES("625","2015-10-28 02:52:17","2","12","3","148","all");
INSERT INTO log VALUES("626","2015-10-28 02:52:18","3","10","2","10","all");
INSERT INTO log VALUES("627","2015-10-28 02:52:19","2","12","3","765","all");
INSERT INTO log VALUES("628","2015-10-28 02:52:19","2","13","3","0","all");
INSERT INTO log VALUES("629","2015-10-28 03:47:00","2","12","3","825","all");
INSERT INTO log VALUES("630","2015-10-28 03:47:00","2","13","3","0","all");
INSERT INTO log VALUES("631","2015-10-28 03:47:38","2","7","0","247","all");
INSERT INTO log VALUES("632","2015-10-28 03:47:47","2","7","0","248","all");
INSERT INTO log VALUES("633","2015-10-28 03:47:47","2","4","225","0","base");
INSERT INTO log VALUES("634","2015-10-28 03:48:48","2","7","0","77","all");
INSERT INTO log VALUES("635","2015-10-28 03:48:56","2","7","0","79","all");
INSERT INTO log VALUES("636","2015-10-28 03:49:04","2","7","0","76","all");
INSERT INTO log VALUES("637","2015-10-28 03:49:10","2","7","0","77","all");
INSERT INTO log VALUES("638","2015-10-28 03:49:16","2","7","0","74","all");
INSERT INTO log VALUES("639","2015-10-28 03:49:23","2","7","0","75","all");
INSERT INTO log VALUES("640","2015-10-28 03:49:30","2","7","0","76","all");
INSERT INTO log VALUES("641","2015-10-28 03:49:37","2","7","0","77","all");
INSERT INTO log VALUES("642","2015-10-28 04:59:17","2","6","0","12","all");
INSERT INTO log VALUES("643","2015-10-28 04:59:17","2","12","3","764","all");
INSERT INTO log VALUES("644","2015-10-28 04:59:17","2","13","3","0","all");
INSERT INTO log VALUES("645","2015-10-28 05:42:17","2","12","3","763","all");
INSERT INTO log VALUES("646","2015-10-28 05:42:17","2","13","3","0","all");
INSERT INTO log VALUES("647","2015-10-28 05:55:42","2","12","3","297","all");
INSERT INTO log VALUES("648","2015-10-28 05:55:43","3","10","2","3","all");
INSERT INTO log VALUES("649","2015-10-28 05:55:47","2","12","3","281","all");
INSERT INTO log VALUES("650","2015-10-28 05:55:47","2","13","3","0","all");
INSERT INTO log VALUES("651","2015-10-28 05:55:58","2","12","5","201","all");
INSERT INTO log VALUES("652","2015-10-28 05:55:58","5","10","2","32","all");
INSERT INTO log VALUES("653","2015-10-28 05:56:02","2","12","5","73","all");
INSERT INTO log VALUES("654","2015-10-28 05:56:02","5","10","2","30","all");
INSERT INTO log VALUES("655","2015-10-28 05:56:11","2","12","5","69","all");
INSERT INTO log VALUES("656","2015-10-28 05:56:13","5","10","2","32","all");
INSERT INTO log VALUES("657","2015-10-28 05:56:13","5","10","2","31","all");
INSERT INTO log VALUES("658","2015-10-28 05:56:13","5","10","2","30","all");
INSERT INTO log VALUES("659","2015-10-28 05:56:13","5","10","2","32","all");
INSERT INTO log VALUES("660","2015-10-28 05:56:20","2","12","5","71","all");
INSERT INTO log VALUES("661","2015-10-28 05:56:20","5","10","2","32","all");
INSERT INTO log VALUES("662","2015-10-28 05:56:20","5","10","2","32","all");
INSERT INTO log VALUES("663","2015-10-28 05:56:25","2","12","5","74","all");
INSERT INTO log VALUES("664","2015-10-28 05:56:26","5","10","2","31","all");
INSERT INTO log VALUES("665","2015-10-28 05:56:26","5","10","2","32","all");
INSERT INTO log VALUES("666","2015-10-28 05:56:31","2","12","5","200","all");
INSERT INTO log VALUES("667","2015-10-28 05:56:36","5","10","2","32","all");
INSERT INTO log VALUES("668","2015-10-28 05:56:36","5","10","2","30","all");
INSERT INTO log VALUES("669","2015-10-28 05:56:36","5","10","2","31","all");
INSERT INTO log VALUES("670","2015-10-28 05:56:42","2","12","5","72","all");
INSERT INTO log VALUES("671","2015-10-28 05:56:43","5","10","2","30","all");
INSERT INTO log VALUES("672","2015-10-28 05:56:43","5","10","2","29","all");
INSERT INTO log VALUES("673","2015-10-28 05:56:48","2","12","5","70","all");
INSERT INTO log VALUES("674","2015-10-28 05:56:48","5","10","2","31","all");
INSERT INTO log VALUES("675","2015-10-28 05:56:48","5","10","2","31","all");
INSERT INTO log VALUES("676","2015-10-28 05:57:01","2","12","5","73","all");
INSERT INTO log VALUES("677","2015-10-28 05:57:02","5","10","2","30","all");
INSERT INTO log VALUES("678","2015-10-28 05:57:02","5","10","2","29","all");
INSERT INTO log VALUES("679","2015-10-28 05:57:02","5","10","2","32","all");
INSERT INTO log VALUES("680","2015-10-28 05:57:02","5","10","2","32","all");
INSERT INTO log VALUES("681","2015-10-28 05:57:02","5","10","2","31","all");
INSERT INTO log VALUES("682","2015-10-28 05:57:07","2","12","5","197","all");
INSERT INTO log VALUES("683","2015-10-28 05:57:07","5","10","2","29","all");
INSERT INTO log VALUES("684","2015-10-28 05:57:07","5","10","2","30","all");
INSERT INTO log VALUES("685","2015-10-28 05:57:12","2","12","5","74","all");
INSERT INTO log VALUES("686","2015-10-28 05:57:12","5","10","2","30","all");
INSERT INTO log VALUES("687","2015-10-28 05:57:12","5","10","2","29","all");
INSERT INTO log VALUES("688","2015-10-28 05:57:18","2","12","5","73","all");
INSERT INTO log VALUES("689","2015-10-28 05:57:18","5","10","2","32","all");
INSERT INTO log VALUES("690","2015-10-28 05:57:18","5","10","2","30","all");
INSERT INTO log VALUES("691","2015-10-28 05:57:29","2","12","5","73","all");
INSERT INTO log VALUES("692","2015-10-28 05:57:30","5","10","2","31","all");
INSERT INTO log VALUES("693","2015-10-28 05:57:30","5","10","2","31","all");
INSERT INTO log VALUES("694","2015-10-28 05:57:30","5","10","2","31","all");
INSERT INTO log VALUES("695","2015-10-28 05:57:30","5","10","2","29","all");
INSERT INTO log VALUES("696","2015-10-28 05:57:41","2","12","5","71","all");
INSERT INTO log VALUES("697","2015-10-28 05:57:47","5","10","2","30","all");
INSERT INTO log VALUES("698","2015-10-28 05:57:47","5","10","2","29","all");
INSERT INTO log VALUES("699","2015-10-28 05:57:47","5","10","2","31","all");
INSERT INTO log VALUES("700","2015-10-28 05:57:47","5","10","2","29","all");
INSERT INTO log VALUES("701","2015-10-28 05:57:47","5","10","2","29","all");
INSERT INTO log VALUES("702","2015-10-28 05:57:47","5","10","2","31","all");
INSERT INTO log VALUES("703","2015-10-28 05:57:52","2","12","5","73","all");
INSERT INTO log VALUES("704","2015-10-28 05:57:53","5","10","2","30","all");
INSERT INTO log VALUES("705","2015-10-28 05:57:53","5","10","2","30","all");
INSERT INTO log VALUES("706","2015-10-28 05:57:56","2","12","5","199","all");
INSERT INTO log VALUES("707","2015-10-28 05:57:57","5","10","2","30","all");
INSERT INTO log VALUES("708","2015-10-28 05:58:02","2","12","5","74","all");
INSERT INTO log VALUES("709","2015-10-28 05:58:03","5","10","2","32","all");
INSERT INTO log VALUES("710","2015-10-28 05:58:03","5","10","2","31","all");
INSERT INTO log VALUES("711","2015-10-28 05:58:10","2","12","5","72","all");
INSERT INTO log VALUES("712","2015-10-28 05:58:10","5","10","2","31","all");
INSERT INTO log VALUES("713","2015-10-28 05:58:10","5","10","2","32","all");
INSERT INTO log VALUES("714","2015-10-28 05:58:16","2","12","5","72","all");
INSERT INTO log VALUES("715","2015-10-28 05:58:20","5","10","2","32","all");
INSERT INTO log VALUES("716","2015-10-28 05:58:20","5","10","2","32","all");
INSERT INTO log VALUES("717","2015-10-28 05:58:20","5","10","2","32","all");
INSERT INTO log VALUES("718","2015-10-28 05:58:24","2","12","5","75","all");
INSERT INTO log VALUES("719","2015-10-28 05:58:25","5","10","2","32","all");
INSERT INTO log VALUES("720","2015-10-28 05:58:25","5","10","2","30","all");
INSERT INTO log VALUES("721","2015-10-28 05:58:29","2","12","5","206","all");
INSERT INTO log VALUES("722","2015-10-28 05:58:29","5","10","2","30","all");
INSERT INTO log VALUES("723","2015-10-28 05:58:33","2","12","5","71","all");
INSERT INTO log VALUES("724","2015-10-28 05:58:33","5","10","2","29","all");
INSERT INTO log VALUES("725","2015-10-28 05:58:40","2","12","5","71","all");
INSERT INTO log VALUES("726","2015-10-28 05:58:40","5","10","2","31","all");
INSERT INTO log VALUES("727","2015-10-28 05:58:40","5","10","2","31","all");
INSERT INTO log VALUES("728","2015-10-28 05:58:45","2","12","5","73","all");
INSERT INTO log VALUES("729","2015-10-28 05:58:46","5","10","2","31","all");
INSERT INTO log VALUES("730","2015-10-28 05:58:46","5","10","2","31","all");
INSERT INTO log VALUES("731","2015-10-28 05:58:51","2","12","5","69","all");
INSERT INTO log VALUES("732","2015-10-28 05:58:51","5","10","2","32","all");
INSERT INTO log VALUES("733","2015-10-28 05:58:51","5","10","2","31","all");
INSERT INTO log VALUES("734","2015-10-28 05:58:55","2","12","5","196","all");
INSERT INTO log VALUES("735","2015-10-28 05:58:55","2","13","5","0","all");
INSERT INTO log VALUES("736","2015-10-28 06:01:07","2","5","0","0","all");
INSERT INTO log VALUES("737","2015-10-28 06:01:33","2","7","0","142","all");
INSERT INTO log VALUES("738","2015-10-28 06:01:38","2","7","0","139","all");
INSERT INTO log VALUES("739","2015-10-28 06:01:43","2","7","0","143","all");
INSERT INTO log VALUES("740","2015-10-28 06:01:47","2","7","0","147","all");
INSERT INTO log VALUES("741","2015-10-28 06:01:52","2","7","0","146","all");
INSERT INTO log VALUES("742","2015-10-28 06:01:57","2","7","0","147","all");
INSERT INTO log VALUES("743","2015-10-28 06:02:01","2","7","0","144","all");
INSERT INTO log VALUES("744","2015-10-28 06:02:05","2","7","0","145","all");
INSERT INTO log VALUES("745","2015-10-28 06:02:09","2","7","0","148","all");
INSERT INTO log VALUES("746","2015-10-28 06:02:14","2","7","0","140","all");
INSERT INTO log VALUES("747","2015-10-28 06:02:18","2","7","0","148","all");
INSERT INTO log VALUES("748","2015-10-28 06:02:23","2","7","0","144","all");
INSERT INTO log VALUES("749","2015-10-28 06:02:28","2","7","0","141","all");
INSERT INTO log VALUES("750","2015-10-28 06:02:33","2","7","0","140","all");
INSERT INTO log VALUES("751","2015-10-28 06:02:38","2","7","0","149","all");
INSERT INTO log VALUES("752","2015-10-28 06:02:42","2","7","0","138","all");
INSERT INTO log VALUES("753","2015-10-28 06:02:46","2","7","0","144","all");
INSERT INTO log VALUES("754","2015-10-28 06:02:54","2","7","0","141","all");
INSERT INTO log VALUES("755","2015-10-28 06:02:59","2","7","0","147","all");
INSERT INTO log VALUES("756","2015-10-28 06:03:04","2","7","0","138","all");
INSERT INTO log VALUES("757","2015-10-28 06:03:09","2","7","0","143","all");
INSERT INTO log VALUES("758","2015-10-28 08:18:15","3","10","2","3","all");
INSERT INTO log VALUES("759","2015-10-28 08:18:18","2","12","3","292","all");
INSERT INTO log VALUES("760","2015-10-28 08:18:18","3","10","2","3","all");
INSERT INTO log VALUES("761","2015-10-28 08:18:28","2","12","3","292","all");
INSERT INTO log VALUES("762","2015-10-28 08:18:28","2","13","3","0","all");
INSERT INTO log VALUES("763","2015-10-28 08:18:37","2","12","5","203","all");
INSERT INTO log VALUES("764","2015-10-28 08:18:38","5","10","2","32","all");
INSERT INTO log VALUES("765","2015-10-28 08:18:40","2","12","5","70","all");
INSERT INTO log VALUES("766","2015-10-28 08:18:41","5","10","2","29","all");
INSERT INTO log VALUES("767","2015-10-28 08:18:51","2","12","5","72","all");
INSERT INTO log VALUES("768","2015-10-28 08:18:51","5","10","2","32","all");
INSERT INTO log VALUES("769","2015-10-28 08:18:51","5","10","2","31","all");
INSERT INTO log VALUES("770","2015-10-28 08:18:51","5","10","2","32","all");
INSERT INTO log VALUES("771","2015-10-28 08:18:55","2","12","5","71","all");
INSERT INTO log VALUES("772","2015-10-28 08:18:55","5","10","2","31","all");
INSERT INTO log VALUES("773","2015-10-28 08:22:00","2","12","5","70","all");
INSERT INTO log VALUES("774","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("775","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("776","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("777","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("778","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("779","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("780","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("781","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("782","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("783","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("784","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("785","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("786","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("787","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("788","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("789","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("790","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("791","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("792","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("793","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("794","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("795","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("796","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("797","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("798","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("799","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("800","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("801","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("802","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("803","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("804","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("805","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("806","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("807","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("808","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("809","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("810","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("811","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("812","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("813","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("814","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("815","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("816","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("817","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("818","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("819","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("820","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("821","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("822","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("823","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("824","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("825","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("826","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("827","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("828","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("829","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("830","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("831","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("832","2015-10-28 08:22:06","5","10","2","32","all");
INSERT INTO log VALUES("833","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("834","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("835","2015-10-28 08:22:06","5","10","2","30","all");
INSERT INTO log VALUES("836","2015-10-28 08:22:06","5","10","2","29","all");
INSERT INTO log VALUES("837","2015-10-28 08:22:06","5","10","2","31","all");
INSERT INTO log VALUES("838","2015-10-28 08:22:09","2","12","5","207","all");
INSERT INTO log VALUES("839","2015-10-28 08:22:10","5","10","2","32","all");
INSERT INTO log VALUES("840","2015-10-28 08:22:13","2","12","5","71","all");
INSERT INTO log VALUES("841","2015-10-28 08:22:13","5","10","2","31","all");
INSERT INTO log VALUES("842","2015-10-28 08:23:22","2","12","5","74","all");
INSERT INTO log VALUES("843","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("844","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("845","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("846","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("847","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("848","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("849","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("850","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("851","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("852","2015-10-28 08:23:23","5","10","2","29","all");
INSERT INTO log VALUES("853","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("854","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("855","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("856","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("857","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("858","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("859","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("860","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("861","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("862","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("863","2015-10-28 08:23:23","5","10","2","30","all");
INSERT INTO log VALUES("864","2015-10-28 08:23:23","5","10","2","31","all");
INSERT INTO log VALUES("865","2015-10-28 08:23:23","5","10","2","32","all");
INSERT INTO log VALUES("866","2015-10-28 08:23:26","2","12","5","196","all");
INSERT INTO log VALUES("867","2015-10-28 08:23:26","5","10","2","32","all");
INSERT INTO log VALUES("868","2015-10-28 08:23:30","2","5","0","0","all");
INSERT INTO log VALUES("869","2015-10-28 08:23:31","5","10","2","31","all");
INSERT INTO log VALUES("870","2015-10-28 08:23:31","5","10","2","30","all");
INSERT INTO log VALUES("871","2015-10-28 08:23:33","2","12","5","72","all");
INSERT INTO log VALUES("872","2015-10-28 08:23:33","5","10","2","30","all");
INSERT INTO log VALUES("873","2015-10-28 08:23:38","2","12","5","73","all");
INSERT INTO log VALUES("874","2015-10-28 08:23:39","5","10","2","30","all");
INSERT INTO log VALUES("875","2015-10-28 08:23:39","5","10","2","31","all");
INSERT INTO log VALUES("876","2015-10-28 08:23:43","2","12","5","73","all");
INSERT INTO log VALUES("877","2015-10-28 08:23:43","5","10","2","30","all");
INSERT INTO log VALUES("878","2015-10-28 08:23:48","2","12","5","73","all");
INSERT INTO log VALUES("879","2015-10-28 08:23:48","5","10","2","32","all");
INSERT INTO log VALUES("880","2015-10-28 08:23:48","5","10","2","31","all");
INSERT INTO log VALUES("881","2015-10-28 08:23:52","2","12","5","71","all");
INSERT INTO log VALUES("882","2015-10-28 08:23:52","5","10","2","29","all");
INSERT INTO log VALUES("883","2015-10-28 08:23:55","2","12","5","203","all");
INSERT INTO log VALUES("884","2015-10-28 08:23:55","5","10","2","32","all");
INSERT INTO log VALUES("885","2015-10-28 08:23:58","2","12","5","74","all");
INSERT INTO log VALUES("886","2015-10-28 08:23:59","5","10","2","31","all");
INSERT INTO log VALUES("887","2015-10-28 08:24:03","2","12","5","71","all");
INSERT INTO log VALUES("888","2015-10-28 08:24:03","5","10","2","30","all");
INSERT INTO log VALUES("889","2015-10-28 08:24:07","2","12","5","69","all");
INSERT INTO log VALUES("890","2015-10-28 08:24:08","5","10","2","31","all");
INSERT INTO log VALUES("891","2015-10-28 08:24:08","5","10","2","29","all");
INSERT INTO log VALUES("892","2015-10-28 08:24:11","2","12","5","69","all");
INSERT INTO log VALUES("893","2015-10-28 08:24:12","5","10","2","32","all");
INSERT INTO log VALUES("894","2015-10-28 08:24:17","5","10","2","29","all");
INSERT INTO log VALUES("895","2015-10-28 08:24:17","5","10","2","32","all");
INSERT INTO log VALUES("896","2015-10-28 08:24:20","2","12","5","72","all");
INSERT INTO log VALUES("897","2015-10-28 08:24:20","5","10","2","29","all");
INSERT INTO log VALUES("898","2015-10-28 08:24:23","2","12","5","195","all");
INSERT INTO log VALUES("899","2015-10-28 08:24:24","5","10","2","31","all");
INSERT INTO log VALUES("900","2015-10-28 08:24:26","2","12","5","69","all");
INSERT INTO log VALUES("901","2015-10-28 08:24:27","5","10","2","30","all");
INSERT INTO log VALUES("902","2015-10-28 08:24:31","2","12","5","71","all");
INSERT INTO log VALUES("903","2015-10-28 08:24:31","5","10","2","29","all");
INSERT INTO log VALUES("904","2015-10-28 08:24:36","2","12","5","71","all");
INSERT INTO log VALUES("905","2015-10-28 08:24:36","5","10","2","30","all");
INSERT INTO log VALUES("906","2015-10-28 08:24:36","5","10","2","31","all");
INSERT INTO log VALUES("907","2015-10-28 08:24:40","2","12","5","70","all");
INSERT INTO log VALUES("908","2015-10-28 08:24:41","5","10","2","31","all");
INSERT INTO log VALUES("909","2015-10-28 08:24:41","5","10","2","29","all");
INSERT INTO log VALUES("910","2015-10-28 08:24:46","2","12","5","74","all");
INSERT INTO log VALUES("911","2015-10-28 08:24:46","2","13","5","0","all");
INSERT INTO log VALUES("912","2015-10-28 10:02:50","7","7","0","150","all");
INSERT INTO log VALUES("913","2015-10-28 10:02:58","7","7","0","149","all");
INSERT INTO log VALUES("914","2015-10-28 10:03:15","7","7","0","152","all");
INSERT INTO log VALUES("915","2015-10-28 10:03:30","7","7","0","146","all");
INSERT INTO log VALUES("916","2015-10-28 10:03:50","7","7","0","144","all");
INSERT INTO log VALUES("917","2015-10-28 10:04:00","7","7","0","156","all");
INSERT INTO log VALUES("918","2015-10-28 12:55:01","2","12","5","72","all");
INSERT INTO log VALUES("919","2015-10-28 12:55:02","5","10","2","30","all");
INSERT INTO log VALUES("920","2015-10-28 12:55:03","2","12","5","205","all");
INSERT INTO log VALUES("921","2015-10-28 12:55:12","2","12","5","70","all");
INSERT INTO log VALUES("922","2015-10-28 12:55:13","5","10","2","30","all");
INSERT INTO log VALUES("923","2015-10-28 12:55:13","5","10","2","30","all");
INSERT INTO log VALUES("924","2015-10-28 12:55:13","5","10","2","30","all");
INSERT INTO log VALUES("925","2015-10-28 12:55:13","5","10","2","32","all");
INSERT INTO log VALUES("926","2015-10-28 12:55:17","2","12","5","69","all");
INSERT INTO log VALUES("927","2015-10-28 12:55:19","5","10","2","31","all");
INSERT INTO log VALUES("928","2015-10-28 12:55:19","5","10","2","32","all");
INSERT INTO log VALUES("929","2015-10-28 12:55:23","2","12","5","70","all");
INSERT INTO log VALUES("930","2015-10-28 12:55:24","5","10","2","31","all");
INSERT INTO log VALUES("931","2015-10-28 12:55:24","5","10","2","30","all");
INSERT INTO log VALUES("932","2015-10-28 12:55:28","2","12","5","71","all");
INSERT INTO log VALUES("933","2015-10-28 12:55:28","5","10","2","30","all");
INSERT INTO log VALUES("934","2015-10-28 12:55:33","2","12","5","74","all");
INSERT INTO log VALUES("935","2015-10-28 12:55:34","5","10","2","32","all");
INSERT INTO log VALUES("936","2015-10-28 12:55:34","5","10","2","31","all");
INSERT INTO log VALUES("937","2015-10-28 12:55:37","2","12","5","74","all");
INSERT INTO log VALUES("938","2015-10-28 12:55:38","5","10","2","29","all");
INSERT INTO log VALUES("939","2015-10-28 12:55:41","2","12","5","73","all");
INSERT INTO log VALUES("940","2015-10-28 12:55:42","5","10","2","31","all");
INSERT INTO log VALUES("941","2015-10-28 12:55:45","2","12","5","73","all");
INSERT INTO log VALUES("942","2015-10-28 12:55:45","5","10","2","29","all");
INSERT INTO log VALUES("943","2015-10-28 12:55:50","2","12","5","72","all");
INSERT INTO log VALUES("944","2015-10-28 12:55:50","5","10","2","31","all");
INSERT INTO log VALUES("945","2015-10-28 12:55:50","5","10","2","30","all");
INSERT INTO log VALUES("946","2015-10-28 12:55:55","2","12","5","73","all");
INSERT INTO log VALUES("947","2015-10-28 12:55:55","5","10","2","30","all");
INSERT INTO log VALUES("948","2015-10-28 12:55:55","5","10","2","31","all");
INSERT INTO log VALUES("949","2015-10-28 12:55:59","2","12","5","70","all");
INSERT INTO log VALUES("950","2015-10-28 12:56:00","5","10","2","31","all");
INSERT INTO log VALUES("951","2015-10-28 12:56:00","5","10","2","32","all");
INSERT INTO log VALUES("952","2015-10-28 12:56:03","5","10","2","32","all");
INSERT INTO log VALUES("953","2015-10-28 12:56:05","2","12","5","71","all");
INSERT INTO log VALUES("954","2015-10-28 12:56:06","5","10","2","32","all");
INSERT INTO log VALUES("955","2015-10-28 12:56:08","2","12","5","202","all");
INSERT INTO log VALUES("956","2015-10-28 12:56:09","5","10","2","32","all");
INSERT INTO log VALUES("957","2015-10-28 12:56:13","2","12","5","70","all");
INSERT INTO log VALUES("958","2015-10-28 12:56:13","5","10","2","30","all");
INSERT INTO log VALUES("959","2015-10-28 12:56:17","2","12","5","72","all");
INSERT INTO log VALUES("960","2015-10-28 12:56:17","5","10","2","31","all");
INSERT INTO log VALUES("961","2015-10-28 12:56:23","2","12","5","70","all");
INSERT INTO log VALUES("962","2015-10-28 12:56:24","5","10","2","31","all");
INSERT INTO log VALUES("963","2015-10-28 12:56:24","5","10","2","31","all");
INSERT INTO log VALUES("964","2015-10-28 12:56:29","2","12","5","70","all");
INSERT INTO log VALUES("965","2015-10-28 12:56:30","5","10","2","30","all");
INSERT INTO log VALUES("966","2015-10-28 12:56:30","5","10","2","32","all");
INSERT INTO log VALUES("967","2015-10-28 12:56:46","2","12","5","194","all");
INSERT INTO log VALUES("968","2015-10-28 12:56:47","5","10","2","31","all");
INSERT INTO log VALUES("969","2015-10-28 12:56:47","5","10","2","32","all");
INSERT INTO log VALUES("970","2015-10-28 12:56:47","5","10","2","31","all");
INSERT INTO log VALUES("971","2015-10-28 12:56:47","5","10","2","30","all");
INSERT INTO log VALUES("972","2015-10-28 12:56:47","5","10","2","30","all");
INSERT INTO log VALUES("973","2015-10-28 12:56:47","5","10","2","31","all");
INSERT INTO log VALUES("974","2015-10-28 12:56:49","2","12","5","69","all");
INSERT INTO log VALUES("975","2015-10-28 12:56:49","5","10","2","31","all");
INSERT INTO log VALUES("976","2015-10-28 12:56:53","2","12","5","72","all");
INSERT INTO log VALUES("977","2015-10-28 12:56:54","5","10","2","29","all");
INSERT INTO log VALUES("978","2015-10-28 12:56:54","5","10","2","32","all");
INSERT INTO log VALUES("979","2015-10-28 12:56:57","2","12","5","70","all");
INSERT INTO log VALUES("980","2015-10-28 12:56:57","5","10","2","31","all");
INSERT INTO log VALUES("981","2015-10-28 12:57:06","2","12","5","69","all");
INSERT INTO log VALUES("982","2015-10-28 12:57:08","5","10","2","31","all");
INSERT INTO log VALUES("983","2015-10-28 12:57:08","5","10","2","32","all");
INSERT INTO log VALUES("984","2015-10-28 12:57:08","5","10","2","32","all");
INSERT INTO log VALUES("985","2015-10-28 12:57:08","5","10","2","29","all");
INSERT INTO log VALUES("986","2015-10-28 12:57:31","2","12","5","199","all");
INSERT INTO log VALUES("987","2015-10-28 12:57:32","5","10","2","29","all");
INSERT INTO log VALUES("988","2015-10-28 12:57:32","5","10","2","31","all");
INSERT INTO log VALUES("989","2015-10-28 12:57:32","5","10","2","32","all");
INSERT INTO log VALUES("990","2015-10-28 12:57:32","5","10","2","30","all");
INSERT INTO log VALUES("991","2015-10-28 12:57:32","5","10","2","31","all");
INSERT INTO log VALUES("992","2015-10-28 12:57:32","5","10","2","32","all");
INSERT INTO log VALUES("993","2015-10-28 12:57:32","5","10","2","32","all");
INSERT INTO log VALUES("994","2015-10-28 12:57:32","5","10","2","32","all");
INSERT INTO log VALUES("995","2015-10-28 12:57:36","2","12","5","73","all");
INSERT INTO log VALUES("996","2015-10-28 12:57:36","5","10","2","30","all");
INSERT INTO log VALUES("997","2015-10-28 12:58:14","2","12","5","73","all");
INSERT INTO log VALUES("998","2015-10-28 12:58:15","5","10","2","31","all");
INSERT INTO log VALUES("999","2015-10-28 12:58:15","5","10","2","31","all");
INSERT INTO log VALUES("1000","2015-10-28 12:58:15","5","10","2","31","all");
INSERT INTO log VALUES("1001","2015-10-28 12:58:15","5","10","2","31","all");
INSERT INTO log VALUES("1002","2015-10-28 12:58:15","5","10","2","32","all");
INSERT INTO log VALUES("1003","2015-10-28 12:58:15","5","10","2","29","all");
INSERT INTO log VALUES("1004","2015-10-28 12:58:15","5","10","2","30","all");
INSERT INTO log VALUES("1005","2015-10-28 12:58:15","5","10","2","32","all");
INSERT INTO log VALUES("1006","2015-10-28 12:58:15","5","10","2","29","all");
INSERT INTO log VALUES("1007","2015-10-28 12:58:15","5","10","2","29","all");
INSERT INTO log VALUES("1008","2015-10-28 12:58:15","5","10","2","32","all");
INSERT INTO log VALUES("1009","2015-10-28 12:58:15","5","10","2","30","all");
INSERT INTO log VALUES("1010","2015-10-28 12:58:15","5","10","2","29","all");
INSERT INTO log VALUES("1011","2015-10-28 12:58:20","2","12","5","199","all");
INSERT INTO log VALUES("1012","2015-10-28 12:58:20","2","13","5","0","all");
INSERT INTO log VALUES("1013","2015-10-28 12:58:30","2","12","3","297","all");
INSERT INTO log VALUES("1014","2015-10-28 12:58:31","3","10","2","3","all");
INSERT INTO log VALUES("1015","2015-10-28 12:58:38","2","12","3","290","all");
INSERT INTO log VALUES("1016","2015-10-28 12:58:38","2","13","3","0","all");
INSERT INTO log VALUES("1017","2015-10-28 13:34:24","7","12","5","464","all");
INSERT INTO log VALUES("1018","2015-10-28 13:34:24","5","10","7","35","all");
INSERT INTO log VALUES("1019","2015-10-28 13:34:28","7","12","5","77","all");
INSERT INTO log VALUES("1020","2015-10-28 13:34:28","5","10","7","34","all");
INSERT INTO log VALUES("1021","2015-10-28 13:34:34","7","12","5","73","all");
INSERT INTO log VALUES("1022","2015-10-28 13:34:34","5","10","7","37","all");
INSERT INTO log VALUES("1023","2015-10-28 13:34:34","5","10","7","34","all");
INSERT INTO log VALUES("1024","2015-10-28 13:34:40","7","12","5","74","all");
INSERT INTO log VALUES("1025","2015-10-28 13:34:40","5","10","7","36","all");
INSERT INTO log VALUES("1026","2015-10-28 13:34:40","5","10","7","38","all");
INSERT INTO log VALUES("1027","2015-10-28 13:34:46","7","12","5","77","all");
INSERT INTO log VALUES("1028","2015-10-28 13:34:47","5","10","7","35","all");
INSERT INTO log VALUES("1029","2015-10-28 13:34:47","5","10","7","37","all");
INSERT INTO log VALUES("1030","2015-10-28 13:34:52","7","12","5","73","all");
INSERT INTO log VALUES("1031","2015-10-28 13:34:53","5","10","7","37","all");
INSERT INTO log VALUES("1032","2015-10-28 13:34:53","5","10","7","36","all");
INSERT INTO log VALUES("1033","2015-10-28 13:34:58","5","10","7","37","all");
INSERT INTO log VALUES("1034","2015-10-28 13:34:58","5","10","7","37","all");
INSERT INTO log VALUES("1035","2015-10-28 13:34:59","7","12","5","77","all");
INSERT INTO log VALUES("1036","2015-10-28 13:35:00","5","10","7","37","all");
INSERT INTO log VALUES("1037","2015-10-28 13:35:05","7","12","5","440","all");
INSERT INTO log VALUES("1038","2015-10-28 13:35:05","5","10","7","38","all");
INSERT INTO log VALUES("1039","2015-10-28 13:35:05","5","10","7","39","all");
INSERT INTO log VALUES("1040","2015-10-28 13:35:10","7","12","5","74","all");
INSERT INTO log VALUES("1041","2015-10-28 13:35:10","5","10","7","35","all");
INSERT INTO log VALUES("1042","2015-10-28 13:35:10","5","10","7","35","all");
INSERT INTO log VALUES("1043","2015-10-28 13:35:15","5","10","7","34","all");
INSERT INTO log VALUES("1044","2015-10-28 13:35:15","5","10","7","37","all");
INSERT INTO log VALUES("1045","2015-10-28 13:35:17","7","12","5","77","all");
INSERT INTO log VALUES("1046","2015-10-28 13:35:18","5","10","7","35","all");
INSERT INTO log VALUES("1047","2015-10-28 13:35:23","7","12","5","78","all");
INSERT INTO log VALUES("1048","2015-10-28 13:35:23","5","10","7","38","all");
INSERT INTO log VALUES("1049","2015-10-28 13:35:23","5","10","7","36","all");
INSERT INTO log VALUES("1050","2015-10-28 13:35:28","5","10","7","38","all");
INSERT INTO log VALUES("1051","2015-10-28 13:35:28","5","10","7","37","all");
INSERT INTO log VALUES("1052","2015-10-28 13:35:30","7","12","5","73","all");
INSERT INTO log VALUES("1053","2015-10-28 13:35:31","5","10","7","37","all");
INSERT INTO log VALUES("1054","2015-10-28 13:35:36","5","10","7","39","all");
INSERT INTO log VALUES("1055","2015-10-28 13:35:36","5","10","7","37","all");
INSERT INTO log VALUES("1056","2015-10-28 13:35:39","7","12","5","77","all");
INSERT INTO log VALUES("1057","2015-10-28 13:35:39","5","10","7","36","all");
INSERT INTO log VALUES("1058","2015-10-28 13:35:45","5","10","7","36","all");
INSERT INTO log VALUES("1059","2015-10-28 13:35:45","5","10","7","38","all");
INSERT INTO log VALUES("1060","2015-10-28 13:35:47","7","12","5","73","all");
INSERT INTO log VALUES("1061","2015-10-28 13:35:47","5","10","7","38","all");
INSERT INTO log VALUES("1062","2015-10-28 13:35:49","7","12","5","450","all");
INSERT INTO log VALUES("1063","2015-10-28 13:35:49","5","10","7","37","all");
INSERT INTO log VALUES("1064","2015-10-28 13:35:54","7","12","5","78","all");
INSERT INTO log VALUES("1065","2015-10-28 13:35:54","5","10","7","38","all");
INSERT INTO log VALUES("1066","2015-10-28 13:35:54","5","10","7","37","all");
INSERT INTO log VALUES("1067","2015-10-28 13:36:00","7","12","5","76","all");
INSERT INTO log VALUES("1068","2015-10-28 13:36:01","5","10","7","36","all");
INSERT INTO log VALUES("1069","2015-10-28 13:36:01","5","10","7","36","all");
INSERT INTO log VALUES("1070","2015-10-28 13:36:05","5","10","7","38","all");
INSERT INTO log VALUES("1071","2015-10-28 13:36:07","7","12","5","77","all");
INSERT INTO log VALUES("1072","2015-10-28 13:36:07","5","10","7","39","all");
INSERT INTO log VALUES("1073","2015-10-28 13:36:13","7","12","5","74","all");
INSERT INTO log VALUES("1074","2015-10-28 13:36:13","7","13","5","0","all");
INSERT INTO log VALUES("1075","2015-10-28 13:36:41","7","7","0","151","all");
INSERT INTO log VALUES("1076","2015-10-28 13:36:50","7","7","0","150","all");
INSERT INTO log VALUES("1077","2015-10-28 13:36:58","7","7","0","146","all");
INSERT INTO log VALUES("1078","2015-10-28 13:37:04","7","7","0","155","all");
INSERT INTO log VALUES("1079","2015-10-28 13:37:12","7","7","0","151","all");
INSERT INTO log VALUES("1080","2015-10-28 13:37:20","7","7","0","145","all");
INSERT INTO log VALUES("1081","2015-10-28 13:37:27","7","7","0","149","all");
INSERT INTO log VALUES("1082","2015-10-28 13:37:27","7","4","550","0","secret");
INSERT INTO log VALUES("1083","2015-10-28 13:37:38","7","12","3","1760","all");
INSERT INTO log VALUES("1084","2015-10-28 13:37:38","7","13","3","0","all");
INSERT INTO log VALUES("1085","2015-10-28 13:38:16","7","7","0","154","all");
INSERT INTO log VALUES("1086","2015-10-28 13:38:24","7","7","0","144","all");
INSERT INTO log VALUES("1087","2015-10-28 13:38:31","7","7","0","147","all");
INSERT INTO log VALUES("1088","2015-10-28 13:38:41","7","7","0","154","all");
INSERT INTO log VALUES("1089","2015-10-28 13:38:51","7","7","0","152","all");
INSERT INTO log VALUES("1090","2015-10-28 13:38:58","7","7","0","153","all");
INSERT INTO log VALUES("1091","2015-10-28 13:39:04","7","7","0","147","all");
INSERT INTO log VALUES("1092","2015-10-28 13:39:12","7","7","0","154","all");
INSERT INTO log VALUES("1093","2015-10-28 13:39:18","7","7","0","153","all");
INSERT INTO log VALUES("1094","2015-10-28 13:39:25","7","7","0","154","all");
INSERT INTO log VALUES("1095","2015-10-28 13:39:31","7","7","0","146","all");
INSERT INTO log VALUES("1096","2015-10-28 13:41:27","7","12","5","434","all");
INSERT INTO log VALUES("1097","2015-10-28 13:41:28","5","10","7","39","all");
INSERT INTO log VALUES("1098","2015-10-28 13:41:28","5","10","7","38","all");
INSERT INTO log VALUES("1099","2015-10-28 13:41:31","7","12","5","77","all");
INSERT INTO log VALUES("1100","2015-10-28 13:41:31","5","10","7","35","all");
INSERT INTO log VALUES("1101","2015-10-28 13:41:37","7","12","5","74","all");
INSERT INTO log VALUES("1102","2015-10-28 13:41:37","5","10","7","36","all");
INSERT INTO log VALUES("1103","2015-10-28 13:41:37","5","10","7","35","all");
INSERT INTO log VALUES("1104","2015-10-28 13:41:43","7","12","5","76","all");
INSERT INTO log VALUES("1105","2015-10-28 13:41:44","5","10","7","35","all");
INSERT INTO log VALUES("1106","2015-10-28 13:41:44","5","10","7","36","all");
INSERT INTO log VALUES("1107","2015-10-28 13:41:49","7","12","5","73","all");
INSERT INTO log VALUES("1108","2015-10-28 13:41:49","5","10","7","35","all");
INSERT INTO log VALUES("1109","2015-10-28 13:41:49","5","10","7","37","all");
INSERT INTO log VALUES("1110","2015-10-28 13:41:55","7","12","5","73","all");
INSERT INTO log VALUES("1111","2015-10-28 13:41:55","5","10","7","36","all");
INSERT INTO log VALUES("1112","2015-10-28 13:41:55","5","10","7","37","all");
INSERT INTO log VALUES("1113","2015-10-28 13:42:01","7","12","5","72","all");
INSERT INTO log VALUES("1114","2015-10-28 13:42:02","5","10","7","36","all");
INSERT INTO log VALUES("1115","2015-10-28 13:42:02","5","10","7","35","all");
INSERT INTO log VALUES("1116","2015-10-28 13:42:08","7","12","5","74","all");
INSERT INTO log VALUES("1117","2015-10-28 13:42:09","5","10","7","36","all");
INSERT INTO log VALUES("1118","2015-10-28 13:42:09","5","10","7","39","all");
INSERT INTO log VALUES("1119","2015-10-28 13:42:14","7","12","5","445","all");
INSERT INTO log VALUES("1120","2015-10-28 13:42:14","5","10","7","36","all");
INSERT INTO log VALUES("1121","2015-10-28 13:42:14","5","10","7","38","all");
INSERT INTO log VALUES("1122","2015-10-28 13:42:17","7","12","5","72","all");
INSERT INTO log VALUES("1123","2015-10-28 13:42:17","5","10","7","36","all");
INSERT INTO log VALUES("1124","2015-10-28 13:42:23","7","12","5","75","all");
INSERT INTO log VALUES("1125","2015-10-28 13:42:23","5","10","7","37","all");
INSERT INTO log VALUES("1126","2015-10-28 13:42:23","5","10","7","39","all");
INSERT INTO log VALUES("1127","2015-10-28 13:42:29","7","12","5","75","all");
INSERT INTO log VALUES("1128","2015-10-28 13:42:29","5","10","7","36","all");
INSERT INTO log VALUES("1129","2015-10-28 13:42:29","5","10","7","35","all");
INSERT INTO log VALUES("1130","2015-10-28 13:42:35","7","12","5","78","all");
INSERT INTO log VALUES("1131","2015-10-28 13:42:35","5","10","7","35","all");
INSERT INTO log VALUES("1132","2015-10-28 13:42:35","5","10","7","35","all");
INSERT INTO log VALUES("1133","2015-10-28 13:42:44","7","12","5","78","all");
INSERT INTO log VALUES("1134","2015-10-28 13:42:45","5","10","7","36","all");
INSERT INTO log VALUES("1135","2015-10-28 13:42:45","5","10","7","38","all");
INSERT INTO log VALUES("1136","2015-10-28 13:42:45","5","10","7","39","all");
INSERT INTO log VALUES("1137","2015-10-28 13:42:51","7","12","5","77","all");
INSERT INTO log VALUES("1138","2015-10-28 13:42:51","5","10","7","37","all");
INSERT INTO log VALUES("1139","2015-10-28 13:42:51","5","10","7","35","all");
INSERT INTO log VALUES("1140","2015-10-28 13:42:57","7","12","5","73","all");
INSERT INTO log VALUES("1141","2015-10-28 13:42:58","5","10","7","36","all");
INSERT INTO log VALUES("1142","2015-10-28 13:42:58","5","10","7","35","all");
INSERT INTO log VALUES("1143","2015-10-28 13:43:00","7","12","5","439","all");
INSERT INTO log VALUES("1144","2015-10-28 13:43:01","5","10","7","35","all");
INSERT INTO log VALUES("1145","2015-10-28 13:43:04","7","12","5","72","all");
INSERT INTO log VALUES("1146","2015-10-28 13:43:05","5","10","7","36","all");
INSERT INTO log VALUES("1147","2015-10-28 13:43:10","7","12","5","74","all");
INSERT INTO log VALUES("1148","2015-10-28 13:43:10","7","13","5","0","all");
INSERT INTO log VALUES("1149","2015-10-28 13:46:41","7","12","3","1785","all");
INSERT INTO log VALUES("1150","2015-10-28 13:46:41","7","13","3","0","all");
INSERT INTO log VALUES("1151","2015-10-28 13:47:02","7","7","0","506","all");
INSERT INTO log VALUES("1152","2015-10-28 13:47:02","7","4","266","0","base");
INSERT INTO log VALUES("1153","2015-10-28 13:48:36","7","12","5","452","all");
INSERT INTO log VALUES("1154","2015-10-28 13:48:37","5","10","7","37","all");
INSERT INTO log VALUES("1155","2015-10-28 13:48:39","7","12","5","75","all");
INSERT INTO log VALUES("1156","2015-10-28 13:48:40","5","10","7","39","all");
INSERT INTO log VALUES("1157","2015-10-28 13:48:45","7","12","5","72","all");
INSERT INTO log VALUES("1158","2015-10-28 13:48:46","5","10","7","37","all");
INSERT INTO log VALUES("1159","2015-10-28 13:48:46","5","10","7","37","all");
INSERT INTO log VALUES("1160","2015-10-28 13:48:53","7","12","5","77","all");
INSERT INTO log VALUES("1161","2015-10-28 13:48:53","5","10","7","37","all");
INSERT INTO log VALUES("1162","2015-10-28 13:48:53","5","10","7","38","all");
INSERT INTO log VALUES("1163","2015-10-28 13:48:59","7","12","5","75","all");
INSERT INTO log VALUES("1164","2015-10-28 13:49:00","5","10","7","35","all");
INSERT INTO log VALUES("1165","2015-10-28 13:49:00","5","10","7","36","all");
INSERT INTO log VALUES("1166","2015-10-28 13:49:05","7","12","5","74","all");
INSERT INTO log VALUES("1167","2015-10-28 13:49:05","5","10","7","35","all");
INSERT INTO log VALUES("1168","2015-10-28 13:49:05","5","10","7","37","all");
INSERT INTO log VALUES("1169","2015-10-28 13:49:10","5","10","7","35","all");
INSERT INTO log VALUES("1170","2015-10-28 13:49:10","5","10","7","35","all");
INSERT INTO log VALUES("1171","2015-10-28 13:49:13","7","12","5","75","all");
INSERT INTO log VALUES("1172","2015-10-28 13:49:13","5","10","7","35","all");
INSERT INTO log VALUES("1173","2015-10-28 13:49:19","7","12","5","77","all");
INSERT INTO log VALUES("1174","2015-10-28 13:49:19","5","10","7","35","all");
INSERT INTO log VALUES("1175","2015-10-28 13:49:19","5","10","7","36","all");
INSERT INTO log VALUES("1176","2015-10-28 13:49:23","7","12","5","433","all");
INSERT INTO log VALUES("1177","2015-10-28 13:49:23","5","10","7","36","all");
INSERT INTO log VALUES("1178","2015-10-28 13:49:39","7","12","5","75","all");
INSERT INTO log VALUES("1179","2015-10-28 13:49:39","5","10","7","38","all");
INSERT INTO log VALUES("1180","2015-10-28 13:49:39","5","10","7","35","all");
INSERT INTO log VALUES("1181","2015-10-28 13:49:39","5","10","7","36","all");
INSERT INTO log VALUES("1182","2015-10-28 13:49:39","5","10","7","37","all");
INSERT INTO log VALUES("1183","2015-10-28 13:49:39","5","10","7","38","all");
INSERT INTO log VALUES("1184","2015-10-28 13:49:46","7","12","5","74","all");
INSERT INTO log VALUES("1185","2015-10-28 13:49:47","5","10","7","35","all");
INSERT INTO log VALUES("1186","2015-10-28 13:49:47","5","10","7","35","all");
INSERT INTO log VALUES("1187","2015-10-28 13:49:47","5","10","7","39","all");
INSERT INTO log VALUES("1188","2015-10-28 13:49:53","7","12","5","72","all");
INSERT INTO log VALUES("1189","2015-10-28 13:49:54","5","10","7","36","all");
INSERT INTO log VALUES("1190","2015-10-28 13:49:54","5","10","7","35","all");
INSERT INTO log VALUES("1191","2015-10-28 13:49:58","5","10","7","37","all");
INSERT INTO log VALUES("1192","2015-10-28 13:50:01","7","12","5","78","all");
INSERT INTO log VALUES("1193","2015-10-28 13:50:01","5","10","7","35","all");
INSERT INTO log VALUES("1194","2015-10-28 13:50:04","7","12","5","439","all");
INSERT INTO log VALUES("1195","2015-10-28 13:50:04","5","10","7","36","all");
INSERT INTO log VALUES("1196","2015-10-28 13:50:08","7","12","5","73","all");
INSERT INTO log VALUES("1197","2015-10-28 13:50:09","5","10","7","37","all");
INSERT INTO log VALUES("1198","2015-10-28 13:50:09","5","10","7","34","all");
INSERT INTO log VALUES("1199","2015-10-28 13:50:14","7","12","5","73","all");
INSERT INTO log VALUES("1200","2015-10-28 13:50:14","5","10","7","35","all");
INSERT INTO log VALUES("1201","2015-10-28 13:50:14","5","10","7","36","all");
INSERT INTO log VALUES("1202","2015-10-28 13:50:21","7","12","5","75","all");
INSERT INTO log VALUES("1203","2015-10-28 13:50:21","5","10","7","35","all");
INSERT INTO log VALUES("1204","2015-10-28 13:50:21","5","10","7","35","all");
INSERT INTO log VALUES("1205","2015-10-28 13:50:28","7","12","5","76","all");
INSERT INTO log VALUES("1206","2015-10-28 13:50:28","5","10","7","37","all");
INSERT INTO log VALUES("1207","2015-10-28 13:50:28","5","10","7","39","all");
INSERT INTO log VALUES("1208","2015-10-28 13:50:33","5","10","7","35","all");
INSERT INTO log VALUES("1209","2015-10-28 13:50:33","5","10","7","37","all");
INSERT INTO log VALUES("1210","2015-10-28 13:50:35","7","12","5","74","all");
INSERT INTO log VALUES("1211","2015-10-28 13:50:35","7","13","5","0","all");
INSERT INTO log VALUES("1212","2015-10-28 13:53:59","7","12","3","1819","all");
INSERT INTO log VALUES("1213","2015-10-28 13:53:59","7","13","3","0","all");
INSERT INTO log VALUES("1214","2015-10-28 13:56:12","7","12","5","455","all");
INSERT INTO log VALUES("1215","2015-10-28 13:56:12","5","10","7","38","all");
INSERT INTO log VALUES("1216","2015-10-28 13:56:18","7","12","5","74","all");
INSERT INTO log VALUES("1217","2015-10-28 13:56:19","5","10","7","37","all");
INSERT INTO log VALUES("1218","2015-10-28 13:56:19","5","10","7","36","all");
INSERT INTO log VALUES("1219","2015-10-28 13:56:24","7","12","5","73","all");
INSERT INTO log VALUES("1220","2015-10-28 13:56:25","5","10","7","38","all");
INSERT INTO log VALUES("1221","2015-10-28 13:56:25","5","10","7","38","all");
INSERT INTO log VALUES("1222","2015-10-28 13:56:30","7","12","5","74","all");
INSERT INTO log VALUES("1223","2015-10-28 13:56:30","5","10","7","35","all");
INSERT INTO log VALUES("1224","2015-10-28 13:56:30","5","10","7","37","all");
INSERT INTO log VALUES("1225","2015-10-28 13:56:36","5","10","7","37","all");
INSERT INTO log VALUES("1226","2015-10-28 13:56:36","5","10","7","38","all");
INSERT INTO log VALUES("1227","2015-10-28 13:56:39","7","12","5","76","all");
INSERT INTO log VALUES("1228","2015-10-28 13:56:39","5","10","7","35","all");
INSERT INTO log VALUES("1229","2015-10-28 13:56:48","7","12","5","74","all");
INSERT INTO log VALUES("1230","2015-10-28 13:56:48","5","10","7","35","all");
INSERT INTO log VALUES("1231","2015-10-28 13:56:48","5","10","7","37","all");
INSERT INTO log VALUES("1232","2015-10-28 13:56:48","5","10","7","34","all");
INSERT INTO log VALUES("1233","2015-10-28 13:56:56","7","12","5","77","all");
INSERT INTO log VALUES("1234","2015-10-28 13:56:57","5","10","7","38","all");
INSERT INTO log VALUES("1235","2015-10-28 13:56:57","5","10","7","35","all");
INSERT INTO log VALUES("1236","2015-10-28 13:56:57","5","10","7","36","all");
INSERT INTO log VALUES("1237","2015-10-28 13:57:02","7","12","5","438","all");
INSERT INTO log VALUES("1238","2015-10-28 13:57:02","5","10","7","36","all");
INSERT INTO log VALUES("1239","2015-10-28 13:57:02","5","10","7","35","all");
INSERT INTO log VALUES("1240","2015-10-28 13:57:06","7","12","5","77","all");
INSERT INTO log VALUES("1241","2015-10-28 13:57:06","5","10","7","35","all");
INSERT INTO log VALUES("1242","2015-10-28 13:57:12","7","12","5","74","all");
INSERT INTO log VALUES("1243","2015-10-28 13:57:13","5","10","7","37","all");
INSERT INTO log VALUES("1244","2015-10-28 13:57:13","5","10","7","35","all");
INSERT INTO log VALUES("1245","2015-10-28 13:57:20","7","12","5","74","all");
INSERT INTO log VALUES("1246","2015-10-28 13:57:20","5","10","7","37","all");
INSERT INTO log VALUES("1247","2015-10-28 13:57:20","5","10","7","37","all");
INSERT INTO log VALUES("1248","2015-10-28 13:57:26","7","12","5","73","all");
INSERT INTO log VALUES("1249","2015-10-28 13:57:27","5","10","7","38","all");
INSERT INTO log VALUES("1250","2015-10-28 13:57:27","5","10","7","36","all");
INSERT INTO log VALUES("1251","2015-10-28 13:57:32","7","12","5","74","all");
INSERT INTO log VALUES("1252","2015-10-28 13:57:33","5","10","7","38","all");
INSERT INTO log VALUES("1253","2015-10-28 13:57:33","5","10","7","36","all");
INSERT INTO log VALUES("1254","2015-10-28 13:57:38","5","10","7","37","all");
INSERT INTO log VALUES("1255","2015-10-28 13:57:38","5","10","7","35","all");
INSERT INTO log VALUES("1256","2015-10-28 13:57:40","7","12","5","75","all");
INSERT INTO log VALUES("1257","2015-10-28 13:57:40","5","10","7","36","all");
INSERT INTO log VALUES("1258","2015-10-28 13:57:44","7","12","5","462","all");
INSERT INTO log VALUES("1259","2015-10-28 13:57:44","5","10","7","37","all");
INSERT INTO log VALUES("1260","2015-10-28 13:57:48","7","12","5","75","all");
INSERT INTO log VALUES("1261","2015-10-28 13:57:48","5","10","7","35","all");
INSERT INTO log VALUES("1262","2015-10-28 13:57:53","5","10","7","36","all");
INSERT INTO log VALUES("1263","2015-10-28 13:57:53","5","10","7","35","all");
INSERT INTO log VALUES("1264","2015-10-28 13:57:55","7","12","5","72","all");
INSERT INTO log VALUES("1265","2015-10-28 13:57:56","5","10","7","36","all");
INSERT INTO log VALUES("1266","2015-10-28 13:58:01","7","6","0","13","all");
INSERT INTO log VALUES("1267","2015-10-28 13:58:01","7","12","5","73","all");
INSERT INTO log VALUES("1268","2015-10-28 13:58:02","5","10","7","36","all");
INSERT INTO log VALUES("1269","2015-10-28 13:58:02","5","10","7","34","all");
INSERT INTO log VALUES("1270","2015-10-28 13:58:07","7","12","5","75","all");
INSERT INTO log VALUES("1271","2015-10-28 13:58:07","7","13","5","0","all");
INSERT INTO log VALUES("1272","2015-10-28 14:04:51","7","12","3","1751","all");
INSERT INTO log VALUES("1273","2015-10-28 14:04:51","7","13","3","0","all");
INSERT INTO log VALUES("1274","2015-10-28 14:05:03","5","10","7","37","all");
INSERT INTO log VALUES("1275","2015-10-28 14:05:03","5","10","7","36","all");
INSERT INTO log VALUES("1276","2015-10-28 14:05:07","7","12","5","74","all");
INSERT INTO log VALUES("1277","2015-10-28 14:05:07","5","10","7","35","all");
INSERT INTO log VALUES("1278","2015-10-28 14:05:13","7","12","5","77","all");
INSERT INTO log VALUES("1279","2015-10-28 14:05:14","5","10","7","38","all");
INSERT INTO log VALUES("1280","2015-10-28 14:05:14","5","10","7","38","all");
INSERT INTO log VALUES("1281","2015-10-28 14:05:18","5","10","7","38","all");
INSERT INTO log VALUES("1282","2015-10-28 14:05:20","7","12","5","74","all");
INSERT INTO log VALUES("1283","2015-10-28 14:05:21","5","10","7","38","all");
INSERT INTO log VALUES("1284","2015-10-28 14:05:26","5","10","7","35","all");
INSERT INTO log VALUES("1285","2015-10-28 14:05:26","5","10","7","38","all");
INSERT INTO log VALUES("1286","2015-10-28 14:05:27","7","12","5","73","all");
INSERT INTO log VALUES("1287","2015-10-28 14:05:28","5","10","7","36","all");
INSERT INTO log VALUES("1288","2015-10-28 14:05:31","5","10","7","37","all");
INSERT INTO log VALUES("1289","2015-10-28 14:05:33","7","12","5","434","all");
INSERT INTO log VALUES("1290","2015-10-28 14:05:34","5","10","7","36","all");
INSERT INTO log VALUES("1291","2015-10-28 14:05:39","7","12","5","74","all");
INSERT INTO log VALUES("1292","2015-10-28 14:05:40","5","10","7","35","all");
INSERT INTO log VALUES("1293","2015-10-28 14:05:40","5","10","7","35","all");
INSERT INTO log VALUES("1294","2015-10-28 14:05:45","5","10","7","39","all");
INSERT INTO log VALUES("1295","2015-10-28 14:05:45","5","10","7","37","all");
INSERT INTO log VALUES("1296","2015-10-28 14:05:46","7","12","5","77","all");
INSERT INTO log VALUES("1297","2015-10-28 14:05:53","7","12","5","77","all");
INSERT INTO log VALUES("1298","2015-10-28 14:05:54","5","10","7","37","all");
INSERT INTO log VALUES("1299","2015-10-28 14:05:54","5","10","7","38","all");
INSERT INTO log VALUES("1300","2015-10-28 14:05:54","5","10","7","36","all");
INSERT INTO log VALUES("1301","2015-10-28 14:06:02","7","12","5","73","all");
INSERT INTO log VALUES("1302","2015-10-28 14:06:02","5","10","7","35","all");
INSERT INTO log VALUES("1303","2015-10-28 14:06:02","5","10","7","35","all");
INSERT INTO log VALUES("1304","2015-10-28 14:06:02","5","10","7","37","all");
INSERT INTO log VALUES("1305","2015-10-28 14:06:09","7","12","5","72","all");
INSERT INTO log VALUES("1306","2015-10-28 14:06:10","5","10","7","36","all");
INSERT INTO log VALUES("1307","2015-10-28 14:06:10","5","10","7","36","all");
INSERT INTO log VALUES("1308","2015-10-28 14:06:10","5","10","7","36","all");
INSERT INTO log VALUES("1309","2015-10-28 14:06:15","7","12","5","78","all");
INSERT INTO log VALUES("1310","2015-10-28 14:06:15","5","10","7","36","all");
INSERT INTO log VALUES("1311","2015-10-28 14:06:15","5","10","7","35","all");
INSERT INTO log VALUES("1312","2015-10-28 14:06:18","7","12","5","463","all");
INSERT INTO log VALUES("1313","2015-10-28 14:06:19","5","10","7","34","all");
INSERT INTO log VALUES("1314","2015-10-28 14:06:23","7","12","5","73","all");
INSERT INTO log VALUES("1315","2015-10-28 14:06:24","5","10","7","37","all");
INSERT INTO log VALUES("1316","2015-10-28 14:06:24","5","10","7","35","all");
INSERT INTO log VALUES("1317","2015-10-28 14:06:28","5","10","7","36","all");
INSERT INTO log VALUES("1318","2015-10-28 14:06:30","7","12","5","77","all");
INSERT INTO log VALUES("1319","2015-10-28 14:06:30","5","10","7","39","all");
INSERT INTO log VALUES("1320","2015-10-28 14:06:36","5","10","7","36","all");
INSERT INTO log VALUES("1321","2015-10-28 14:06:36","5","10","7","39","all");
INSERT INTO log VALUES("1322","2015-10-28 14:06:38","7","12","5","73","all");
INSERT INTO log VALUES("1323","2015-10-28 14:06:38","5","10","7","37","all");
INSERT INTO log VALUES("1324","2015-10-28 14:06:47","7","12","5","73","all");
INSERT INTO log VALUES("1325","2015-10-28 14:06:48","5","10","7","35","all");
INSERT INTO log VALUES("1326","2015-10-28 14:06:48","5","10","7","37","all");
INSERT INTO log VALUES("1327","2015-10-28 14:06:48","5","10","7","36","all");
INSERT INTO log VALUES("1328","2015-10-28 14:06:57","7","12","5","75","all");
INSERT INTO log VALUES("1329","2015-10-28 14:06:58","5","10","7","38","all");
INSERT INTO log VALUES("1330","2015-10-28 14:06:58","5","10","7","35","all");
INSERT INTO log VALUES("1331","2015-10-28 14:06:58","5","10","7","36","all");
INSERT INTO log VALUES("1332","2015-10-28 14:07:01","7","12","5","465","all");
INSERT INTO log VALUES("1333","2015-10-28 14:07:01","5","10","7","38","all");
INSERT INTO log VALUES("1334","2015-10-28 14:07:05","7","12","5","77","all");
INSERT INTO log VALUES("1335","2015-10-28 14:07:05","7","13","5","0","all");
INSERT INTO log VALUES("1336","2015-10-28 14:41:09","11","7","0","76","all");
INSERT INTO log VALUES("1337","2015-10-28 14:41:15","11","7","0","77","all");
INSERT INTO log VALUES("1338","2015-10-28 14:41:21","11","7","0","76","all");
INSERT INTO log VALUES("1339","2015-10-28 14:41:21","11","6","0","2","all");
INSERT INTO log VALUES("1340","2015-10-28 14:44:35","11","7","0","73","all");
INSERT INTO log VALUES("1341","2015-10-28 14:44:42","11","7","0","77","all");
INSERT INTO log VALUES("1342","2015-10-28 14:45:22","11","7","0","242","all");
INSERT INTO log VALUES("1343","2015-10-28 14:45:22","11","6","0","3","all");
INSERT INTO log VALUES("1344","2015-10-28 14:45:29","11","7","0","246","all");
INSERT INTO log VALUES("1345","2015-10-28 14:45:29","11","4","255","0","base");
INSERT INTO log VALUES("1346","2015-10-28 14:45:44","11","6","0","4","all");
INSERT INTO log VALUES("1347","2015-10-28 14:45:44","11","12","3","151","all");
INSERT INTO log VALUES("1348","2015-10-28 14:45:44","3","10","11","10","all");
INSERT INTO log VALUES("1349","2015-10-28 14:45:47","11","6","0","6","all");
INSERT INTO log VALUES("1350","2015-10-28 14:45:47","11","12","3","681","all");
INSERT INTO log VALUES("1351","2015-10-28 14:45:47","11","13","3","0","all");
INSERT INTO log VALUES("1352","2015-10-28 14:46:07","11","7","0","77","all");
INSERT INTO log VALUES("1353","2015-10-28 14:46:14","11","7","0","78","all");
INSERT INTO log VALUES("1354","2015-10-28 15:04:44","7","12","5","467","all");
INSERT INTO log VALUES("1355","2015-10-28 15:04:44","5","10","7","35","all");
INSERT INTO log VALUES("1356","2015-10-28 15:04:49","7","12","5","77","all");
INSERT INTO log VALUES("1357","2015-10-28 15:04:49","5","10","7","39","all");
INSERT INTO log VALUES("1358","2015-10-28 15:04:49","5","10","7","36","all");
INSERT INTO log VALUES("1359","2015-10-28 15:04:56","7","12","5","73","all");
INSERT INTO log VALUES("1360","2015-10-28 15:04:56","5","10","7","35","all");
INSERT INTO log VALUES("1361","2015-10-28 15:04:56","5","10","7","35","all");
INSERT INTO log VALUES("1362","2015-10-28 15:05:03","7","12","5","75","all");
INSERT INTO log VALUES("1363","2015-10-28 15:05:03","5","10","7","35","all");
INSERT INTO log VALUES("1364","2015-10-28 15:05:03","5","10","7","38","all");
INSERT INTO log VALUES("1365","2015-10-28 15:05:08","5","10","7","37","all");
INSERT INTO log VALUES("1366","2015-10-28 15:05:08","5","10","7","38","all");
INSERT INTO log VALUES("1367","2015-10-28 15:05:10","7","12","5","72","all");
INSERT INTO log VALUES("1368","2015-10-28 15:05:10","5","10","7","37","all");
INSERT INTO log VALUES("1369","2015-10-28 15:05:16","5","10","7","36","all");
INSERT INTO log VALUES("1370","2015-10-28 15:05:16","5","10","7","37","all");
INSERT INTO log VALUES("1371","2015-10-28 15:05:17","7","12","5","72","all");
INSERT INTO log VALUES("1372","2015-10-28 15:05:18","5","10","7","36","all");
INSERT INTO log VALUES("1373","2015-10-28 15:05:23","7","12","5","76","all");
INSERT INTO log VALUES("1374","2015-10-28 15:05:24","5","10","7","35","all");
INSERT INTO log VALUES("1375","2015-10-28 15:05:24","5","10","7","35","all");
INSERT INTO log VALUES("1376","2015-10-28 15:05:27","7","12","5","455","all");
INSERT INTO log VALUES("1377","2015-10-28 15:05:28","5","10","7","36","all");
INSERT INTO log VALUES("1378","2015-10-28 15:05:32","7","12","5","73","all");
INSERT INTO log VALUES("1379","2015-10-28 15:05:32","5","10","7","36","all");
INSERT INTO log VALUES("1380","2015-10-28 15:05:37","5","10","7","34","all");
INSERT INTO log VALUES("1381","2015-10-28 15:05:37","5","10","7","36","all");
INSERT INTO log VALUES("1382","2015-10-28 15:05:39","7","12","5","73","all");
INSERT INTO log VALUES("1383","2015-10-28 15:05:39","5","10","7","37","all");
INSERT INTO log VALUES("1384","2015-10-28 15:06:05","7","12","5","75","all");
INSERT INTO log VALUES("1385","2015-10-28 15:06:05","5","10","7","36","all");
INSERT INTO log VALUES("1386","2015-10-28 15:06:05","5","10","7","36","all");
INSERT INTO log VALUES("1387","2015-10-28 15:06:05","5","10","7","38","all");
INSERT INTO log VALUES("1388","2015-10-28 15:06:05","5","10","7","37","all");
INSERT INTO log VALUES("1389","2015-10-28 15:06:05","5","10","7","35","all");
INSERT INTO log VALUES("1390","2015-10-28 15:06:05","5","10","7","35","all");
INSERT INTO log VALUES("1391","2015-10-28 15:06:05","5","10","7","37","all");
INSERT INTO log VALUES("1392","2015-10-28 15:06:05","5","10","7","36","all");
INSERT INTO log VALUES("1393","2015-10-28 15:06:05","5","10","7","36","all");
INSERT INTO log VALUES("1394","2015-10-28 15:06:09","7","12","5","458","all");
INSERT INTO log VALUES("1395","2015-10-28 15:06:09","5","10","7","38","all");
INSERT INTO log VALUES("1396","2015-10-28 15:06:14","7","12","5","74","all");
INSERT INTO log VALUES("1397","2015-10-28 15:06:15","5","10","7","37","all");
INSERT INTO log VALUES("1398","2015-10-28 15:06:15","5","10","7","36","all");
INSERT INTO log VALUES("1399","2015-10-28 15:06:21","7","12","5","74","all");
INSERT INTO log VALUES("1400","2015-10-28 15:06:21","5","10","7","36","all");
INSERT INTO log VALUES("1401","2015-10-28 15:06:21","5","10","7","35","all");
INSERT INTO log VALUES("1402","2015-10-28 15:06:28","7","12","5","73","all");
INSERT INTO log VALUES("1403","2015-10-28 15:06:29","5","10","7","36","all");
INSERT INTO log VALUES("1404","2015-10-28 15:06:29","5","10","7","39","all");
INSERT INTO log VALUES("1405","2015-10-28 15:06:29","5","10","7","38","all");
INSERT INTO log VALUES("1406","2015-10-28 15:06:33","5","10","7","39","all");
INSERT INTO log VALUES("1407","2015-10-28 15:06:35","7","12","5","72","all");
INSERT INTO log VALUES("1408","2015-10-28 15:06:36","5","10","7","35","all");
INSERT INTO log VALUES("1409","2015-10-28 15:06:41","7","12","5","72","all");
INSERT INTO log VALUES("1410","2015-10-28 15:06:41","5","10","7","37","all");
INSERT INTO log VALUES("1411","2015-10-28 15:06:41","5","10","7","38","all");
INSERT INTO log VALUES("1412","2015-10-28 15:06:47","7","12","5","72","all");
INSERT INTO log VALUES("1413","2015-10-28 15:06:47","5","10","7","35","all");
INSERT INTO log VALUES("1414","2015-10-28 15:06:47","5","10","7","39","all");
INSERT INTO log VALUES("1415","2015-10-28 15:06:53","7","12","5","73","all");
INSERT INTO log VALUES("1416","2015-10-28 15:06:53","7","13","5","0","all");
INSERT INTO log VALUES("1417","2015-10-28 15:07:04","7","12","3","1811","all");
INSERT INTO log VALUES("1418","2015-10-28 15:07:04","7","13","3","0","all");



DROP TABLE IF EXISTS `login`;

CREATE TABLE `login` (
  `id_login` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(32) DEFAULT NULL,
  `count_login` int(11) DEFAULT NULL,
  `count_relost` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_login`)
) ENGINE=MyISAM AUTO_INCREMENT=5374 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `m_fight`;

CREATE TABLE `m_fight` (
  `id_fight` bigint(11) NOT NULL AUTO_INCREMENT,
  `id_monster` int(11) NOT NULL,
  `hp` int(11) NOT NULL,
  `start` int(11) NOT NULL,
  `last_active` datetime DEFAULT NULL,
  `time_start` datetime NOT NULL,
  `clan_id` int(11) NOT NULL DEFAULT '0',
  `gruppa` varchar(16) NOT NULL DEFAULT 'clan',
  PRIMARY KEY (`id_fight`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;

INSERT INTO m_fight VALUES("1","3","352","1","2015-10-27 03:40:18","2015-10-27 03:40:10","0","naemniki");
INSERT INTO m_fight VALUES("2","3","500","1","2015-10-27 03:40:27","2015-10-27 03:40:27","0","naemniki");
INSERT INTO m_fight VALUES("3","3","500","1","2015-10-27 03:48:35","2015-10-27 03:48:35","0","naemniki");
INSERT INTO m_fight VALUES("4","3","346","1","2015-10-27 04:32:11","2015-10-27 04:32:08","0","naemniki");
INSERT INTO m_fight VALUES("5","3","500","1","2015-10-27 04:37:01","2015-10-27 04:37:01","0","naemniki");
INSERT INTO m_fight VALUES("6","3","500","1","2015-10-27 04:38:19","2015-10-27 04:38:19","0","naemniki");
INSERT INTO m_fight VALUES("7","3","500","1","2015-10-27 04:43:33","2015-10-27 04:43:33","0","naemniki");
INSERT INTO m_fight VALUES("8","3","500","1","2015-10-27 04:47:22","2015-10-27 04:47:22","0","naemniki");
INSERT INTO m_fight VALUES("9","3","500","1","2015-10-27 04:50:04","2015-10-27 04:50:04","0","naemniki");
INSERT INTO m_fight VALUES("10","3","500","1","2015-10-27 05:00:42","2015-10-27 05:00:42","0","naemniki");
INSERT INTO m_fight VALUES("11","3","347","1","2015-10-27 05:21:15","2015-10-27 05:21:11","0","naemniki");
INSERT INTO m_fight VALUES("12","3","45","1","2015-10-27 06:39:17","2015-10-27 06:39:07","0","svoboda");
INSERT INTO m_fight VALUES("13","3","47","1","2015-10-27 07:02:24","2015-10-27 07:01:57","0","svoboda");
INSERT INTO m_fight VALUES("14","3","48","1","2015-10-27 07:18:16","2015-10-27 07:15:58","0","svoboda");
INSERT INTO m_fight VALUES("15","3","46","1","2015-10-27 07:18:02","2015-10-27 07:17:43","0","svoboda");
INSERT INTO m_fight VALUES("16","3","34","1","2015-10-27 07:25:33","2015-10-27 07:25:15","0","svoboda");
INSERT INTO m_fight VALUES("17","3","500","1","2015-10-27 07:25:55","2015-10-27 07:25:53","0","svoboda");
INSERT INTO m_fight VALUES("18","3","500","1","2015-10-27 07:31:51","2015-10-27 07:31:49","0","svoboda");
INSERT INTO m_fight VALUES("19","3","354","1","2015-10-27 07:35:23","2015-10-27 07:35:19","0","svoboda");
INSERT INTO m_fight VALUES("20","3","500","1","2015-10-27 07:38:28","2015-10-27 07:38:26","0","svoboda");
INSERT INTO m_fight VALUES("21","5","2319","1","2015-10-27 07:43:27","2015-10-27 07:43:10","0","svoboda");
INSERT INTO m_fight VALUES("22","3","344","1","2015-10-27 07:48:43","2015-10-27 07:48:39","0","svoboda");
INSERT INTO m_fight VALUES("23","3","500","1","2015-10-27 07:55:32","2015-10-27 07:55:30","0","svoboda");
INSERT INTO m_fight VALUES("24","3","47","1","2015-10-27 07:56:20","2015-10-27 07:55:57","0","svoboda");
INSERT INTO m_fight VALUES("25","3","500","1","2015-10-27 08:01:39","2015-10-27 08:01:39","0","svoboda");
INSERT INTO m_fight VALUES("26","3","52","1","2015-10-27 08:58:26","2015-10-27 08:58:09","0","svoboda");
INSERT INTO m_fight VALUES("27","3","55","1","2015-10-27 09:18:32","2015-10-27 09:18:10","0","svoboda");
INSERT INTO m_fight VALUES("28","3","500","1","2015-10-27 09:47:39","2015-10-27 09:47:39","0","svoboda");
INSERT INTO m_fight VALUES("29","3","42","1","2015-10-27 12:20:44","2015-10-27 12:20:28","0","svoboda");
INSERT INTO m_fight VALUES("30","3","41","1","2015-10-27 13:04:11","2015-10-27 13:03:51","0","svoboda");
INSERT INTO m_fight VALUES("31","3","500","1","2015-10-27 13:05:30","2015-10-27 13:05:30","0","naemniki");
INSERT INTO m_fight VALUES("32","3","51","1","2015-10-27 13:18:34","2015-10-27 13:18:14","0","svoboda");
INSERT INTO m_fight VALUES("33","3","202","1","2015-10-27 13:25:09","2015-10-27 13:25:06","0","svoboda");
INSERT INTO m_fight VALUES("34","3","200","1","2015-10-27 13:34:15","2015-10-27 13:34:11","0","svoboda");
INSERT INTO m_fight VALUES("35","3","206","1","2015-10-27 17:29:19","2015-10-27 17:29:16","0","svoboda");
INSERT INTO m_fight VALUES("36","3","51","1","2015-10-27 18:07:10","2015-10-27 18:06:53","0","dolg");
INSERT INTO m_fight VALUES("37","3","500","1","2015-10-27 18:27:23","2015-10-27 18:27:23","0","naemniki");
INSERT INTO m_fight VALUES("38","3","233","1","2015-10-27 18:38:03","2015-10-27 18:38:01","0","dolg");
INSERT INTO m_fight VALUES("39","3","191","1","2015-10-27 22:10:42","2015-10-27 22:10:36","0","svoboda");
INSERT INTO m_fight VALUES("40","5","1895","1","2015-10-27 22:23:03","2015-10-27 22:22:44","0","svoboda");
INSERT INTO m_fight VALUES("41","5","336","1","2015-10-28 00:07:00","2015-10-28 00:04:57","0","svoboda");
INSERT INTO m_fight VALUES("42","5","135","1","2015-10-28 00:20:11","2015-10-28 00:18:05","0","svoboda");
INSERT INTO m_fight VALUES("43","3","500","1","2015-10-28 00:23:48","2015-10-28 00:23:48","0","svoboda");
INSERT INTO m_fight VALUES("44","3","352","1","2015-10-28 02:52:18","2015-10-28 02:52:15","0","naemniki");
INSERT INTO m_fight VALUES("45","3","500","1","2015-10-28 03:46:58","2015-10-28 03:46:58","0","naemniki");
INSERT INTO m_fight VALUES("46","3","500","1","2015-10-28 04:59:14","2015-10-28 04:59:14","0","naemniki");
INSERT INTO m_fight VALUES("47","3","500","1","2015-10-28 05:42:15","2015-10-28 05:42:15","0","naemniki");
INSERT INTO m_fight VALUES("48","3","203","1","2015-10-28 05:55:43","2015-10-28 05:55:40","0","naemniki");
INSERT INTO m_fight VALUES("49","5","54","1","2015-10-28 05:58:51","2015-10-28 05:55:54","0","naemniki");
INSERT INTO m_fight VALUES("50","3","208","1","2015-10-28 08:18:18","2015-10-28 08:18:13","0","naemniki");
INSERT INTO m_fight VALUES("51","5","70","1","2015-10-28 08:24:41","2015-10-28 08:18:35","0","naemniki");
INSERT INTO m_fight VALUES("52","5","60","1","2015-10-28 12:58:15","2015-10-28 12:54:59","0","naemniki");
INSERT INTO m_fight VALUES("53","3","203","1","2015-10-28 12:58:31","2015-10-28 12:58:28","0","naemniki");
INSERT INTO m_fight VALUES("54","5","12","1","2015-10-28 13:36:07","2015-10-28 13:34:21","0","svoboda");
INSERT INTO m_fight VALUES("55","3","500","1","2015-10-28 13:37:36","2015-10-28 13:37:36","0","svoboda");
INSERT INTO m_fight VALUES("56","5","63","1","2015-10-28 13:43:05","2015-10-28 13:41:23","0","svoboda");
INSERT INTO m_fight VALUES("57","3","500","1","2015-10-28 13:46:38","2015-10-28 13:46:38","0","svoboda");
INSERT INTO m_fight VALUES("58","5","55","1","2015-10-28 13:50:33","2015-10-28 13:48:33","0","svoboda");
INSERT INTO m_fight VALUES("59","3","500","1","2015-10-28 13:53:56","2015-10-28 13:53:56","0","svoboda");
INSERT INTO m_fight VALUES("60","5","30","1","2015-10-28 13:58:02","2015-10-28 13:56:08","0","svoboda");
INSERT INTO m_fight VALUES("61","3","500","1","2015-10-28 14:04:49","2015-10-28 14:04:49","0","svoboda");
INSERT INTO m_fight VALUES("62","5","18","1","2015-10-28 14:07:01","2015-10-28 14:04:58","0","svoboda");
INSERT INTO m_fight VALUES("63","3","349","1","2015-10-28 14:45:44","2015-10-28 14:45:42","0","naemniki");
INSERT INTO m_fight VALUES("64","5","17","1","2015-10-28 15:06:47","2015-10-28 15:04:41","0","svoboda");
INSERT INTO m_fight VALUES("65","3","500","1","2015-10-28 15:07:02","2015-10-28 15:07:02","0","svoboda");



DROP TABLE IF EXISTS `m_inf`;

CREATE TABLE `m_inf` (
  `about_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `monster_id` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `thing_id` int(11) DEFAULT NULL,
  `id_fight` bigint(20) NOT NULL DEFAULT '0',
  `thing_id2` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`about_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO m_inf VALUES("1","1","3","847","1711","10","0");
INSERT INTO m_inf VALUES("2","2","3","587","693","53","0");
INSERT INTO m_inf VALUES("3","3","3","710","1025","23","0");
INSERT INTO m_inf VALUES("4","4","3","579","1019","28","0");
INSERT INTO m_inf VALUES("5","3","5","181","0","21","0");
INSERT INTO m_inf VALUES("6","5","3","600","1108","24","0");
INSERT INTO m_inf VALUES("7","6","3","602","1892","26","0");
INSERT INTO m_inf VALUES("8","7","3","1811","1820","65","0");
INSERT INTO m_inf VALUES("9","8","3","526","1496","38","0");
INSERT INTO m_inf VALUES("10","7","5","2556","37","64","0");
INSERT INTO m_inf VALUES("11","2","5","2639","30","52","0");
INSERT INTO m_inf VALUES("12","11","3","832","1382","63","0");



DROP TABLE IF EXISTS `m_time`;

CREATE TABLE `m_time` (
  `id_monster_time` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `id_monster` int(11) NOT NULL,
  `time_respawn` datetime DEFAULT NULL,
  PRIMARY KEY (`id_monster_time`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO m_time VALUES("1","1","3","2015-10-27 05:00:45");
INSERT INTO m_time VALUES("2","2","3","2015-10-28 12:58:38");
INSERT INTO m_time VALUES("3","3","3","2015-10-27 07:55:35");
INSERT INTO m_time VALUES("4","4","3","2015-10-27 09:47:42");
INSERT INTO m_time VALUES("5","5","3","2015-10-27 07:56:33");
INSERT INTO m_time VALUES("6","6","3","2015-10-27 08:58:32");
INSERT INTO m_time VALUES("7","7","3","2015-10-28 15:07:04");
INSERT INTO m_time VALUES("8","8","3","2015-10-27 18:38:11");
INSERT INTO m_time VALUES("9","7","5","2015-10-28 15:06:53");
INSERT INTO m_time VALUES("10","2","5","2015-10-28 12:58:20");
INSERT INTO m_time VALUES("11","11","3","2015-10-28 14:45:47");



DROP TABLE IF EXISTS `medicaments`;

CREATE TABLE `medicaments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `namest` varchar(255) NOT NULL,
  `opis` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `cena` int(11) NOT NULL,
  `massa` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO medicaments VALUES("1","Бинт","bint","Перевязочный материал. Помогает остановить кровотечение и излечить несерьезные раны","bint.png","200","0.1");
INSERT INTO medicaments VALUES("2","Антирад","antirad","Набор таблеток с активными веществами, способствующими выведению радионуклидов из организма. Не способны защитить организм от наведённой радиации, но снижают уже полученную человеком дозу. Время действия <b>2 часа</b>","antirad.png","300","0.2");
INSERT INTO medicaments VALUES("3","Аптечка","aptechki","Универсальный медицинский набор. Позволяет справляться с травмами различного вида и степени сложности","aptechka.png","1000","0.3");
INSERT INTO medicaments VALUES("4","Армейская аптечка","arm_aptechki","Специализированный медицинский набор для борьбы с повреждениями кожных покровов и тканей, а также кровотечением. В него входят средства для ускорения свертывания крови, обезболивающие, антибиотики и стимуляторы иммунитета.\n","arm_aptechka.png","1200","0.4");
INSERT INTO medicaments VALUES("5","Научная аптечка","nayk_aptechki","Медицинский набор, разработанный специально для работы в условиях Зоны. Состав набора подобран как для борьбы с ранениями, так и для вывода радионуклидов из организма. Препятствует развитию лучевой болезни а также снижает дозу накопленной радиации.\n\n","nayk_aptechka.png","1500","0.5");



DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `message_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ot` int(11) NOT NULL,
  `dlya` int(11) NOT NULL,
  `text` varchar(1024) DEFAULT NULL,
  `thing` bigint(20) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `reading` int(11) NOT NULL DEFAULT '0',
  `delite_ot` int(11) DEFAULT '0',
  `delite_dlya` int(11) DEFAULT '0',
  PRIMARY KEY (`message_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `messages`;

CREATE TABLE `messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` varchar(244) NOT NULL,
  `komy` varchar(244) NOT NULL,
  `text` text NOT NULL,
  `time` varchar(244) NOT NULL,
  `readlen` varchar(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

INSERT INTO messages VALUES("1","8","1","Зроби адм","1445954071","1");
INSERT INTO messages VALUES("2","7","1","Короче руки зомби продаются,серебро не капает за них.","1445977346","1");
INSERT INTO messages VALUES("3","7","1","На 83к продал,серебро е прибавилось","1445977389","1");
INSERT INTO messages VALUES("4","1","7","не прибавилось?","1445988997","1");
INSERT INTO messages VALUES("5","7","1","Нет","1446012156","1");
INSERT INTO messages VALUES("6","7","1","Ещё продал 12рукна 35к,тоже глухо","1446025584","1");
INSERT INTO messages VALUES("7","7","1","Где взять реликвию?","1446026092","1");
INSERT INTO messages VALUES("8","1","7","проверю сейчас","1446027433","1");
INSERT INTO messages VALUES("9","11","1","ответь вк","1446028855","0");



DROP TABLE IF EXISTS `messages_c`;

CREATE TABLE `messages_c` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` varchar(244) NOT NULL,
  `kogo` varchar(244) NOT NULL,
  `time` varchar(244) NOT NULL,
  `ignor` varchar(1) NOT NULL,
  `posl_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO messages_c VALUES("1","8","1","1445954071","n","1445954071");
INSERT INTO messages_c VALUES("2","1","8","1445954071","n","1445954071");
INSERT INTO messages_c VALUES("3","7","1","1445977346","n","1446027433");
INSERT INTO messages_c VALUES("4","1","7","1445977346","n","1446027433");
INSERT INTO messages_c VALUES("5","11","1","1446028855","n","1446028855");
INSERT INTO messages_c VALUES("6","1","11","1446028855","n","1446028855");



DROP TABLE IF EXISTS `monsters`;

CREATE TABLE `monsters` (
  `name` varchar(16) NOT NULL,
  `screen` varchar(16) NOT NULL,
  `clan` int(11) NOT NULL,
  `max_people` int(11) NOT NULL,
  `max_hp` int(11) NOT NULL,
  `bronya` int(11) NOT NULL,
  `yron` int(11) NOT NULL,
  `speed` int(11) NOT NULL,
  `bonus_type` int(11) NOT NULL,
  `bonus` int(11) NOT NULL,
  `id_monster` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(16) DEFAULT NULL,
  `time_angry` int(11) DEFAULT '0',
  `location_name` varchar(32) DEFAULT NULL,
  `respawn_time` int(11) NOT NULL,
  `max_aptechki` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_monster`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO monsters VALUES("Псевдогигант","8.png","1","10","100000","25000","9000000","2","2","2","7","monster7","0","Псевдогигант","1300","10");
INSERT INTO monsters VALUES(" 	\nПси собака","9.png","0","1","40000","25000","1500000","2","3","2","8","monster8","0","Восточный тоннель ","1300","7");
INSERT INTO monsters VALUES("Контролер","7.png","1","5","30000","6500","8150000","2","2","2","4","monster4","0","Гастроном","900","6");
INSERT INTO monsters VALUES("Химера","11.png","0","2","50000","5500","4650000","2","2","2","6","monster6","0","Болотная тварь","1000","10");
INSERT INTO monsters VALUES("Плоть","5.png","0","1","2500","2000","240000","3","1","1","5","monster5","0","Заправка","300","7");
INSERT INTO monsters VALUES("Слепой пес","3.png","0","1","500","500","22000","4","3","1","3","monster3","0","Лестничество","300","3");
INSERT INTO monsters VALUES("Болотная тварь","6.png","1","3","40000","1700","1040000","2","2","1","2","monster2","0","Вентиляционный комплекс","500","7");
INSERT INTO monsters VALUES("Снорк","4.png","0","2","15000","4500","400000","2","1","1","1","monster1","0","Логово снорков","300","5");
INSERT INTO monsters VALUES("Кровосос","1.png","0","1","25000","8500","850000","3","1","1","9","monster9","0","Болото","300","10");
INSERT INTO monsters VALUES("Бес","11.png","0","1","55000","40000","10000000","1","2","2","10","monster10","0","Оазис","500","10");



DROP TABLE IF EXISTS `my_detector`;

CREATE TABLE `my_detector` (
  `det_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `screen` varchar(50) DEFAULT NULL,
  `lvl_need` int(11) NOT NULL,
  `sh_nahod` int(11) NOT NULL,
  `anom` int(11) NOT NULL,
  `sh_dost` int(11) NOT NULL,
  `progress` int(11) NOT NULL,
  `place` int(11) NOT NULL,
  PRIMARY KEY (`det_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `text` varchar(1024) NOT NULL,
  `user` varchar(50) NOT NULL,
  `time` int(11) NOT NULL,
  `id_admin` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO news VALUES("1","Beta Test","Итак сегодня у нас открытый Beta Test!!!\r\nВсе найденные ошибки писать на форуме под этой новостью","Nemisis","1445902273","1");



DROP TABLE IF EXISTS `opit`;

CREATE TABLE `opit` (
  `opit_id` int(11) NOT NULL AUTO_INCREMENT,
  `lvl` int(15) NOT NULL,
  `opit` int(255) NOT NULL,
  PRIMARY KEY (`opit_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2147483648 DEFAULT CHARSET=utf8;

INSERT INTO opit VALUES("1","2","10");
INSERT INTO opit VALUES("2","3","25");
INSERT INTO opit VALUES("3","4","60");
INSERT INTO opit VALUES("4","5","80");
INSERT INTO opit VALUES("5","6","150");
INSERT INTO opit VALUES("6","7","260");
INSERT INTO opit VALUES("7","8","330");
INSERT INTO opit VALUES("8","9","456");
INSERT INTO opit VALUES("9","10","573");
INSERT INTO opit VALUES("10","11","834");
INSERT INTO opit VALUES("11","12","1527");
INSERT INTO opit VALUES("12","13","3930");
INSERT INTO opit VALUES("13","14","6659");
INSERT INTO opit VALUES("14","15","9448");
INSERT INTO opit VALUES("15","16","13112");
INSERT INTO opit VALUES("16","17","16556");
INSERT INTO opit VALUES("17","18","20779");
INSERT INTO opit VALUES("18","19","27491");
INSERT INTO opit VALUES("19","20","36687");
INSERT INTO opit VALUES("20","21","54763");
INSERT INTO opit VALUES("21","22","83668");
INSERT INTO opit VALUES("22","23","137135");
INSERT INTO opit VALUES("23","24","163989");
INSERT INTO opit VALUES("24","25","259585");
INSERT INTO opit VALUES("25","26","361419");
INSERT INTO opit VALUES("26","27","549987");
INSERT INTO opit VALUES("27","28","929983");
INSERT INTO opit VALUES("28","29","1781976");
INSERT INTO opit VALUES("29","30","2834766");
INSERT INTO opit VALUES("30","31","5728673");
INSERT INTO opit VALUES("31","32","38420143");
INSERT INTO opit VALUES("32","33","92388200");
INSERT INTO opit VALUES("33","34","155743480");
INSERT INTO opit VALUES("34","35","307898990");
INSERT INTO opit VALUES("35","36","635050000");
INSERT INTO opit VALUES("36","37","1020500000");
INSERT INTO opit VALUES("37","38","1350000000");
INSERT INTO opit VALUES("38","39","1750500000");
INSERT INTO opit VALUES("39","40","2147483647");



DROP TABLE IF EXISTS `payments_rub`;

CREATE TABLE `payments_rub` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID платежа (Внутренний ID)',
  `id_user` int(11) unsigned NOT NULL COMMENT 'ID пользователя',
  `id_bill` int(11) unsigned NOT NULL COMMENT 'ID платежа в Worldkassa',
  `time` int(11) unsigned NOT NULL COMMENT 'Время инициализации платежа',
  `time_oplata` int(11) unsigned DEFAULT '0' COMMENT 'Время оплаты',
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT 'Сумма',
  `rub` int(18) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Статистика платежей через WorldKassa';




DROP TABLE IF EXISTS `pistols`;

CREATE TABLE `pistols` (
  `pistols_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `max_stats_yron` int(11) NOT NULL,
  `min_stats_yron` int(11) NOT NULL,
  `max_stats_tochn` int(11) NOT NULL,
  `min_stats_tochn` int(11) NOT NULL,
  `min_stats_safety` int(11) NOT NULL DEFAULT '0',
  `max_stats_safety` int(11) NOT NULL DEFAULT '0',
  `speed` int(11) NOT NULL,
  `screen` varchar(20) NOT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL DEFAULT '0',
  `klass` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`pistols_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO pistols VALUES("1","Короткий меч","399","200","399","200","72","75","6","a3.gif","20","-1","1","1");
INSERT INTO pistols VALUES("2","Сабля","499","300","499","300","75","78","6","a4.gif","200","2000","6","2");
INSERT INTO pistols VALUES("3","Обжигающая зло","799","600","799","600","78","81","6","b3.gif","700","15000","15","3");
INSERT INTO pistols VALUES("4","Воинский меч","999","800","999","800","81","84","6","b2.gif","1200","45000","17","3");
INSERT INTO pistols VALUES("5","Охотник монстров","1199","1000","1199","1000","84","87","6","b4.gif","1500","100000","20","3");
INSERT INTO pistols VALUES("6","Вестник Рока","1399","1200","1399","1200","87","90","5","12.gif","1700","-1","21","4");
INSERT INTO pistols VALUES("7","Cабля Зумакалиса","1599","1400","1599","1400","90","93","5","b1.gif","2000","-1","22","4");
INSERT INTO pistols VALUES("8","Громовержец","1799","1600","1799","1600","93","96","5","15.gif","8000","-1","23","4");
INSERT INTO pistols VALUES("9","Дар Силарии","2999","2300","2999","2300","96","99","5","b5.gif","15100","-1","25","4");
INSERT INTO pistols VALUES("10","Ледяное сердце","3999","3700","3999","3700","96","99","5","b6.gif","21800","-1","30","4");
INSERT INTO pistols VALUES("11","Экзариан","4777","4300","4977","4350","96","100","5","b7.gif","28650","-1","35","4");
INSERT INTO pistols VALUES("13","Палаш","599","400","599","400","75","78","6","a5.gif","400","3000","12","2");
INSERT INTO pistols VALUES("14","Громовая Ярость","5777","5300","5977","5350","96","100","5","19.gif","100650","-1","37","4");
INSERT INTO pistols VALUES("15","Рассекатель душ","10777","9300","10977","9350","100","100","1","Gauss-pistol.png","250650","-1","40","4");



DROP TABLE IF EXISTS `ref`;

CREATE TABLE `ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_us` int(11) DEFAULT NULL,
  `nak` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `regeneration`;

CREATE TABLE `regeneration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO regeneration VALUES("1","1","1446027965");
INSERT INTO regeneration VALUES("2","19","1446022802");
INSERT INTO regeneration VALUES("3","2","1446008182");
INSERT INTO regeneration VALUES("4","3","1445944263");
INSERT INTO regeneration VALUES("5","4","1445918931");
INSERT INTO regeneration VALUES("6","5","1445923990");
INSERT INTO regeneration VALUES("7","6","1446030478");
INSERT INTO regeneration VALUES("8","7","1446007760");
INSERT INTO regeneration VALUES("9","8","1445961285");
INSERT INTO regeneration VALUES("10","9","1445971544");
INSERT INTO regeneration VALUES("11","10","1446029303");
INSERT INTO regeneration VALUES("12","11","1446028559");
INSERT INTO regeneration VALUES("13","0","1446029489");



DROP TABLE IF EXISTS `schat`;

CREATE TABLE `schat` (
  `id` int(18) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `time` varchar(19) NOT NULL,
  `komy` int(18) NOT NULL,
  `adm` int(1) DEFAULT '0',
  `vip` int(1) DEFAULT '0',
  `usid` int(18) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO schat VALUES("1","0J/QsNGA0LDQvCDQv9Cw0Lwg0L/QsNC8","1445906264","0","0","0","2");
INSERT INTO schat VALUES("2","0J3QtdC70YzQt9GPINC90LDQv9Cw0LTQsNGC0Ywg0L3QsCDQsNC00LzQuNC90LjRgdGC0YDQsNGC0L7RgNC+0LJcIiDQv9C+0YfQtdC80YM/Pz8g0JAg0YLQsNC6INGF0L7RgtC10LvQvtGB0Ywg0LPQsw==","1445909090","0","0","0","2");
INSERT INTO schat VALUES("5","0JrRgw==","1445917684","0","0","0","4");



DROP TABLE IF EXISTS `sgchat`;

CREATE TABLE `sgchat` (
  `id` int(18) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `time` int(18) NOT NULL,
  `komy` int(18) NOT NULL,
  `adm` int(1) DEFAULT '0',
  `rang` int(1) NOT NULL,
  `usid` int(18) NOT NULL,
  `clan` int(18) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `shlem`;

CREATE TABLE `shlem` (
  `shlem_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `max_stats_bronya` int(11) NOT NULL,
  `min_stats_bronya` int(11) NOT NULL,
  `max_stats_hp` int(11) NOT NULL,
  `min_stats_hp` int(11) NOT NULL,
  `max_stats_rad` int(11) NOT NULL DEFAULT '10',
  `min_stats_rad` int(11) NOT NULL DEFAULT '10',
  `screen` varchar(20) NOT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL DEFAULT '0',
  `klass` int(11) NOT NULL DEFAULT '1',
  `max_stats_razriv` int(11) NOT NULL DEFAULT '0',
  `min_stats_razriv` int(11) NOT NULL DEFAULT '0',
  `massa` int(11) NOT NULL,
  PRIMARY KEY (`shlem_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sklad_log`;

CREATE TABLE `sklad_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `valuta` varchar(500) DEFAULT NULL,
  `tip` int(11) NOT NULL,
  `clan_id` int(11) NOT NULL,
  `summa` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO sklad_log VALUES("1","1445907503","1","1","1","1","15000");



DROP TABLE IF EXISTS `smile`;

CREATE TABLE `smile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icon` varchar(1024) NOT NULL,
  `name` varchar(250) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8;

INSERT INTO smile VALUES("1","ban.gif",":бан");
INSERT INTO smile VALUES("2","blagodarju.gif",":спс");
INSERT INTO smile VALUES("3","uh.gif",":фух");
INSERT INTO smile VALUES("4","vyzov.gif",":вызов");
INSERT INTO smile VALUES("5","bu.gif",":бек");
INSERT INTO smile VALUES("6","rydaet.gif",":плак");
INSERT INTO smile VALUES("7","fingal.gif",":фингал");
INSERT INTO smile VALUES("8","cool.gif",":кул");
INSERT INTO smile VALUES("10","alkawi.gif",":алкаши");
INSERT INTO smile VALUES("11","bravo.gif",":браво");
INSERT INTO smile VALUES("12","ai.gif",":8");
INSERT INTO smile VALUES("13","ura.gif",":ура");
INSERT INTO smile VALUES("14","smile141.gif",":*");
INSERT INTO smile VALUES("15","smile10.gif",":[");
INSERT INTO smile VALUES("16","smile275.gif",":вдв");
INSERT INTO smile VALUES("17","smile254.gif",":друг");
INSERT INTO smile VALUES("18","smile299.gif","o:)");
INSERT INTO smile VALUES("19","smile149.gif",":нет");
INSERT INTO smile VALUES("20","smile214.gif",":хз");
INSERT INTO smile VALUES("21","happy.gif",":)");
INSERT INTO smile VALUES("22","xaxa.gif",":-)");
INSERT INTO smile VALUES("23","nyam.gif",":ням");
INSERT INTO smile VALUES("24","smutil.gif",":$");
INSERT INTO smile VALUES("26","hi.gif",";)");
INSERT INTO smile VALUES("27","give_rose.gif","-@");
INSERT INTO smile VALUES("53","241-spaces.ru.gif",":вали");
INSERT INTO smile VALUES("42","520500.gif",":полтергейст");
INSERT INTO smile VALUES("43","ban2.gif",":бан2");
INSERT INTO smile VALUES("44","drink.gif",":братва");
INSERT INTO smile VALUES("45","image.jpg",":желание");
INSERT INTO smile VALUES("46","smile_artefact.gif",":арт");
INSERT INTO smile VALUES("47","smile_control.gif",":контролер");
INSERT INTO smile VALUES("48","smile_pseudogigant1.gif",":псевдогиг");
INSERT INTO smile VALUES("49","smile_snork.gif",":снорк");
INSERT INTO smile VALUES("50","wall.gif",":стена");
INSERT INTO smile VALUES("51","yahoo.gif",":смайл");
INSERT INTO smile VALUES("54","anomaliya.gif",":аномалия");
INSERT INTO smile VALUES("55","fan.gif",":фан");
INSERT INTO smile VALUES("56","run.gif",":бегу");
INSERT INTO smile VALUES("57","smile_gitara.gif",":гитара");
INSERT INTO smile VALUES("64","smiley93.gif",":вперёд");
INSERT INTO smile VALUES("63","smiley87.gif",":конь");
INSERT INTO smile VALUES("61",".gif",":пифпаф");
INSERT INTO smile VALUES("62","smiley78.gif",": ааа");
INSERT INTO smile VALUES("65","smiley35.gif",":тютю");
INSERT INTO smile VALUES("66","smiley54.gif",":ок");
INSERT INTO smile VALUES("67","smiley32.gif",":цём");
INSERT INTO smile VALUES("68","smiley99.gif",":язык");
INSERT INTO smile VALUES("69","smiley30.gif",":крут");
INSERT INTO smile VALUES("70","vau.gif",":ого");
INSERT INTO smile VALUES("71","fuck.gif",":фак");
INSERT INTO smile VALUES("72","facepalm.gif",":фэйспалм");
INSERT INTO smile VALUES("73","xaxa.gif",":хаха");
INSERT INTO smile VALUES("74","bb.gif",":качёк");
INSERT INTO smile VALUES("75","drink.gif",":братаны");
INSERT INTO smile VALUES("76","hello.gif",":бб");
INSERT INTO smile VALUES("77","pizdec.gif",":накрыло");
INSERT INTO smile VALUES("78","klass.gif",":супер");
INSERT INTO smile VALUES("79","tiho.gif",":тихо");
INSERT INTO smile VALUES("80","zlo.gif",":зло");
INSERT INTO smile VALUES("81","zhopa.gif",":жопа");
INSERT INTO smile VALUES("82","yahoo.gif",":норм");
INSERT INTO smile VALUES("83","xmm.gif",":бесишь");
INSERT INTO smile VALUES("84","wall.gif",":ууу");
INSERT INTO smile VALUES("85","mail.gif",":письмо");
INSERT INTO smile VALUES("86","smile_pseudogigant.gif",":псевдогигант");
INSERT INTO smile VALUES("87","nono.gif",":не");
INSERT INTO smile VALUES("88","poisk.gif",":ищу");
INSERT INTO smile VALUES("89","mail3.gif",":пишу");
INSERT INTO smile VALUES("90","oops.gif",":упс");
INSERT INTO smile VALUES("91","smert.gif",":смерть");
INSERT INTO smile VALUES("92","D.gif",":D");



DROP TABLE IF EXISTS `subforums`;

CREATE TABLE `subforums` (
  `id_subf` bigint(20) NOT NULL AUTO_INCREMENT,
  `name_subf` varchar(32) DEFAULT NULL,
  `clan` bigint(20) DEFAULT NULL,
  `rangs_read` int(11) DEFAULT NULL,
  `rangs_com` int(11) DEFAULT NULL,
  `rangs_cre` int(11) DEFAULT NULL,
  `main` int(11) DEFAULT '0',
  `gruppa` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id_subf`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=utf8;

INSERT INTO subforums VALUES("1","Новости","1","0","0","0","1","all");
INSERT INTO subforums VALUES("2","Общение","1","0","0","0","1","all");
INSERT INTO subforums VALUES("3","Торговля","1","0","0","0","1","all");
INSERT INTO subforums VALUES("7","Ошибки игры","1","0","0","0","1","all");
INSERT INTO subforums VALUES("8","Развлечения","1","0","0","0","1","all");
INSERT INTO subforums VALUES("9","Предложения","1","0","0","0","1","all");
INSERT INTO subforums VALUES("10","Игрокам","1","0","0","0","0","dolg");
INSERT INTO subforums VALUES("24","Отзывы","3","0","0","0","0","dolg");
INSERT INTO subforums VALUES("17","Общение","2","1","1","1","0","naemniki");
INSERT INTO subforums VALUES("22","Предложения","3","0","0","0","0","dolg");



DROP TABLE IF EXISTS `tchat`;

CREATE TABLE `tchat` (
  `id` int(18) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `time` varchar(19) NOT NULL,
  `komy` int(18) NOT NULL,
  `adm` int(1) DEFAULT '0',
  `usid` int(18) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `things`;

CREATE TABLE `things` (
  `thing_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` int(11) NOT NULL,
  `inf_id` int(11) NOT NULL,
  `stat1` int(11) NOT NULL,
  `upgrade_stat1` int(11) NOT NULL DEFAULT '0',
  `stat2` int(11) NOT NULL,
  `upgrade_stat2` int(11) NOT NULL DEFAULT '0',
  `stat3` int(11) NOT NULL DEFAULT '0',
  `upgrade_stat3` int(11) NOT NULL DEFAULT '0',
  `speed` int(11) DEFAULT NULL,
  `upgrade_speed` int(11) NOT NULL DEFAULT '0',
  `sost` int(11) NOT NULL,
  `privat` int(11) NOT NULL,
  `place` int(11) NOT NULL,
  `need_lvl` int(11) NOT NULL,
  `massa` varchar(11) NOT NULL DEFAULT '2.00',
  PRIMARY KEY (`thing_id`)
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

INSERT INTO things VALUES("1","1","2","1","387","0","328","0","72","0","6","0","0","1","2","1","2.00");
INSERT INTO things VALUES("2","1","3","24","730","0","850","0","79","0","25","0","8","1","2","2","2.00");
INSERT INTO things VALUES("3","1","1","23","778","0","653","0","567","0","4","0","8","1","2","2","2.00");
INSERT INTO things VALUES("28","2","1","3","3826","0","1880","0","1892","0","26","0","1","1","3","15","2.00");
INSERT INTO things VALUES("5","2","3","24","834","1","770","0","82","0","25","1","8","1","2","2","2.00");
INSERT INTO things VALUES("6","1","3","2","1952","0","1980","0","69","0","37","0","8","0","0","14","2.00");
INSERT INTO things VALUES("7","1","2","13","490","0","516","0","78","0","6","0","8","0","0","12","2.00");
INSERT INTO things VALUES("12","3","3","24","763","0","727","0","81","0","25","0","7","1","2","2","2.00");
INSERT INTO things VALUES("14","4","3","24","746","0","621","0","81","0","25","0","7","1","2","2","2.00");
INSERT INTO things VALUES("11","3","1","24","327","0","104","0","308","0","2","0","7","1","2","2","2.00");
INSERT INTO things VALUES("15","4","1","24","407","0","141","0","359","0","1","0","8","0","1","2","2.00");
INSERT INTO things VALUES("16","4","2","2","355","0","355","0","78","0","6","0","8","0","0","6","2.00");
INSERT INTO things VALUES("18","7","2","2","318","1","453","0","76","0","6","0","7","1","2","6","2.00");
INSERT INTO things VALUES("17","6","1","15","671","0","773","0","780","0","7","0","8","1","2","3","2.00");
INSERT INTO things VALUES("19","8","2","2","490","0","343","0","76","0","6","0","8","1","2","6","2.00");
INSERT INTO things VALUES("20","8","1","15","681","0","756","0","733","0","13","0","8","1","2","3","2.00");
INSERT INTO things VALUES("21","7","3","14","1092","0","855","0","63","0","39","0","8","1","0","8","2.00");
INSERT INTO things VALUES("22","7","3","15","1222","0","1369","0","64","0","38","0","7","1","2","11","2.00");
INSERT INTO things VALUES("23","7","1","17","2863","0","2227","0","1708","0","20","0","8","1","2","9","2.00");
INSERT INTO things VALUES("24","7","1","3","3649","0","1687","0","1529","0","30","0","8","1","0","15","2.00");
INSERT INTO things VALUES("25","7","1","1","418","0","231","0","114","0","1","0","1","1","0","1","2.00");
INSERT INTO things VALUES("26","2","1","17","2795","1","2098","1","1853","1","12","1","8","1","2","9","2.00");
INSERT INTO things VALUES("27","2","2","2","426","1","353","1","75","1","6","2","8","1","2","6","2.00");
INSERT INTO things VALUES("29","2","3","14","898","0","1040","0","61","0","39","0","1","1","1","8","2.00");
INSERT INTO things VALUES("30","2","1","4","4309","0","2999","0","2405","0","33","0","1","1","1","16","2.00");
INSERT INTO things VALUES("35","7","2","2","464","0","312","0","78","0","6","0","1","1","0","6","2.00");
INSERT INTO things VALUES("32","7","2","3","603","0","648","0","79","0","6","0","8","1","0","15","2.00");
INSERT INTO things VALUES("33","7","1","3","3598","0","1612","0","1552","0","30","0","8","1","0","15","2.00");
INSERT INTO things VALUES("34","7","1","3","3927","0","1995","0","1917","0","25","0","1","1","0","15","2.00");
INSERT INTO things VALUES("36","11","3","13","734","0","702","0","61","0","42","0","8","1","2","1","2.00");
INSERT INTO things VALUES("37","7","2","2","337","0","315","0","76","0","6","0","1","1","0","6","2.00");



DROP TABLE IF EXISTS `topics`;

CREATE TABLE `topics` (
  `id_top` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_subf` bigint(20) NOT NULL,
  `avtor` bigint(20) NOT NULL,
  `fix` int(11) NOT NULL DEFAULT '0',
  `text` varchar(1024) DEFAULT NULL,
  `time_cre` datetime NOT NULL,
  `time_up` datetime NOT NULL,
  `name` varchar(32) NOT NULL,
  `close` int(11) NOT NULL DEFAULT '0',
  `prosmotr` int(11) NOT NULL DEFAULT '0',
  `adm_sm` int(11) NOT NULL,
  `news` varchar(255) NOT NULL,
  PRIMARY KEY (`id_top`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO topics VALUES("1","1","1","0","Итак сегодня у нас открытый Beta Test!!!\r\nВсе найденные ошибки писать на форуме под этой новостью","2015-10-27 03:31:13","2015-10-27 03:31:13","Beta Test","0","6","1","Beta Test");
INSERT INTO topics VALUES("2","7","2","0","Рука зомби: 23 шт. (28*23 = 66010)<br />Как то он не правильно умножается ) но серебра даёт верно 664 )","2015-10-27 18:00:06","2015-10-27 18:00:06","Владиан","0","1","0","");



DROP TABLE IF EXISTS `train`;

CREATE TABLE `train` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `cena` int(255) NOT NULL,
  `rub` int(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO train VALUES("1","100","100");



DROP TABLE IF EXISTS `upgrade_clothes`;

CREATE TABLE `upgrade_clothes` (
  `clothes_id` int(11) NOT NULL,
  `stat` varchar(16) DEFAULT NULL,
  `number_upgrade` int(11) NOT NULL,
  `name` varchar(32) DEFAULT NULL,
  `about` varchar(256) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO upgrade_clothes VALUES("1","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("1","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("1","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("1","hp","4","","");
INSERT INTO upgrade_clothes VALUES("1","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("1","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("1","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("1","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("1","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("1","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("1","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("1","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("1","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("1","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("1","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("1","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("2","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("2","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("2","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("2","hp","4","","");
INSERT INTO upgrade_clothes VALUES("2","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("2","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("2","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("2","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("2","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("2","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("2","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("2","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("2","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("2","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("2","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("2","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("3","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("3","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("3","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("3","hp","4","","");
INSERT INTO upgrade_clothes VALUES("3","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("3","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("3","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("3","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("3","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("3","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("3","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("3","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("3","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("3","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("3","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("3","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("4","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("4","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("4","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("4","hp","4","","");
INSERT INTO upgrade_clothes VALUES("4","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("4","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("4","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("4","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("4","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("4","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("4","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("4","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("4","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("4","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("4","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("4","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("5","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("5","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("5","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("5","hp","4","","");
INSERT INTO upgrade_clothes VALUES("5","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("5","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("5","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("5","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("5","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("5","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("5","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("5","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("5","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("5","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("5","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("5","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("6","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("6","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("6","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("6","hp","4","","");
INSERT INTO upgrade_clothes VALUES("6","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("6","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("6","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("6","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("6","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("6","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("6","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("6","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("6","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("6","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("6","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("6","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("7","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("7","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("7","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("7","hp","4","","");
INSERT INTO upgrade_clothes VALUES("7","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("7","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("7","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("7","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("7","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("7","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("7","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("7","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("7","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("7","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("7","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("7","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("8","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("8","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("8","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("8","hp","4","","");
INSERT INTO upgrade_clothes VALUES("8","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("8","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("8","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("8","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("8","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("8","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("8","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("8","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("8","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("8","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("8","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("8","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("9","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("9","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("9","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("9","hp","4","","");
INSERT INTO upgrade_clothes VALUES("9","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("9","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("9","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("9","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("9","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("9","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("9","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("9","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("9","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("9","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("9","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("9","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("10","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("10","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("10","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("10","hp","4","","");
INSERT INTO upgrade_clothes VALUES("10","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("10","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("10","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("10","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("10","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("10","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("10","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("10","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("10","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("10","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("10","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("10","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("11","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("11","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("11","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("11","hp","4","","");
INSERT INTO upgrade_clothes VALUES("11","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("11","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("11","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("11","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("11","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("11","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("11","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("11","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("11","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("11","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("11","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("11","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("12","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("12","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("12","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("12","hp","4","","");
INSERT INTO upgrade_clothes VALUES("12","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("12","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("12","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("12","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("12","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("12","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("12","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("12","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("12","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("12","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("12","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("12","radiation","4","","");
INSERT INTO upgrade_clothes VALUES("13","hp","1","","---");
INSERT INTO upgrade_clothes VALUES("13","hp","2","","---");
INSERT INTO upgrade_clothes VALUES("13","hp","3","","---");
INSERT INTO upgrade_clothes VALUES("13","hp","4","","");
INSERT INTO upgrade_clothes VALUES("13","bronya","1","","");
INSERT INTO upgrade_clothes VALUES("13","bronya","2","","");
INSERT INTO upgrade_clothes VALUES("13","bronya","3","","---");
INSERT INTO upgrade_clothes VALUES("13","bronya","4","","");
INSERT INTO upgrade_clothes VALUES("13","prochn","1","","");
INSERT INTO upgrade_clothes VALUES("13","prochn","2","","");
INSERT INTO upgrade_clothes VALUES("13","prochn","3","","");
INSERT INTO upgrade_clothes VALUES("13","prochn","4","","");
INSERT INTO upgrade_clothes VALUES("13","radiation","1","","");
INSERT INTO upgrade_clothes VALUES("13","radiation","2","","");
INSERT INTO upgrade_clothes VALUES("13","radiation","3","","");
INSERT INTO upgrade_clothes VALUES("13","radiation","4","","");



DROP TABLE IF EXISTS `upgrade_pistols`;

CREATE TABLE `upgrade_pistols` (
  `pistols_id` int(11) NOT NULL,
  `stat` varchar(16) DEFAULT NULL,
  `number_upgrade` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `about` varchar(256) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO upgrade_pistols VALUES("1","yron","1","","");
INSERT INTO upgrade_pistols VALUES("1","yron","2","","");
INSERT INTO upgrade_pistols VALUES("1","yron","3","","");
INSERT INTO upgrade_pistols VALUES("1","yron","4","","");
INSERT INTO upgrade_pistols VALUES("1","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("1","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("1","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("1","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("1","safety","1","","");
INSERT INTO upgrade_pistols VALUES("1","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("1","safety","3","","");
INSERT INTO upgrade_pistols VALUES("1","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("1","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("1","speed","2","","");
INSERT INTO upgrade_pistols VALUES("1","speed","3","","");
INSERT INTO upgrade_pistols VALUES("1","speed","4","","");
INSERT INTO upgrade_pistols VALUES("2","yron","1","","");
INSERT INTO upgrade_pistols VALUES("2","yron","2","","");
INSERT INTO upgrade_pistols VALUES("2","yron","3","","");
INSERT INTO upgrade_pistols VALUES("2","yron","4","","");
INSERT INTO upgrade_pistols VALUES("2","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("2","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("2","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("2","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("2","safety","1","","");
INSERT INTO upgrade_pistols VALUES("2","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("2","safety","3","","");
INSERT INTO upgrade_pistols VALUES("2","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("2","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("2","speed","2","","");
INSERT INTO upgrade_pistols VALUES("2","speed","3","","");
INSERT INTO upgrade_pistols VALUES("2","speed","4","","");
INSERT INTO upgrade_pistols VALUES("3","yron","1","","");
INSERT INTO upgrade_pistols VALUES("3","yron","2","","");
INSERT INTO upgrade_pistols VALUES("3","yron","3","","");
INSERT INTO upgrade_pistols VALUES("3","yron","4","","");
INSERT INTO upgrade_pistols VALUES("3","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("3","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("3","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("3","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("3","safety","1","","");
INSERT INTO upgrade_pistols VALUES("3","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("3","safety","3","","");
INSERT INTO upgrade_pistols VALUES("3","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("3","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("3","speed","2","","");
INSERT INTO upgrade_pistols VALUES("3","speed","3","","");
INSERT INTO upgrade_pistols VALUES("3","speed","4","","");
INSERT INTO upgrade_pistols VALUES("4","yron","1","","");
INSERT INTO upgrade_pistols VALUES("4","yron","2","","");
INSERT INTO upgrade_pistols VALUES("4","yron","3","","");
INSERT INTO upgrade_pistols VALUES("4","yron","4","","");
INSERT INTO upgrade_pistols VALUES("4","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("4","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("4","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("4","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("4","safety","1","","");
INSERT INTO upgrade_pistols VALUES("4","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("4","safety","3","","");
INSERT INTO upgrade_pistols VALUES("4","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("4","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("4","speed","2","","");
INSERT INTO upgrade_pistols VALUES("4","speed","3","","");
INSERT INTO upgrade_pistols VALUES("4","speed","4","","");
INSERT INTO upgrade_pistols VALUES("5","yron","1","","");
INSERT INTO upgrade_pistols VALUES("5","yron","2","","");
INSERT INTO upgrade_pistols VALUES("5","yron","3","","");
INSERT INTO upgrade_pistols VALUES("5","yron","4","","");
INSERT INTO upgrade_pistols VALUES("5","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("5","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("5","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("5","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("5","safety","1","","");
INSERT INTO upgrade_pistols VALUES("5","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("5","safety","3","","");
INSERT INTO upgrade_pistols VALUES("5","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("5","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("5","speed","2","","");
INSERT INTO upgrade_pistols VALUES("5","speed","3","","");
INSERT INTO upgrade_pistols VALUES("5","speed","4","","");
INSERT INTO upgrade_pistols VALUES("6","yron","1","","");
INSERT INTO upgrade_pistols VALUES("6","yron","2","","");
INSERT INTO upgrade_pistols VALUES("6","yron","3","","");
INSERT INTO upgrade_pistols VALUES("6","yron","4","","");
INSERT INTO upgrade_pistols VALUES("6","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("6","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("6","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("6","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("6","safety","1","","");
INSERT INTO upgrade_pistols VALUES("6","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("6","safety","3","","");
INSERT INTO upgrade_pistols VALUES("6","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("6","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("6","speed","2","","");
INSERT INTO upgrade_pistols VALUES("6","speed","3","","");
INSERT INTO upgrade_pistols VALUES("6","speed","4","","");
INSERT INTO upgrade_pistols VALUES("7","yron","1","","");
INSERT INTO upgrade_pistols VALUES("7","yron","2","","");
INSERT INTO upgrade_pistols VALUES("7","yron","3","","");
INSERT INTO upgrade_pistols VALUES("7","yron","4","","");
INSERT INTO upgrade_pistols VALUES("7","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("7","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("7","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("7","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("7","safety","1","","");
INSERT INTO upgrade_pistols VALUES("7","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("7","safety","3","","");
INSERT INTO upgrade_pistols VALUES("7","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("7","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("7","speed","2","","");
INSERT INTO upgrade_pistols VALUES("7","speed","3","","");
INSERT INTO upgrade_pistols VALUES("7","speed","4","","");
INSERT INTO upgrade_pistols VALUES("8","yron","1","","");
INSERT INTO upgrade_pistols VALUES("8","yron","2","","");
INSERT INTO upgrade_pistols VALUES("8","yron","3","","");
INSERT INTO upgrade_pistols VALUES("8","yron","4","","");
INSERT INTO upgrade_pistols VALUES("8","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("8","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("8","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("8","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("8","safety","1","","");
INSERT INTO upgrade_pistols VALUES("8","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("8","safety","3","","");
INSERT INTO upgrade_pistols VALUES("8","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("8","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("8","speed","2","","");
INSERT INTO upgrade_pistols VALUES("8","speed","3","","");
INSERT INTO upgrade_pistols VALUES("8","speed","4","","");
INSERT INTO upgrade_pistols VALUES("9","yron","1","","");
INSERT INTO upgrade_pistols VALUES("9","yron","2","","");
INSERT INTO upgrade_pistols VALUES("9","yron","3","","");
INSERT INTO upgrade_pistols VALUES("9","yron","4","","");
INSERT INTO upgrade_pistols VALUES("9","tochn","1","","");
INSERT INTO upgrade_pistols VALUES("9","tochn","2","","");
INSERT INTO upgrade_pistols VALUES("9","tochn","3","","");
INSERT INTO upgrade_pistols VALUES("9","tochn","4","","");
INSERT INTO upgrade_pistols VALUES("9","safety","1","","");
INSERT INTO upgrade_pistols VALUES("9","safety","2","","---");
INSERT INTO upgrade_pistols VALUES("9","safety","3","","");
INSERT INTO upgrade_pistols VALUES("9","safety","4"," ","");
INSERT INTO upgrade_pistols VALUES("9","speed","1","","---");
INSERT INTO upgrade_pistols VALUES("9","speed","2","","");
INSERT INTO upgrade_pistols VALUES("9","speed","3","","");
INSERT INTO upgrade_pistols VALUES("9","speed","4","","");



DROP TABLE IF EXISTS `upgrade_weapons`;

CREATE TABLE `upgrade_weapons` (
  `weapons_id` int(11) NOT NULL,
  `stat` varchar(16) DEFAULT NULL,
  `number_upgrade` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `about` varchar(256) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO upgrade_weapons VALUES("1","yron","1","","");
INSERT INTO upgrade_weapons VALUES("1","yron","2","","");
INSERT INTO upgrade_weapons VALUES("1","yron","3","","");
INSERT INTO upgrade_weapons VALUES("1","yron","4","","");
INSERT INTO upgrade_weapons VALUES("1","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("1","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("1","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("1","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("1","safety","1","","");
INSERT INTO upgrade_weapons VALUES("1","safety","2","","");
INSERT INTO upgrade_weapons VALUES("1","safety","3","","");
INSERT INTO upgrade_weapons VALUES("1","safety","4","","");
INSERT INTO upgrade_weapons VALUES("1","speed","1","","");
INSERT INTO upgrade_weapons VALUES("1","speed","2","","");
INSERT INTO upgrade_weapons VALUES("1","speed","3","","");
INSERT INTO upgrade_weapons VALUES("1","speed","4","","");
INSERT INTO upgrade_weapons VALUES("2","yron","1","","");
INSERT INTO upgrade_weapons VALUES("2","yron","2","","");
INSERT INTO upgrade_weapons VALUES("2","yron","3","","");
INSERT INTO upgrade_weapons VALUES("2","yron","4","","");
INSERT INTO upgrade_weapons VALUES("2","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("2","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("2","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("2","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("2","safety","1","","");
INSERT INTO upgrade_weapons VALUES("2","safety","2","","");
INSERT INTO upgrade_weapons VALUES("2","safety","3","","");
INSERT INTO upgrade_weapons VALUES("2","safety","4","","");
INSERT INTO upgrade_weapons VALUES("2","speed","1","","");
INSERT INTO upgrade_weapons VALUES("2","speed","2","","");
INSERT INTO upgrade_weapons VALUES("2","speed","3","","");
INSERT INTO upgrade_weapons VALUES("2","speed","4","","");
INSERT INTO upgrade_weapons VALUES("3","yron","1","","");
INSERT INTO upgrade_weapons VALUES("3","yron","2","","");
INSERT INTO upgrade_weapons VALUES("3","yron","3","","");
INSERT INTO upgrade_weapons VALUES("3","yron","4","","");
INSERT INTO upgrade_weapons VALUES("3","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("3","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("3","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("3","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("3","safety","1","","");
INSERT INTO upgrade_weapons VALUES("3","safety","2","","");
INSERT INTO upgrade_weapons VALUES("3","safety","3","","");
INSERT INTO upgrade_weapons VALUES("3","safety","4","","");
INSERT INTO upgrade_weapons VALUES("3","speed","1","","");
INSERT INTO upgrade_weapons VALUES("3","speed","2","","");
INSERT INTO upgrade_weapons VALUES("3","speed","3","","");
INSERT INTO upgrade_weapons VALUES("3","speed","4","","");
INSERT INTO upgrade_weapons VALUES("4","yron","1","","");
INSERT INTO upgrade_weapons VALUES("4","yron","2","","");
INSERT INTO upgrade_weapons VALUES("4","yron","3","","");
INSERT INTO upgrade_weapons VALUES("4","yron","4","","");
INSERT INTO upgrade_weapons VALUES("4","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("4","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("4","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("4","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("4","safety","1","","");
INSERT INTO upgrade_weapons VALUES("4","safety","2","","");
INSERT INTO upgrade_weapons VALUES("4","safety","3","","");
INSERT INTO upgrade_weapons VALUES("4","safety","4","","");
INSERT INTO upgrade_weapons VALUES("4","speed","1","","");
INSERT INTO upgrade_weapons VALUES("4","speed","2","","");
INSERT INTO upgrade_weapons VALUES("4","speed","3","","");
INSERT INTO upgrade_weapons VALUES("4","speed","4","","");
INSERT INTO upgrade_weapons VALUES("5","yron","1","","");
INSERT INTO upgrade_weapons VALUES("5","yron","2","","");
INSERT INTO upgrade_weapons VALUES("5","yron","3","","");
INSERT INTO upgrade_weapons VALUES("5","yron","4","","");
INSERT INTO upgrade_weapons VALUES("5","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("5","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("5","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("5","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("5","safety","1","","");
INSERT INTO upgrade_weapons VALUES("5","safety","2","","");
INSERT INTO upgrade_weapons VALUES("5","safety","3","","");
INSERT INTO upgrade_weapons VALUES("5","safety","4","","");
INSERT INTO upgrade_weapons VALUES("5","speed","1","","");
INSERT INTO upgrade_weapons VALUES("5","speed","2","","");
INSERT INTO upgrade_weapons VALUES("5","speed","3","","");
INSERT INTO upgrade_weapons VALUES("5","speed","4","","");
INSERT INTO upgrade_weapons VALUES("6","yron","1","","");
INSERT INTO upgrade_weapons VALUES("6","yron","2","","");
INSERT INTO upgrade_weapons VALUES("6","yron","3","","");
INSERT INTO upgrade_weapons VALUES("6","yron","4","","");
INSERT INTO upgrade_weapons VALUES("6","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("6","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("6","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("6","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("6","safety","1","","");
INSERT INTO upgrade_weapons VALUES("6","safety","2","","");
INSERT INTO upgrade_weapons VALUES("6","safety","3","","");
INSERT INTO upgrade_weapons VALUES("6","safety","4","","");
INSERT INTO upgrade_weapons VALUES("6","speed","1","","");
INSERT INTO upgrade_weapons VALUES("6","speed","2","","");
INSERT INTO upgrade_weapons VALUES("6","speed","3","","");
INSERT INTO upgrade_weapons VALUES("6","speed","4","","");
INSERT INTO upgrade_weapons VALUES("7","yron","1","","");
INSERT INTO upgrade_weapons VALUES("7","yron","2","","");
INSERT INTO upgrade_weapons VALUES("7","yron","3","","");
INSERT INTO upgrade_weapons VALUES("7","yron","4","","");
INSERT INTO upgrade_weapons VALUES("7","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("7","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("7","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("7","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("7","safety","1","","");
INSERT INTO upgrade_weapons VALUES("7","safety","2","","");
INSERT INTO upgrade_weapons VALUES("7","safety","3","","");
INSERT INTO upgrade_weapons VALUES("7","safety","4","","");
INSERT INTO upgrade_weapons VALUES("7","speed","1","","");
INSERT INTO upgrade_weapons VALUES("7","speed","2","","");
INSERT INTO upgrade_weapons VALUES("7","speed","3","","");
INSERT INTO upgrade_weapons VALUES("7","speed","4","","");
INSERT INTO upgrade_weapons VALUES("8","yron","1","","");
INSERT INTO upgrade_weapons VALUES("8","yron","2","","");
INSERT INTO upgrade_weapons VALUES("8","yron","3","","");
INSERT INTO upgrade_weapons VALUES("8","yron","4","","");
INSERT INTO upgrade_weapons VALUES("8","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("8","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("8","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("8","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("8","safety","1","","");
INSERT INTO upgrade_weapons VALUES("8","safety","2","","");
INSERT INTO upgrade_weapons VALUES("8","safety","3","","");
INSERT INTO upgrade_weapons VALUES("8","safety","4","","");
INSERT INTO upgrade_weapons VALUES("8","speed","1","","");
INSERT INTO upgrade_weapons VALUES("8","speed","2","","");
INSERT INTO upgrade_weapons VALUES("8","speed","3","","");
INSERT INTO upgrade_weapons VALUES("8","speed","4","","");
INSERT INTO upgrade_weapons VALUES("9","yron","1","","");
INSERT INTO upgrade_weapons VALUES("9","yron","2","","");
INSERT INTO upgrade_weapons VALUES("9","yron","3","","");
INSERT INTO upgrade_weapons VALUES("9","yron","4","","");
INSERT INTO upgrade_weapons VALUES("9","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("9","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("9","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("9","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("9","safety","1","","");
INSERT INTO upgrade_weapons VALUES("9","safety","2","","");
INSERT INTO upgrade_weapons VALUES("9","safety","3","","");
INSERT INTO upgrade_weapons VALUES("9","safety","4","","");
INSERT INTO upgrade_weapons VALUES("9","speed","1","","");
INSERT INTO upgrade_weapons VALUES("9","speed","2","","");
INSERT INTO upgrade_weapons VALUES("9","speed","3","","");
INSERT INTO upgrade_weapons VALUES("9","speed","4","","");
INSERT INTO upgrade_weapons VALUES("10","yron","1","","");
INSERT INTO upgrade_weapons VALUES("10","yron","2","","");
INSERT INTO upgrade_weapons VALUES("10","yron","3","","");
INSERT INTO upgrade_weapons VALUES("10","yron","4","","");
INSERT INTO upgrade_weapons VALUES("10","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("10","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("10","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("10","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("10","safety","1","","");
INSERT INTO upgrade_weapons VALUES("10","safety","2","","");
INSERT INTO upgrade_weapons VALUES("10","safety","3","","");
INSERT INTO upgrade_weapons VALUES("10","safety","4","","");
INSERT INTO upgrade_weapons VALUES("10","speed","1","","");
INSERT INTO upgrade_weapons VALUES("10","speed","2","","");
INSERT INTO upgrade_weapons VALUES("10","speed","3","","");
INSERT INTO upgrade_weapons VALUES("10","speed","4","","");
INSERT INTO upgrade_weapons VALUES("11","yron","1","","");
INSERT INTO upgrade_weapons VALUES("11","yron","2","","");
INSERT INTO upgrade_weapons VALUES("11","yron","3","","");
INSERT INTO upgrade_weapons VALUES("11","yron","4","","");
INSERT INTO upgrade_weapons VALUES("11","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("11","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("11","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("11","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("11","safety","1","","");
INSERT INTO upgrade_weapons VALUES("11","safety","2","","");
INSERT INTO upgrade_weapons VALUES("11","safety","3","","");
INSERT INTO upgrade_weapons VALUES("11","safety","4","","");
INSERT INTO upgrade_weapons VALUES("11","speed","1","","");
INSERT INTO upgrade_weapons VALUES("11","speed","2","","");
INSERT INTO upgrade_weapons VALUES("11","speed","3","","");
INSERT INTO upgrade_weapons VALUES("11","speed","4","","");
INSERT INTO upgrade_weapons VALUES("12","yron","1","","");
INSERT INTO upgrade_weapons VALUES("12","yron","2","","");
INSERT INTO upgrade_weapons VALUES("12","yron","3","","");
INSERT INTO upgrade_weapons VALUES("12","yron","4","","");
INSERT INTO upgrade_weapons VALUES("12","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("12","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("12","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("12","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("12","safety","1","","");
INSERT INTO upgrade_weapons VALUES("12","safety","2","","");
INSERT INTO upgrade_weapons VALUES("12","safety","3","","");
INSERT INTO upgrade_weapons VALUES("12","safety","4","","");
INSERT INTO upgrade_weapons VALUES("12","speed","1","","");
INSERT INTO upgrade_weapons VALUES("12","speed","2","","");
INSERT INTO upgrade_weapons VALUES("12","speed","3","","");
INSERT INTO upgrade_weapons VALUES("12","speed","4","","");
INSERT INTO upgrade_weapons VALUES("14","yron","1","","");
INSERT INTO upgrade_weapons VALUES("13","speed","3","","");
INSERT INTO upgrade_weapons VALUES("13","speed","4","","");
INSERT INTO upgrade_weapons VALUES("13","speed","1","","");
INSERT INTO upgrade_weapons VALUES("13","safety","1","","");
INSERT INTO upgrade_weapons VALUES("13","safety","3","","");
INSERT INTO upgrade_weapons VALUES("13","safety","2","","");
INSERT INTO upgrade_weapons VALUES("13","safety","4","","");
INSERT INTO upgrade_weapons VALUES("13","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("13","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("13","speed","2","","");
INSERT INTO upgrade_weapons VALUES("13","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("13","yron","3","","");
INSERT INTO upgrade_weapons VALUES("13","yron","4","","");
INSERT INTO upgrade_weapons VALUES("13","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("13","yron","1","","");
INSERT INTO upgrade_weapons VALUES("13","yron","2","","");
INSERT INTO upgrade_weapons VALUES("14","yron","2","","");
INSERT INTO upgrade_weapons VALUES("14","yron","3","","");
INSERT INTO upgrade_weapons VALUES("14","yron","4","","");
INSERT INTO upgrade_weapons VALUES("14","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("14","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("14","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("14","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("14","safety","1","","");
INSERT INTO upgrade_weapons VALUES("14","safety","3","","");
INSERT INTO upgrade_weapons VALUES("14","safety","2","","");
INSERT INTO upgrade_weapons VALUES("14","safety","4","","");
INSERT INTO upgrade_weapons VALUES("14","speed","1","","");
INSERT INTO upgrade_weapons VALUES("14","speed","2","","");
INSERT INTO upgrade_weapons VALUES("14","speed","3","","");
INSERT INTO upgrade_weapons VALUES("14","speed","4","","");
INSERT INTO upgrade_weapons VALUES("15","yron","1","","");
INSERT INTO upgrade_weapons VALUES("15","yron","2","","");
INSERT INTO upgrade_weapons VALUES("15","yron","3","","");
INSERT INTO upgrade_weapons VALUES("15","yron","4","","");
INSERT INTO upgrade_weapons VALUES("15","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("15","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("15","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("15","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("15","safety","1","","");
INSERT INTO upgrade_weapons VALUES("15","safety","3","","");
INSERT INTO upgrade_weapons VALUES("15","safety","2","","");
INSERT INTO upgrade_weapons VALUES("15","safety","4","","");
INSERT INTO upgrade_weapons VALUES("15","speed","1","","");
INSERT INTO upgrade_weapons VALUES("15","speed","2","","");
INSERT INTO upgrade_weapons VALUES("15","speed","3","","");
INSERT INTO upgrade_weapons VALUES("15","speed","4","","");
INSERT INTO upgrade_weapons VALUES("16","yron","1","","");
INSERT INTO upgrade_weapons VALUES("16","yron","2","","");
INSERT INTO upgrade_weapons VALUES("16","yron","3","","");
INSERT INTO upgrade_weapons VALUES("16","yron","4","","");
INSERT INTO upgrade_weapons VALUES("16","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("16","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("16","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("16","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("16","safety","1","","");
INSERT INTO upgrade_weapons VALUES("16","safety","3","","");
INSERT INTO upgrade_weapons VALUES("16","safety","2","","");
INSERT INTO upgrade_weapons VALUES("16","safety","4","","");
INSERT INTO upgrade_weapons VALUES("16","speed","1","","");
INSERT INTO upgrade_weapons VALUES("16","speed","2","","");
INSERT INTO upgrade_weapons VALUES("16","speed","3","","");
INSERT INTO upgrade_weapons VALUES("16","speed","4","","");
INSERT INTO upgrade_weapons VALUES("17","yron","1","","");
INSERT INTO upgrade_weapons VALUES("17","yron","2","","");
INSERT INTO upgrade_weapons VALUES("17","yron","3","","");
INSERT INTO upgrade_weapons VALUES("17","yron","4","","");
INSERT INTO upgrade_weapons VALUES("17","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("17","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("17","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("17","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("17","safety","1","","");
INSERT INTO upgrade_weapons VALUES("17","safety","3","","");
INSERT INTO upgrade_weapons VALUES("17","safety","2","","");
INSERT INTO upgrade_weapons VALUES("17","safety","4","","");
INSERT INTO upgrade_weapons VALUES("17","speed","1","","");
INSERT INTO upgrade_weapons VALUES("17","speed","2","","");
INSERT INTO upgrade_weapons VALUES("17","speed","3","","");
INSERT INTO upgrade_weapons VALUES("17","speed","4","","");
INSERT INTO upgrade_weapons VALUES("18","yron","1","","");
INSERT INTO upgrade_weapons VALUES("18","yron","2","","");
INSERT INTO upgrade_weapons VALUES("18","yron","3","","");
INSERT INTO upgrade_weapons VALUES("18","yron","4","","");
INSERT INTO upgrade_weapons VALUES("18","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("18","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("18","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("18","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("18","safety","1","","");
INSERT INTO upgrade_weapons VALUES("18","safety","3","","");
INSERT INTO upgrade_weapons VALUES("18","safety","2","","");
INSERT INTO upgrade_weapons VALUES("18","safety","4","","");
INSERT INTO upgrade_weapons VALUES("18","speed","1","","");
INSERT INTO upgrade_weapons VALUES("18","speed","2","","");
INSERT INTO upgrade_weapons VALUES("18","speed","3","","");
INSERT INTO upgrade_weapons VALUES("18","speed","4","","");
INSERT INTO upgrade_weapons VALUES("19","yron","1","","");
INSERT INTO upgrade_weapons VALUES("19","yron","2","","");
INSERT INTO upgrade_weapons VALUES("19","yron","3","","");
INSERT INTO upgrade_weapons VALUES("19","yron","4","","");
INSERT INTO upgrade_weapons VALUES("19","tochn","1","","");
INSERT INTO upgrade_weapons VALUES("19","tochn","2","","");
INSERT INTO upgrade_weapons VALUES("19","tochn","3","","");
INSERT INTO upgrade_weapons VALUES("19","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("19","safety","1","","");
INSERT INTO upgrade_weapons VALUES("19","safety","3","","");
INSERT INTO upgrade_weapons VALUES("19","safety","2","","");
INSERT INTO upgrade_weapons VALUES("19","safety","4","","");
INSERT INTO upgrade_weapons VALUES("19","speed","1","","");
INSERT INTO upgrade_weapons VALUES("19","speed","2","","");
INSERT INTO upgrade_weapons VALUES("19","speed","3","","");
INSERT INTO upgrade_weapons VALUES("19","speed","4","","");
INSERT INTO upgrade_weapons VALUES("20","yron","1","","---");
INSERT INTO upgrade_weapons VALUES("20","yron","2","","---");
INSERT INTO upgrade_weapons VALUES("20","yron","3","4 ","---");
INSERT INTO upgrade_weapons VALUES("20","yron","4","","---");
INSERT INTO upgrade_weapons VALUES("20","tochn","1","","---");
INSERT INTO upgrade_weapons VALUES("20","tochn","2","","---");
INSERT INTO upgrade_weapons VALUES("20","tochn","3","","---");
INSERT INTO upgrade_weapons VALUES("20","tochn","4","","");
INSERT INTO upgrade_weapons VALUES("20","safety","1","","---");
INSERT INTO upgrade_weapons VALUES("20","safety","2","","---");
INSERT INTO upgrade_weapons VALUES("20","safety","3","","");
INSERT INTO upgrade_weapons VALUES("20","safety","4","","---");
INSERT INTO upgrade_weapons VALUES("20","speed","1","","---");
INSERT INTO upgrade_weapons VALUES("20","speed","2","","---");
INSERT INTO upgrade_weapons VALUES("20","speed","3","","---");
INSERT INTO upgrade_weapons VALUES("20","speed","4","","---");



DROP TABLE IF EXISTS `us_ban`;

CREATE TABLE `us_ban` (
  `id` int(18) NOT NULL AUTO_INCREMENT,
  `usid` int(18) NOT NULL,
  `time` int(18) NOT NULL,
  `ip` varchar(200) NOT NULL,
  `prich` varchar(400) NOT NULL,
  `usban` int(18) NOT NULL,
  `type` enum('chat','forum','ip','mail','game') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `nick` varchar(16) NOT NULL,
  `nickcode` varchar(40) CHARACTER SET cp1251 COLLATE cp1251_bin NOT NULL,
  `password` varchar(40) NOT NULL,
  `salt` varchar(16) NOT NULL,
  `sex` varchar(16) NOT NULL,
  `gruppa` varchar(16) NOT NULL,
  `smena` int(11) NOT NULL DEFAULT '1',
  `lvl` int(11) NOT NULL DEFAULT '1',
  `new_lvl` int(11) NOT NULL,
  `money` int(11) NOT NULL DEFAULT '0',
  `slava` int(11) NOT NULL DEFAULT '0',
  `status_a` varchar(500) DEFAULT NULL,
  `timereg` datetime NOT NULL,
  `last_active` datetime NOT NULL,
  `ban` tinyint(4) NOT NULL DEFAULT '0',
  `f_ban` int(11) NOT NULL DEFAULT '0',
  `why_ban` varchar(256) DEFAULT NULL,
  `mail` varchar(40) NOT NULL,
  `avatar` varchar(20) NOT NULL,
  `aptechki` int(11) NOT NULL DEFAULT '0',
  `antirad` int(11) NOT NULL DEFAULT '0',
  `bint` int(11) NOT NULL,
  `nayk_aptechki` int(11) NOT NULL,
  `arm_aptechki` int(11) NOT NULL,
  `antirad_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sutost` int(11) NOT NULL DEFAULT '100',
  `hleb` int(11) NOT NULL,
  `kolbasa` int(11) NOT NULL,
  `konserv` int(11) NOT NULL,
  `habar` int(11) NOT NULL DEFAULT '0',
  `activ` int(11) NOT NULL DEFAULT '0',
  `opit` bigint(255) NOT NULL DEFAULT '0',
  `location` varchar(30) NOT NULL,
  `mesto` varchar(500) DEFAULT NULL,
  `hp` int(11) NOT NULL DEFAULT '100',
  `max_hp` int(11) NOT NULL DEFAULT '0',
  `hp_act` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `clan` int(11) NOT NULL DEFAULT '0',
  `clan_rang` int(11) NOT NULL DEFAULT '0',
  `clanmes` int(11) NOT NULL,
  `ko` int(11) NOT NULL DEFAULT '0',
  `invite` int(11) NOT NULL DEFAULT '0',
  `mentor_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `regen` int(11) NOT NULL DEFAULT '6',
  `mentor_type` int(11) NOT NULL DEFAULT '0',
  `read_ad` int(11) NOT NULL DEFAULT '0',
  `bronya` int(11) NOT NULL DEFAULT '600',
  `radiation` int(11) NOT NULL DEFAULT '0',
  `razriv_cl` int(11) NOT NULL DEFAULT '0',
  `monst_apt` int(11) NOT NULL DEFAULT '0',
  `sost_cl` int(11) NOT NULL,
  `yron_p` int(11) NOT NULL DEFAULT '0',
  `tochn_p` int(11) NOT NULL DEFAULT '0',
  `speed_p` int(11) NOT NULL DEFAULT '0',
  `safety_p` int(11) NOT NULL DEFAULT '0',
  `sost_p` int(11) NOT NULL DEFAULT '0',
  `time_p` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `yron_w` int(11) NOT NULL DEFAULT '0',
  `tochn_w` int(11) NOT NULL DEFAULT '0',
  `speed_w` int(11) NOT NULL DEFAULT '0',
  `safety_w` int(11) NOT NULL DEFAULT '0',
  `sost_w` int(11) NOT NULL DEFAULT '0',
  `time_w` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `message` tinyint(11) DEFAULT '0',
  `admin` int(11) NOT NULL DEFAULT '0',
  `adm_chatmes` int(11) NOT NULL,
  `news_read` int(11) NOT NULL,
  `new_news` int(11) NOT NULL,
  `m_fight` int(11) NOT NULL DEFAULT '0',
  `time_apt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `safeP` int(1) NOT NULL DEFAULT '0',
  `safeT` int(11) NOT NULL DEFAULT '0',
  `current_quest` int(1) NOT NULL,
  `quest1` int(11) NOT NULL DEFAULT '-1',
  `quest2` int(11) NOT NULL DEFAULT '-1',
  `quest3` int(11) NOT NULL DEFAULT '-1',
  `quest4` int(11) NOT NULL DEFAULT '-1',
  `quest5` int(11) NOT NULL DEFAULT '-1',
  `artefacts` int(11) NOT NULL,
  `arttime` int(11) NOT NULL,
  `artime` int(11) NOT NULL,
  `status_us` varchar(1024) NOT NULL,
  `bonus_time` int(11) NOT NULL,
  `timearena` varchar(214) NOT NULL,
  `events` int(11) NOT NULL,
  `arena_pobed` int(11) NOT NULL DEFAULT '0',
  `arena_los` int(11) NOT NULL DEFAULT '0',
  ` mytants_win` int(11) NOT NULL DEFAULT '0',
  `zadaniya` int(11) NOT NULL DEFAULT '0',
  `vzlom` int(11) NOT NULL DEFAULT '0',
  `time_bl` int(11) DEFAULT NULL,
  `time_bp` int(11) DEFAULT NULL,
  `time_sk` int(11) DEFAULT NULL,
  `uip` varchar(200) DEFAULT NULL,
  `user_agent` varchar(50) DEFAULT NULL,
  `nagrada` int(11) NOT NULL,
  `vip` int(1) NOT NULL DEFAULT '0',
  `viptime` int(50) DEFAULT NULL,
  `vibros_win` int(100) NOT NULL,
  `vibros_lose` int(100) NOT NULL,
  `vip_on` int(11) NOT NULL DEFAULT '0',
  `clan_bon` int(1) NOT NULL,
  `t_bron` int(100) NOT NULL,
  `t_hp` int(100) NOT NULL,
  `t_sila` int(100) NOT NULL,
  `b_pest` int(100) NOT NULL,
  `b_avt` int(100) NOT NULL,
  `b_hp` int(100) NOT NULL,
  `b_bron` int(100) NOT NULL,
  `ramka` int(11) NOT NULL,
  `polosa` int(11) NOT NULL,
  `diz` int(11) NOT NULL,
  `prof` int(11) NOT NULL,
  `sms` int(11) NOT NULL,
  `tainik` int(11) NOT NULL,
  `tainik_time` int(11) NOT NULL,
  `tainik_tip` int(11) NOT NULL,
  `tainiki_rat` int(11) NOT NULL,
  `zonas` int(11) NOT NULL,
  `zonas_loc` varchar(500) NOT NULL DEFAULT 'baza',
  `zonas_monstr` int(11) NOT NULL,
  `zonas_time` int(11) NOT NULL,
  `ohota` int(11) NOT NULL,
  `ohota_time` int(11) NOT NULL,
  `ohota_monster` int(11) NOT NULL,
  `ohota_chislo` int(11) NOT NULL,
  `ohota_opit` int(11) NOT NULL,
  `doktor` int(11) NOT NULL,
  `mehanik` int(11) NOT NULL,
  `razb` int(11) NOT NULL,
  `invmax` int(11) NOT NULL DEFAULT '5',
  `arenainv` int(11) NOT NULL DEFAULT '5',
  `noga_snorka` int(11) NOT NULL,
  `hvost_psa` int(11) NOT NULL,
  `hvost_sobaki` int(11) NOT NULL,
  `glas_ploti` int(11) NOT NULL,
  `sch_krovik` int(11) NOT NULL,
  `k_kabana` int(11) NOT NULL,
  `loc` varchar(500) NOT NULL DEFAULT 'skadovsk',
  `bar_game` int(11) NOT NULL DEFAULT '15',
  `game_reg` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO users VALUES("1","Nemisis","4b4f089f57010a6bb5871397014c292bb02897c8","d94b45fb14e50a3ed7451237d25517f7d0b872d7","[Nw}]Ggb/<-7Y]D0","male","naemniki","1","10","0","164595","0","","2015-10-27 03:38:08","2015-10-28 14:25:42","0","0","","nemisis@mail.ua","1.png","5","0","0","0","0","0000-00-00 00:00:00","14","0","0","0","15285","4266","58255","index","Beta Test","1378","1378","0000-00-00 00:00:00","1","9","0","60540","0","0000-00-00 00:00:00","6","0","0","1252","4","567","3","8","600","350","6","72","8","2015-10-27 04:35:53","1330","850","25","79","8","2015-10-27 05:00:45","0","1","0","0","0","0","0000-00-00 00:00:00","0","0","0","-1","-1","-1","-1","-1","0","0","0","","1446027409","","0","0","0","0","0","0","","","","178.137.250.254","Mozilla/5.0 Windows NT 6.1 AppleWebKit/537.36 KHTM","0","1","1448324469","0","0","0","0","600","600","600","0","730","778","653","0","1","0","0","0","0","0","0","1800","0","baza","0","0","0","0","0","0","0","0","0","0","5","5","0","0","3","0","0","0","skadovsk","45","1446027935");
INSERT INTO users VALUES("2","Alzair","5df489c18104d10db7471374ab0f45a0eaf9cb72","c8532438b2d58dd3ed762bd2ccaa2607dd87f0eb","Sri>%1$M%J","male","naemniki","1","12","0","252","0","","2015-10-27 04:23:04","2015-10-28 12:59:32","0","0","","Alzair555555@mail.ru","0_m.png","59","0","0","0","0","0000-00-00 00:00:00","0","1","0","0","88814","20123","314882","index","Возрождение Тьмы-онлайн-игра на мобильный","1871","3395","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","2697","13","2038","3","8","1026","388","4","83","8","2015-10-28 12:58:38","1434","770","23","82","8","2015-10-28 12:58:20","0","0","0","0","0","0","2015-10-28 08:23:30","5","1445906557","0","-1","-1","-1","-1","-1","0","0","0","","1445993938","1445969790","0","0","2","0","0","0","","","","83.220.236.184","Mozilla/5.0 Linux; Android 4.4.2; ZTE Blade G Lux ","0","0","0","0","0","0","0","600","600","600","426","834","2795","2098","0","0","0","0","0","0","0","0","36000","0","baza","0","0","1","1446022791","1","1","158","0","0","0","5","5","0","0","49","0","0","0","skadovsk","70","1446022476");
INSERT INTO users VALUES("8","zaetcz","2fd414926961641703dd583dfe2415d9a124eac9","4d18c78bdd6fad8d44987964da4f5d4956cb97f1","h@Vjw.-_&h3","male","dolg","1","8","0","0","0","","2015-10-27 17:54:03","2015-10-28 08:48:50","0","0","","zaetcz1@bk.ru","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","2441","4892","39076","me","Мой профиль","1281","1281","0000-00-00 00:00:00","0","0","0","0","0","0000-00-00 00:00:00","6","0","0","1355","13","733","3","8","1090","343","6","76","8","2015-10-27 18:38:11","600","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","-1","-1","-1","-1","-1","0","0","0","","1445954046","","0","0","0","0","0","0","","","","176.98.13.160","Mozilla/5.0 Linux; U; Android 4.2.2; ru-ru; IQ456 ","0","0","0","0","0","0","0","600","600","600","490","0","681","756","0","0","0","0","0","0","0","0","0","0","baza","0","0","0","0","0","0","0","0","0","0","5","5","0","0","7","0","0","0","skadovsk","32","1446007719");
INSERT INTO users VALUES("3","Шквал","bdbc63ebf976c252e47f33d997d4c44fc3b96fd1","3060a4f8e14c2e3f8e1486d4fd30700625066c88","UmLg.5yRK1","male","svoboda","1","10","0","423","1","","2015-10-27 06:30:02","2015-10-28 08:55:52","0","0","","Kam-Krechet@bk.ru","0_m.png","17","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","29613","4722","80516","index","Возрождение Тьмы-онлайн-игра на мобильный","927","927","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","703","2","308","3","7","600","350","6","72","7","2015-10-27 07:56:19","1363","727","25","81","7","2015-10-27 07:55:35","0","0","0","0","0","0","0000-00-00 00:00:00","5","1445914783","0","-1","-1","-1","-1","-1","0","0","0","","1446000432","1445918243","0","1","0","0","0","0","","","","195.189.120.44","Mozilla/5.0 Linux; U; Android 5.0.2; en-US; SM-G92","0","0","0","0","0","0","0","600","600","600","0","763","327","104","0","0","0","0","1","1","1446009922","1","7200","0","baza","0","0","1","1446008434","1","1","195","0","0","0","5","5","0","0","4","2","0","0","skadovsk","44","1446008093");
INSERT INTO users VALUES("4","Dragon Sad_Wind","2813777da616c8ca8abf89eaaebe81dfcc864ae5","d41f639db6718eb1f8c152ddc61dc5f44bf23c42",">cO(pQFN1<Z#V","male","svoboda","1","9","0","0","0","","2015-10-27 07:14:25","2015-10-27 15:10:33","0","0","","malisevviktor@gmail.com","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","8996","4577","52115","index","Возрождение Тьмы-онлайн-игра на мобильный","600","600","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","599","3","600","3","7","600","350","6","72","7","2015-10-27 07:51:47","1346","621","25","81","7","2015-10-27 09:47:42","0","0","0","0","0","0","0000-00-00 00:00:00","5","1445916218","0","-1","-1","-1","-1","-1","0","0","0","","1445915669","1445938538","1","0","1","0","0","0","","","","141.0.12.17","Opera/9.80 J2ME/MIDP; Opera Mini/4.4.31891/37.6781","0","0","0","0","0","0","0","600","600","600","0","746","0","0","1","0","0","0","0","0","0","0","0","0","baza","0","0","1","1445929680","1","1","171","0","0","0","5","5","0","0","7","0","0","0","skadovsk","26","1445944191");
INSERT INTO users VALUES("5","Harley Davidson","c01f38ccbd09176ca39b5d787b7fc5acae717a04","4ebfc9910573018a6544246b080b0e6d04599798","sQ)*mNz+|Ju","male","svoboda","1","5","0","6","0","","2015-10-27 07:48:26","2015-10-27 08:08:21","0","0","","martovskiyzayac000@mail.ru","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","1338","1053","10249","index","Возрождение Тьмы-онлайн-игра на мобильный","0","600","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","599","3","600","3","8","600","350","6","72","8","2015-10-27 07:59:12","600","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","0","0","0000-00-00 00:00:00","5","1445917946","0","-1","-1","-1","-1","-1","0","0","0","","1445917719","1445936612","2","0","2","0","0","0","","","","77.52.156.171","Mozilla/5.0 Linux; U; Android 4.0.4; ru-ru; ImPAD ","0","0","0","0","0","0","0","600","600","600","0","0","0","0","0","0","0","0","0","0","0","0","0","0","baza","0","0","1","1445918971","1","1","172","1","0","0","5","5","0","0","0","0","0","0","skadovsk","18","1445918636");
INSERT INTO users VALUES("6","ЧЕМПИОН","191ff892db327bd9d9f9013b8c56303d2ddf65b6","ec07a6ee09af9a0376ab2787332e14bf7576176c","975z,AKw][74%WGM","male","svoboda","1","4","0","187","0","","2015-10-27 08:45:34","2015-10-27 09:32:40","0","0","","dani4ka12398@mail.ru","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","4316","602","8307","me","Покупка рублей","1271","1271","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","1372","7","780","3","8","600","350","6","72","8","2015-10-27 08:58:32","600","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","0","0","0000-00-00 00:00:00","5","1445921735","0","-1","-1","-1","-1","-1","0","0","0","","1445921142","","0","0","0","0","0","0","","","","82.145.222.167","Opera/9.80 J2ME/MIDP; Opera Mini/8.0.35158/37.6781","0","0","0","0","0","0","0","600","600","600","0","0","671","773","0","0","0","0","0","0","0","0","0","0","baza","0","0","1","1445924243","1","1","157","0","0","0","5","5","0","0","4","0","0","0","skadovsk","23","1445923937");
INSERT INTO users VALUES("7","Пророк","acd51f09a338e96cc06d1027dbf617601c19029a","45659dcdf943338c84d28e3514be15d6bd7ccee6","a%`;LO~;KVNy","male","svoboda","1","13","0","28872","5","","2015-10-27 09:17:51","2015-10-28 15:07:28","0","0","","rkurgaev@mail.ru","0_m.png","12","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","11452","23335","498707","index","Возрождение Тьмы-онлайн-игра на мобильный","2250","3463","0000-00-00 00:00:00","0","0","0","0","0","0000-00-00 00:00:00","6","0","0","2826","20","1708","3","8","918","453","6","76","7","2015-10-28 15:06:53","1822","1369","38","64","7","2015-10-28 15:07:04","0","2","0","0","0","0","2015-10-28 00:19:45","3","1445937980","0","-1","-1","-1","-1","-1","0","0","0","","1446012128","1445969790","0","4","0","0","0","0","","","","46.0.64.24","Mozilla/5.0 iPhone; CPU iPhone OS 9_1 like Mac OS ","0","1","1446528317","0","0","0","0","600","600","600","318","1222","2863","2227","0","0","0","0","0","1","1446032245","1","7200","0","baza","0","0","1","1446030534","1","2","169","2","2","2","5","15","0","0","8","0","0","0","skadovsk","44","1446030227");
INSERT INTO users VALUES("9","Zexolus","db46e3dbe7df087901d47351be5effe62af557df","c32fd52ffa360d5c278a8af99f54839166f245e6","$sl{vD*i}wc\"","male","naemniki","1","1","0","0","0","","2015-10-27 19:54:14","2015-10-27 19:54:43","0","0","","Zexolus@gmail.com","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","99","0","0","0","3919","0","0","me","Мой профиль","600","600","0000-00-00 00:00:00","0","0","0","0","2","0000-00-00 00:00:00","6","0","0","599","3","600","0","8","600","350","6","72","8","0000-00-00 00:00:00","600","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","-1","-1","-1","-1","-1","0","0","0","","1445961264","","0","0","0","0","0","0","","","","31.13.144.1","Mozilla/5.0 Linux; Android 4.4.2; IQ4418 Build/KOT","0","0","0","0","0","0","0","600","600","600","0","0","0","0","0","0","0","0","0","0","0","0","0","0","baza","0","0","0","0","0","0","0","0","0","0","5","5","0","0","0","0","0","0","skadovsk","16","1445961255");
INSERT INTO users VALUES("10","ereretrt","e1971a5281c921a5da8a6a8a9b8cd9876e151132","5d48668989e550ad96a9bd6d72b463e4d734b475","b5w]d.8;/M","male","dolg","1","1","0","121","0","","2015-10-27 22:45:14","2015-10-27 22:45:20","0","0","","esq@6gtf6gt.ru","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","99","0","0","0","200","0","0","index","Возрождение Тьмы-онлайн-игра на мобильный","600","600","0000-00-00 00:00:00","0","0","0","0","0","0000-00-00 00:00:00","6","0","0","599","3","600","0","8","600","350","6","72","8","0000-00-00 00:00:00","600","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","-1","-1","-1","-1","-1","0","0","0","","1445971517","","0","0","0","0","0","0","","","","83.149.9.74","Mozilla/5.0 Windows NT 6.1; WOW64 AppleWebKit/537.","0","0","0","0","0","0","0","600","600","600","0","0","0","0","0","0","0","0","0","0","0","0","0","0","baza","0","0","0","0","0","0","0","0","0","0","5","5","0","0","0","0","0","0","skadovsk","16","1445971514");
INSERT INTO users VALUES("11","gisen","869ab9a32b10e840050fdbc0c26576af58a0c955","aae425e952dece7a5d719ab705063947fd9f2385",".nch>&=zkGHEH]R","male","naemniki","1","6","0","29","0","","2015-10-28 14:35:29","2015-10-28 14:47:53","0","0","","regergg@bk.ru","0_m.png","0","0","0","0","0","0000-00-00 00:00:00","0","0","0","0","337","1421","16275","index","Beta Test","600","600","0000-00-00 00:00:00","0","0","0","0","0","0000-00-00 00:00:00","6","0","0","599","3","600","3","8","600","350","6","72","8","2015-10-28 14:46:14","1334","702","42","61","8","2015-10-28 14:45:47","0","0","0","0","0","0","0000-00-00 00:00:00","5","1446028898","0","-1","-1","-1","-1","-1","0","0","0","","1446028535","","0","0","0","0","0","0","","","","195.78.101.66","Mozilla/5.0 Windows NT 6.1; WOW64 AppleWebKit/537.","0","0","0","0","0","0","0","600","600","600","0","734","0","0","0","0","0","0","0","0","0","0","0","0","baza","0","0","1","1446029828","1","1","194","0","0","0","5","5","0","0","1","0","0","0","skadovsk","18","1446029136");



DROP TABLE IF EXISTS `weapons`;

CREATE TABLE `weapons` (
  `weapons_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `max_stats_yron` int(11) NOT NULL,
  `min_stats_yron` int(11) NOT NULL,
  `max_stats_tochn` int(11) NOT NULL,
  `min_stats_tochn` int(11) NOT NULL,
  `min_stats_safety` int(11) NOT NULL DEFAULT '0',
  `max_stats_safety` int(11) NOT NULL DEFAULT '0',
  `speed` int(11) NOT NULL,
  `screen` varchar(20) NOT NULL,
  `price` int(11) NOT NULL,
  `price_hab` int(11) NOT NULL,
  `lvl_need` int(11) NOT NULL DEFAULT '0',
  `klass` int(11) NOT NULL DEFAULT '1',
  `massa` int(11) NOT NULL,
  PRIMARY KEY (`weapons_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO weapons VALUES("1","Мародерский","2299","2000","2299","2000","68","71","37","bizon.gif","2600","18000","16","3","0");
INSERT INTO weapons VALUES("2","Боевой топор","1999","1700","1999","1700","66","69","37","16.gif","2200","12000","14","2","0");
INSERT INTO weapons VALUES("3","Добротный","2599","2300","2599","2300","70","73","36","vihr.gif","3000","24000","17","3","0");
INSERT INTO weapons VALUES("4","Секач","3199","2900","3199","2900","74","77","36","AEK.gif","3800","36000","19","3","0");
INSERT INTO weapons VALUES("5","Оно","2899","2600","2899","2600","72","75","36","m807.gif","3500","33000","18","3","0");
INSERT INTO weapons VALUES("6","Обоюдоострый","3499","3200","3499","3200","76","79","36","USAS.gif","4100","43000","20","3","0");
INSERT INTO weapons VALUES("7","Клин","3799","3500","3799","3500","78","81","35","CKC.gif","4400","-1","21","4","0");
INSERT INTO weapons VALUES("8","Тесло","4099","3800","4099","3800","80","83","34","M16.gif","4700","-1","22","4","0");
INSERT INTO weapons VALUES("9","Пальштаб","4399","4100","4399","4100","82","85","34","4c.gif","5000","-1","23","4","0");
INSERT INTO weapons VALUES("10","масакари","4699","4400","4699","4400","84","87","34","val.gif","5200","-1","24","4","0");
INSERT INTO weapons VALUES("11","Топорок","4999","4700","4999","4700","86","89","33","RPK.gif","5500","-1","25","4","0");
INSERT INTO weapons VALUES("12","Арреатск","5299","5000","5299","5000","88","91","33","6c.gif","12000","-1","26","4","0");
INSERT INTO weapons VALUES("13","Ржавый топор","799","500","799","500","60","63","42","22.png","100","1000","1","1","0");
INSERT INTO weapons VALUES("14","Двусторонний","1099","800","1099","800","60","63","39","17.gif","300","3500","8","2","0");
INSERT INTO weapons VALUES("15","Балестарий","1399","1100","1399","1100","62","65","38","b9.gif","1500","5000","11","2","0");
INSERT INTO weapons VALUES("16","Гендзанику","1699","1400","1699","1400","64","67","38","a6.gif","1800","7000","13","2","0");
INSERT INTO weapons VALUES("17","Санкиса","5599","5300","5599","5300","90","93","32","groza.gif","16000","-1","27","4","0");
INSERT INTO weapons VALUES("18","Раскалыватель","6200","5900","6200","5900","95","98","30","svd.gif","22000","-1","29","4","0");
INSERT INTO weapons VALUES("19","Скартаранский","6199","5900","6199","5900","94","97","31","svu.gif","20000","-1","28","4","0");
INSERT INTO weapons VALUES("21","Священный","7500","7400","7500","7400","96","99","28","4f.gif","59400","-1","31","4","0");
INSERT INTO weapons VALUES("20","Рев Утара","8000","7900","8000","7700","96","99","27","M39.gif","87005","-1","33","4","0");
INSERT INTO weapons VALUES("22","Лунообразный","7000","6900","7000","6900","96","99","29","barret.gif","65000","-1","30","4","0");
INSERT INTO weapons VALUES("24","Широколезвийный","900","600","900","600","75","90","25","bm16.gif","-1","1500","2","1","0");
INSERT INTO weapons VALUES("25","Разрыватель душ","2700","2500","2700","2500","70","85","27","ak-74_legenda.gif","-1","15000","15","2","0");
INSERT INTO weapons VALUES("26","Крюк Мясника","10000","9900","10500","10000","100","100","12","SR.gif","100000","-1","35","4","0");



DROP TABLE IF EXISTS `worldkassa`;

CREATE TABLE `worldkassa` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID платежа (Внутренний ID)',
  `id_user` int(11) unsigned NOT NULL COMMENT 'ID пользователя',
  `id_bill` int(11) unsigned NOT NULL COMMENT 'ID платежа в Worldkassa',
  `time` int(11) unsigned NOT NULL COMMENT 'Время инициализации платежа',
  `time_oplata` int(11) unsigned DEFAULT '0' COMMENT 'Время оплаты',
  `summa` decimal(11,2) NOT NULL DEFAULT '0.00' COMMENT 'Сумма',
  `rub` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Статистика платежей через WorldKassa';




DROP TABLE IF EXISTS `zonas_boy`;

CREATE TABLE `zonas_boy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `chislo` int(11) NOT NULL,
  `ostalos` int(11) NOT NULL,
  `tip` int(11) NOT NULL,
  `hp` int(11) NOT NULL,
  `boy` varchar(500) NOT NULL DEFAULT 'on',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




